================
Halfar Test Case
================

Note: For setting up the experiments on an NCAR computing environment, follow the steps in the README.NCAR_HPC file in the tests directory.

This directory contains Python scripts for running an experiment involving an
ice sheet with a "dome" shape on a flat base.  The time evolution of this dome
shape using the shallow-ice approximation has an analytic solution.  For
details, see: 
* Halfar, P. 1983. On the Dynamics of the Ice Sheets 2.  Journal of Geophysical
  Research, 88, 6043-6051.

You will need to either copy your executable into this directory, have the
executable in your path, or create a symbolic link to your executable, using:

```sh
ln -s ../../builds/platform-compiler/cism_driver/cism_driver ./
```

runHalfar.py
---------
To run the experiment, execute the `runHalfar.py` script.  The basic usage is
simply:

```sh
./runHalfar.py
```

but advanced commandline options are available.  For details, execute:

```sh
./runHalfar.py --help
```

The test should only take a few seconds for the default run duration of 200
years.

The script creates a netCDF input file for CISM and then runs CISM, generating a
netCDF output file.  Input and output `*.nc` files are written into the
`output` subdirectory, which is controlled by the `-o/--output-dir` option.


halfar_results.py
-----------------

To compare the results to the analytic solution, run the `halfar_results.py`
script:

```sh
./halfar_results.py
```

Once again, advanced options are available and can be listed with:

```sh
./halfar_results.py --help
```

This script will generate some basic statistics about the error in the model
relative to the analytic solution and display maps of the modeled and analytic
thickness and the model error.  For example, the defaults `halfar.config`
settings will run the model for 200 years, giving the following error
statistics on my Mac:

```
Error statistics for cells modeled to have ice (in m):
* RMS error = 6.43270636395
* Maximum error is 32.7457467599
* Minimum error is -31.1007361578
* Mean error is 1.36812809949
* Median error is 0.772963551588
* Mean absolute error = 2.73927159538
* Median absolute error = 1.06418727609
```


Higher order
------------

As mentioned above, the analytic solution is only valid for the shallow-ice
approximation.  However, if desired the test may be run with the first-order
Glissade dycore.  To do so, use the `halfar-HO.config` file:

```sh
./runHalfar.py -c halfar-HO.config
```

In this case, the model output should not be expected to match the analytic
solution, but results will be reasonably close (using a no-slip basal boundary
condition, anyway).  The test should take no more than a few minutes for the
default run duration of 200 years.


PREREQUISITES:
--------------

The `cism_driver` executable must be available to the `runHalfar.py` script, which 
assumes it is in the current directoy.  The easiest way to do this is to link it 
into this directory, e.g.:

```sh
ln -s ../../builds/mac-gnu/cism_driver/cism_driver
```

but you can also use the `-e/--executable` commandline option with the script
to specify another location.

In order to use the two scripts, you will need to have Python and one of the
following three Python modules installed:
* Scientific.IO.NetCDF
* netCDF4
* pycdf

as well as both of these Python modules:
*  numpy
*  matplotlib

(CISM is developed and tested with Python 2.7)

To view detailed results beyond the simple plot and statistics generated by 
`halfar_results.py` use ncview or another utility for viewing netCDF files.

Note: the `halfarDome` function in  `runHalfar.py` is used in `halfar_results.py`
to perform the analytic calculation of the dome shape.  It is here that you can
change the size and other properties of the dome if you would like.

(last edited on 2-8-14 by MJH)
