// swmm5_iface.h
//
// Header file for SWMM 5 interfacing functions
//
// #include this file in any C module that references the functions
// contained in swmm5_iface.c.
//
extern long   SWMM_Nperiods;           // number of reporting periods
extern long   SWMM_FlowUnits;          // flow units code
extern long   SWMM_Nsubcatch;          // number of subcatchments
extern long   SWMM_Nnodes;             // number of drainage system nodes
extern long   SWMM_Nlinks;             // number of drainage system links
extern long   SWMM_Npolluts;           // number of pollutants tracked
extern double SWMM_StartDate;          // start date of simulation
extern long   SWMM_ReportStep;         // reporting time step (seconds)

int    RunSwmmExe(char* cmdLine);
int    RunSwmmDll(char* inpFile, char* rptFile, char* outFile);
int    OpenSwmmOutFile(char* outFile);
int    GetSwmmResult(int iType, int iIndex, int vIndex, int period, float* value);
void   CloseSwmmOutFile(void);
