/*
 * Decompiled with CFR 0.152.
 */
package Richards1DSolver;

import Richards1DSolver.Richards1DSolver;
import java.util.ArrayList;
import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Bibliography;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.License;
import oms3.annotations.Out;
import oms3.annotations.Unit;
import physicalquantities.Variables;
import soilparameters.SoilParameters;

@Description(value="Solve the Richards equation for the 1D domain.")
@Documentation(value="")
@Author(name="Niccolo' Tubini, and Riccardo Rigon", contact="tubini.niccolo@gmail.com")
@Keywords(value="Hydrology, Richards, Infiltration")
@Bibliography(value={"Casulli (2010)"})
@License(value="General Public License Version 3 (GPLv3)")
public class CallRichardsSolver {
    @Description(value="The hydraulic conductivity at saturation")
    @In
    @Unit(value="m/s")
    public double[] ks;
    @Description(value="Saturated water content")
    @In
    @Unit(value="-")
    public double[] thetaS;
    @Description(value="Residual water content")
    @In
    @Unit(value="-")
    public double[] thetaR;
    @Description(value="First parameter of SWRC")
    @In
    @Unit(value="-")
    public double[] par1SWRC;
    @Description(value="Second parameter of SWRC")
    @In
    @Unit(value="-")
    public double[] par2SWRC;
    @Description(value="Third parameter of SWRC")
    @In
    @Unit(value="-")
    public double[] par3SWRC;
    @Description(value="Fourth parameter of SWRC")
    @In
    @Unit(value="-")
    public double[] par4SWRC;
    @Description(value="Fifth parameter of SWRC")
    @In
    @Unit(value="-")
    public double[] par5SWRC;
    @Description(value="Critical value of psi for which the moisture capacity is null")
    @In
    @Unit(value="m")
    public double[] psiStar1;
    @Description(value="Critical value of psi for which the moisture capacity is null")
    @In
    @Unit(value="m")
    public double[] psiStar2;
    @Description(value="Critical value of psi for which the moisture capacity is null")
    @In
    @Unit(value="m")
    public double[] psiStar3;
    @Description(value="Aquitard compressibility")
    @In
    @Unit(value="1/Pa")
    public double[] alphaSpecificStorage;
    @Description(value="Water compressibility")
    @In
    @Unit(value="1/Pa")
    public double[] betaSpecificStorage;
    @Description(value="Soil temperature assumed to be constant over the domain and in time")
    @In
    @Unit(value="K")
    public double T = 293.15;
    @Description(value="Coefficient for water suction dependence on temperature")
    @In
    @Unit(value="K")
    public double beta0 = -776.45;
    @Description(value="Reference temperature for soil water content")
    @In
    @Unit(value="K")
    public double temperatureR = 278.15;
    @Description(value="It is possibile to chose between 3 different models to compute the soil hydraulic properties: Van Genuchten; Brooks and Corey; Kosugi unimodal")
    @In
    public String soilHydraulicModel;
    @Description(value="It is possible to choose among these models:notemperature, ....")
    @In
    public String typeUHCTemperatureModel;
    @Description(value="It is possible to choose among these models:Mualem Van Genuchten, Mualem Brooks Corey, ....")
    @In
    public String typeUHCModel;
    @Description(value="Hydraulic conductivity at control volume interface can be evaluated as the average of kappas[i] and kappas[i+1] the maximum between kappas[i] and kappas[i+1] the minimum between kappas[i] and kappas[i+1] a weighted average of kappas[i] and kappas[i+1] where weights are dx[i] and dx[i+1]")
    @In
    public String interfaceHydraulicCondType;
    @Description(value="Number of Picard iteration to update the diffusive flux matrix")
    @In
    public int picardIteration = 1;
    @Description(value="Coefficient to simulate ET by making use of Casulli's formula")
    @In
    @Unit(value="1/s")
    public double[] et;
    @Description(value="Initial condition for water head read from grid NetCDF file")
    @In
    @Unit(value="m")
    public double[] psiIC;
    @Description(value="z coordinate read from grid NetCDF file")
    @In
    @Unit(value="m")
    public double[] z;
    @Description(value="Space delta to compute gradients read from grid NetCDF file")
    @In
    @Unit(value="m")
    public double[] spaceDeltaZ;
    @Description(value="Length of control volumes read from grid NetCDF file")
    @In
    @Unit(value="m")
    public double[] deltaZ;
    @Description(value="Time amount at every time-loop")
    @In
    @Unit(value="s")
    public double tTimestep;
    @Description(value="Time step of integration")
    @In
    @Unit(value="s")
    public double timeDelta;
    @Description(value="Tolerance for Newton iteration")
    @In
    public double newtonTolerance;
    @Description(value="Control parameter for nested Newton algorithm:0 --> simple Newton method1 --> nested Newton method")
    @In
    public int nestedNewton;
    @Description(value="Slope of the soil")
    @In
    @Unit(value="sexagesimal degrees")
    public double delta;
    @Description(value="The HashMap with the time series of the boundary condition at the top of soil column")
    @In
    @Unit(value="m")
    public HashMap<Integer, double[]> inTopBC;
    @Description(value="It is possibile to chose between 2 different kind of boundary condition at the top of the domain: - Dirichlet boundary condition --> Top Dirichlet- Neumann boundary condition --> Top Neumann")
    @In
    public String topBCType;
    @Description(value="The HashMap with the time series of the boundary condition at the bottom of soil column")
    @In
    @Unit(value="m")
    public HashMap<Integer, double[]> inBottomBC;
    @Description(value="It is possibile to chose among 3 different kind of boundary condition at the bottom of the domain: - Dirichlet boundary condition --> Bottom Dirichlet- Neumann boundary condition --> Bottom Neumann- Impervious boundary condition --> Bottom Impervious")
    @In
    public String bottomBCType;
    @Description(value="The current date of the simulation.")
    @In
    @Out
    public String inCurrentDate;
    @Description(value="Path of output files")
    @In
    public String dir;
    @Description(value="ArrayList of variable to be stored in the buffer writer")
    @Out
    public ArrayList<double[]> outputToBuffer;
    @Description(value="Maximun number of Newton iterations")
    final int MAXITER_NEWT = 50;
    @Description(value="Top boundary condition according with topBCType")
    @Unit(value="")
    double topBC;
    @Description(value="Bottom boundary condition according with bottomBCType")
    @Unit(value="")
    double bottomBC;
    @Description(value="Number of control volume for domain discetrization")
    @Unit(value=" ")
    int NUM_CONTROL_VOLUMES;
    @Description(value="It is needed to iterate on the date")
    int step;
    Richards1DSolver richardsSolver;

    @Execute
    public void solve() {
        System.out.println("RICHARDS 1D " + this.inCurrentDate);
        if (this.step == 0) {
            double[] temperature = new double[this.psiIC.length];
            for (int i = 0; i < this.psiIC.length; ++i) {
                temperature[i] = this.T;
            }
            this.NUM_CONTROL_VOLUMES = this.psiIC.length;
            Variables variables = Variables.getInstance((double[])this.psiIC, (double[])temperature);
            SoilParameters soilParameters = SoilParameters.getInstance((double[])this.alphaSpecificStorage, (double[])this.betaSpecificStorage, (double[])this.ks, (double[])this.par1SWRC, (double[])this.par2SWRC, (double[])this.par3SWRC, (double[])this.par4SWRC, (double[])this.par5SWRC, (double[])this.psiStar1, (double[])this.psiStar2, (double[])this.psiStar3, (double[])this.thetaR, (double[])this.thetaS, null, null);
            this.richardsSolver = new Richards1DSolver(this.soilHydraulicModel, this.typeUHCModel, this.typeUHCTemperatureModel, this.topBCType, this.bottomBCType, this.interfaceHydraulicCondType, this.NUM_CONTROL_VOLUMES, this.nestedNewton, this.newtonTolerance, 50, this.picardIteration, this.tTimestep, this.deltaZ, this.spaceDeltaZ, this.psiIC, this.beta0, this.temperatureR);
            this.outputToBuffer = new ArrayList();
        }
        this.topBC = 0.0;
        this.topBC = this.inTopBC.get(1)[0] / 1000.0 / this.tTimestep;
        this.bottomBC = 0.0;
        if (this.inBottomBC != null) {
            this.bottomBC = this.inBottomBC.get(1)[0];
        }
        if (this.bottomBCType.equalsIgnoreCase("Bottom Neumann") || this.bottomBCType.equalsIgnoreCase("BottomNeumann")) {
            this.bottomBC /= this.tTimestep;
        }
        this.outputToBuffer.clear();
        for (double sumTimeDelta = 0.0; sumTimeDelta < this.tTimestep; sumTimeDelta += this.timeDelta) {
            if (sumTimeDelta + this.timeDelta > this.tTimestep) {
                this.timeDelta = this.tTimestep - sumTimeDelta;
            }
            this.richardsSolver.solve(this.topBC, this.bottomBC, this.inCurrentDate, this.timeDelta);
        }
        this.outputToBuffer.add(Variables.waterSuctions);
        this.outputToBuffer.add(Variables.thetas);
        this.outputToBuffer.add(this.psiIC);
        this.outputToBuffer.add(Variables.darcyVelocities);
        this.outputToBuffer.add(Variables.darcyVelocitiesCapillary);
        this.outputToBuffer.add(Variables.darcyVelocitiesGravity);
        this.outputToBuffer.add(Variables.poreVelocities);
        this.outputToBuffer.add(Variables.celerities);
        this.outputToBuffer.add(Variables.kinematicRatio);
        this.outputToBuffer.add(new double[]{Variables.errorVolume});
        this.outputToBuffer.add(new double[]{this.topBC * this.tTimestep * 1000.0});
        if (this.bottomBCType.equalsIgnoreCase("Bottom Neumann") || this.bottomBCType.equalsIgnoreCase("BottomNeumann")) {
            this.bottomBC *= this.tTimestep;
        }
        this.outputToBuffer.add(new double[]{this.bottomBC});
        this.outputToBuffer.add(new double[]{this.topBC + Variables.darcyVelocities[this.NUM_CONTROL_VOLUMES - 1]});
        ++this.step;
    }
}

