/*
 * Decompiled with CFR 0.152.
 */
package Richards1DSolver;

import interfaceconductivity.InterfaceConductivity;
import interfaceconductivity.SimpleInterfaceConductivityFactory;
import oms3.annotations.Author;
import oms3.annotations.Bibliography;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Keywords;
import oms3.annotations.License;
import oms3.annotations.Unit;
import physicalquantities.Variables;
import richardsboundaryconditions.BoundaryCondition;
import richardsboundaryconditions.SimpleBoundaryConditionFactory;
import richardsclasses.ComputeDerivedQuantities;
import richardsclasses.NestedNewton;
import richardsclasses.TotalDepth;
import swrc.SoilWaterRetentionCurve;
import swrc.SoilWaterRetentionCurveFactory;
import swrc.SoilWaterRetentionCurveTemperatureFactory;
import unsaturatedhydraulicconductivity.UnsaturatedHydraulicConductivity;
import unsaturatedhydraulicconductivity.UnsaturatedHydraulicConductivityFactory;
import unsaturatedhydraulicconductivity.UnsaturatedHydraulicConductivityTemperatureFactory;

@Description(value="Solve the Richards equation for the 1D domain.")
@Documentation(value="")
@Author(name="Niccolo' Tubini, and Riccardo Rigon", contact="tubini.niccolo@gmail.com")
@Keywords(value="Hydrology, Richards, Infiltration")
@Bibliography(value={"Casulli (2010)"})
@License(value="General Public License Version 3 (GPLv3)")
public class Richards1DSolver2 {
    public int picardIteration = 1;
    public double[] psiIC;
    @Description(value="Time step of integration")
    @Unit(value="s")
    public double timeDelta;
    @Description(value="Tolerance for Newton iteration")
    public double newtonTolerance;
    public int nestedNewton;
    public double delta;
    public String topBCType;
    public String bottomBCType;
    @Description(value="Maximun number of Newton iterations")
    final int MAXITER_NEWT = 50;
    @Description(value="Top boundary condition according with topBCType")
    @Unit(value="")
    double topBC;
    @Description(value="Bottom boundary condition according with bottomBCType")
    @Unit(value="")
    double bottomBC;
    @Description(value="Total volume at time level n")
    @Unit(value="-")
    double volume;
    @Description(value="Total volume at time level n+1")
    @Unit(value="-")
    double volumeNew;
    @Description(value="Volume error between time levels n+1 and n")
    @Unit(value="-")
    double errorVolume;
    @Description(value="Vector collects the lower diagonal entries of the coefficient matrix")
    @Unit(value="?")
    double[] lowerDiagonal;
    @Description(value="Vector collects the main diagonal entries of the coefficient matrix")
    @Unit(value="?")
    double[] mainDiagonal;
    @Description(value="Vector collects the upper diagonal entries of the coefficient matrix")
    @Unit(value="?")
    double[] upperDiagonal;
    @Description(value="Right hand side vector of the scalar equation to solve")
    @Unit(value="-")
    double[] rhss;
    @Description(value="Hydraulic conductivity at the cell interface i+1/2")
    @Unit(value="m/s")
    double kP;
    @Description(value="Hydraulic conductivity at the cell interface i-1/2")
    @Unit(value="m/s")
    double kM;
    @Description(value="Number of control volume for domain discetrization")
    @Unit(value=" ")
    int NUM_CONTROL_VOLUMES;
    @Description(value="Space step")
    @Unit(value="m")
    double[] spaceDelta;
    @Description(value="Vector containing the length of each control volume")
    double[] dx;
    @Description(value="Object to perform the nested Newton algortithm")
    NestedNewton nestedNewtonAlg;
    @Description(value="Object dealing with SWRC model")
    SoilWaterRetentionCurve soilWaterRetentionCurve;
    SoilWaterRetentionCurveFactory soilWaterRetentionCurveFactory = new SoilWaterRetentionCurveFactory();
    SoilWaterRetentionCurveTemperatureFactory soilWaterRetentionCurveTemperatureFactory;
    @Description(value="Object dealing with unsaturated hydraulic conductivity model")
    UnsaturatedHydraulicConductivity unsaturatedHydraulicConductivity;
    UnsaturatedHydraulicConductivityFactory unsaturatedHydraulicConductivityFactory;
    UnsaturatedHydraulicConductivityTemperatureFactory unsaturatedHydraulicConductivityTemperatureFactory;
    @Description(value="Object to compute total water depth")
    TotalDepth totalDepth;
    @Description(value="This object compute the diagonal and right hand side entries for the uppermost cell accordingly with the prescribed top boundary condition.")
    BoundaryCondition topBoundaryCondition;
    @Description(value="This object compute the diagonal and right hand side entries for the lowermost cell accordingly with the prescribed bottom boundary condition.")
    BoundaryCondition bottomBoundaryCondition;
    @Description(value="This object compute hydraulic quantities.")
    ComputeDerivedQuantities compute;
    @Description(value="This object compute the interface hydraulic conductivity accordingly with the prescribed method.")
    InterfaceConductivity interfaceHydraulicConductivity;

    public Richards1DSolver2(String soilHydraulicModel, String typeUHCModel, String typeUHCTemperatureModel, String topBCType, String bottomBCType, String interfaceHydraulicCondType, int NUM_CONTROL_VOLUMES, int nestedNewton, double newtonTolerance, int MAXITER_NEWT, int picardIteration, double tTimestep, double[] deltaZ, double[] spaceDeltaZ, double[] psiIC, double beta0, double temperatureR) {
        this.soilWaterRetentionCurve = this.soilWaterRetentionCurveFactory.createSoilParametrization(soilHydraulicModel, beta0, temperatureR);
        this.unsaturatedHydraulicConductivityFactory = new UnsaturatedHydraulicConductivityFactory();
        this.unsaturatedHydraulicConductivityTemperatureFactory = new UnsaturatedHydraulicConductivityTemperatureFactory();
        this.unsaturatedHydraulicConductivityFactory = new UnsaturatedHydraulicConductivityFactory();
        this.unsaturatedHydraulicConductivity = this.unsaturatedHydraulicConductivityFactory.createUnsaturatedHydraulicConductivity(typeUHCModel, this.soilWaterRetentionCurve);
        this.unsaturatedHydraulicConductivity = this.unsaturatedHydraulicConductivityTemperatureFactory.create(typeUHCTemperatureModel, this.soilWaterRetentionCurve, this.unsaturatedHydraulicConductivity);
        this.totalDepth = new TotalDepth();
        SimpleBoundaryConditionFactory boundCondFactory = new SimpleBoundaryConditionFactory();
        this.psiIC = psiIC;
        this.topBCType = topBCType;
        this.bottomBCType = bottomBCType;
        this.topBoundaryCondition = boundCondFactory.createBoundaryCondition(topBCType);
        this.bottomBoundaryCondition = boundCondFactory.createBoundaryCondition(bottomBCType);
        SimpleInterfaceConductivityFactory interfaceConductivityFactory = new SimpleInterfaceConductivityFactory();
        this.interfaceHydraulicConductivity = interfaceConductivityFactory.createInterfaceConductivity(interfaceHydraulicCondType);
        this.dx = new double[NUM_CONTROL_VOLUMES];
        this.spaceDelta = spaceDeltaZ;
        for (int i = 0; i < NUM_CONTROL_VOLUMES - 1; ++i) {
            this.dx[i] = deltaZ[i];
        }
        this.dx[NUM_CONTROL_VOLUMES - 1] = deltaZ[deltaZ.length - 1];
        this.picardIteration = picardIteration;
        this.NUM_CONTROL_VOLUMES = NUM_CONTROL_VOLUMES;
        this.compute = new ComputeDerivedQuantities(NUM_CONTROL_VOLUMES, this.dx, this.spaceDelta, this.soilWaterRetentionCurve, this.unsaturatedHydraulicConductivity, this.totalDepth, this.interfaceHydraulicConductivity, bottomBCType);
        this.nestedNewtonAlg = new NestedNewton(nestedNewton, newtonTolerance, MAXITER_NEWT, NUM_CONTROL_VOLUMES, deltaZ, this.soilWaterRetentionCurve, this.totalDepth);
        this.delta = this.delta * Math.PI / 180.0;
        this.lowerDiagonal = new double[NUM_CONTROL_VOLUMES];
        this.mainDiagonal = new double[NUM_CONTROL_VOLUMES];
        this.upperDiagonal = new double[NUM_CONTROL_VOLUMES];
        this.rhss = new double[NUM_CONTROL_VOLUMES];
        this.kP = 0.0;
        this.kM = 0.0;
    }

    public void solve(double topBC, double bottomBC, String inCurrentDate, double timeDelta) {
        System.out.println("RICHARDS 1D " + inCurrentDate);
        this.timeDelta = timeDelta;
        for (int picard = 0; picard < this.picardIteration; ++picard) {
            this.compute.setComputeDerivedQuantities(bottomBC);
            this.volume = this.compute.computeTotalWaterVolumes();
            this.compute.computeKappas();
            for (int i = 0; i < this.NUM_CONTROL_VOLUMES; ++i) {
                if (i == 0) {
                    this.kP = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappas[i + 1], this.dx[i], this.dx[i + 1]);
                    this.kM = this.bottomBCType.equalsIgnoreCase("Bottom Free Drainage") || this.bottomBCType.equalsIgnoreCase("BottomFreeDrainage") ? Variables.kappas[i] : (this.bottomBCType.equalsIgnoreCase("Bottom Neumann") || this.bottomBCType.equalsIgnoreCase("BottomNeumann") ? -999.0 : this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappaBottom, this.dx[i], this.dx[i]));
                    this.lowerDiagonal[i] = this.bottomBoundaryCondition.lowerDiagonal(-999.0, this.kP, this.kM, this.spaceDelta[i + 1], this.spaceDelta[i], timeDelta, this.delta);
                    this.mainDiagonal[i] = this.bottomBoundaryCondition.mainDiagonal(-999.0, this.kP, this.kM, this.spaceDelta[i + 1], this.spaceDelta[i], timeDelta, this.delta);
                    this.upperDiagonal[i] = this.bottomBoundaryCondition.upperDiagonal(-999.0, this.kP, this.kM, this.spaceDelta[i + 1], this.spaceDelta[i], timeDelta, this.delta);
                    this.rhss[i] = Variables.volumes[i] + this.bottomBoundaryCondition.rightHandSide(bottomBC, this.kP, this.kM, this.spaceDelta[i + 1], this.spaceDelta[i], timeDelta, this.delta);
                    continue;
                }
                if (i == this.NUM_CONTROL_VOLUMES - 1) {
                    this.kP = 0.0;
                    this.kM = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappas[i - 1], this.dx[i], this.dx[i - 1]);
                    this.lowerDiagonal[i] = this.topBoundaryCondition.lowerDiagonal(-999.0, this.kP, this.kM, this.spaceDelta[i], this.spaceDelta[i - 1], timeDelta, this.delta);
                    this.mainDiagonal[i] = this.topBoundaryCondition.mainDiagonal(-999.0, this.kP, this.kM, this.spaceDelta[i], this.spaceDelta[i - 1], timeDelta, this.delta);
                    this.upperDiagonal[i] = this.topBoundaryCondition.upperDiagonal(-999.0, this.kP, this.kM, this.spaceDelta[i], this.spaceDelta[i - 1], timeDelta, this.delta);
                    this.rhss[i] = Variables.volumes[i] + this.topBoundaryCondition.rightHandSide(topBC, this.kP, this.kM, this.spaceDelta[i], this.spaceDelta[i - 1], timeDelta, this.delta);
                    continue;
                }
                this.kP = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappas[i + 1], this.dx[i], this.dx[i + 1]);
                this.kM = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappas[i - 1], this.dx[i], this.dx[i - 1]);
                this.lowerDiagonal[i] = -this.kM * timeDelta / this.spaceDelta[i] * 1.0 / Math.pow(Math.cos(this.delta), 2.0);
                this.mainDiagonal[i] = this.kM * timeDelta / this.spaceDelta[i] * 1.0 / Math.pow(Math.cos(this.delta), 2.0) + this.kP * timeDelta / this.spaceDelta[i + 1] * 1.0 / Math.pow(Math.cos(this.delta), 2.0);
                this.upperDiagonal[i] = -this.kP * timeDelta / this.spaceDelta[i + 1] * 1.0 / Math.pow(Math.cos(this.delta), 2.0);
                this.rhss[i] = Variables.volumes[i] + timeDelta * (this.kP - this.kM);
            }
            this.nestedNewtonAlg.set(this.mainDiagonal, this.upperDiagonal, this.lowerDiagonal, this.rhss);
            this.nestedNewtonAlg.solver();
            this.compute.computeDarcyVelocities();
            this.compute.computeDarcyVelocitiesCapillary();
            this.compute.computeDarcyVelocitiesGravity();
            this.compute.computePoreVelocities();
            this.compute.computeCelerity();
            this.compute.computeKinematicRatio();
            this.compute.computeWaterVolumes();
            this.volumeNew = this.compute.computeTotalWaterVolumes();
            this.compute.computeThetas();
            Variables.errorVolume = this.volumeNew - this.volume - timeDelta * (topBC + Variables.darcyVelocities[0]);
        }
    }
}

