/*
 * Decompiled with CFR 0.152.
 */
package richardsboundaryconditions;

import richardsboundaryconditions.BoundaryCondition;

public class BottomBoundaryConditionDirichlet
extends BoundaryCondition {
    @Override
    public double upperDiagonal(double bC, double kP, double kM, double spaceDeltaP, double spaceDeltaM, double timeDelta, double delta) {
        this.bC = bC;
        this.kP = kP;
        this.kM = kM;
        this.spaceDeltaP = spaceDeltaP;
        this.spaceDeltaM = spaceDeltaM;
        this.timeDelta = timeDelta;
        this.delta = delta;
        this.term = -this.kP * this.timeDelta / this.spaceDeltaP * 1.0 / Math.pow(Math.cos(this.delta), 2.0);
        return this.term;
    }

    @Override
    public double mainDiagonal(double bC, double kP, double kM, double spaceDeltaP, double spaceDeltaM, double timeDelta, double delta) {
        this.bC = bC;
        this.kP = kP;
        this.kM = kM;
        this.spaceDeltaP = spaceDeltaP;
        this.spaceDeltaM = spaceDeltaM;
        this.timeDelta = timeDelta;
        this.delta = delta;
        this.term = this.kM * this.timeDelta / this.spaceDeltaM * 1.0 / Math.pow(Math.cos(this.delta), 2.0) + this.kP * this.timeDelta / this.spaceDeltaP * 1.0 / Math.pow(Math.cos(this.delta), 2.0);
        return this.term;
    }

    @Override
    public double lowerDiagonal(double bC, double kP, double kM, double spaceDeltaP, double spaceDeltaM, double timeDelta, double delta) {
        this.bC = bC;
        this.kP = kP;
        this.kM = kM;
        this.spaceDeltaP = spaceDeltaP;
        this.spaceDeltaM = spaceDeltaM;
        this.timeDelta = timeDelta;
        this.delta = delta;
        this.term = 0.0;
        return this.term;
    }

    @Override
    public double rightHandSide(double bC, double kP, double kM, double spaceDeltaP, double spaceDeltaM, double timeDelta, double delta) {
        this.bC = bC;
        this.kP = kP;
        this.kM = kM;
        this.spaceDeltaP = spaceDeltaP;
        this.spaceDeltaM = spaceDeltaM;
        this.timeDelta = timeDelta;
        this.delta = delta;
        this.term = this.timeDelta * (this.kP - this.kM) + this.kM * this.timeDelta / this.spaceDeltaM * 1.0 / Math.pow(Math.cos(this.delta), 2.0) * this.bC;
        return this.term;
    }
}

