/*
 * Decompiled with CFR 0.152.
 */
package richardsclasses;

import interfaceconductivity.InterfaceConductivity;
import physicalquantities.Variables;
import richardsclasses.TotalDepth;
import soilparameters.SoilParameters;
import swrc.SoilWaterRetentionCurve;
import unsaturatedhydraulicconductivity.UnsaturatedHydraulicConductivity;

public class ComputeDerivedQuantities {
    int NUM_CONTROL_VOLUMES;
    double kM;
    double kP;
    double bottomBC;
    double k_b;
    double volume;
    double[] spaceDelta;
    double[] dx;
    String bottomBCType;
    SoilWaterRetentionCurve soilWaterRetentionCurve;
    UnsaturatedHydraulicConductivity unsaturatedHydraulicConductivity;
    TotalDepth totalDepth;
    InterfaceConductivity interfaceHydraulicConductivity;

    public ComputeDerivedQuantities(int NUM_CONTROL_VOLUMES, double[] dx, double[] spaceDelta, SoilWaterRetentionCurve soilWaterRetentionCurve, UnsaturatedHydraulicConductivity unsaturatedHydraulicConductivity, TotalDepth totalDepth, InterfaceConductivity interfaceHydraulicConductivity, String bottomBCType) {
        this.NUM_CONTROL_VOLUMES = NUM_CONTROL_VOLUMES;
        this.spaceDelta = spaceDelta;
        this.dx = dx;
        this.soilWaterRetentionCurve = soilWaterRetentionCurve;
        this.unsaturatedHydraulicConductivity = unsaturatedHydraulicConductivity;
        this.totalDepth = totalDepth;
        this.interfaceHydraulicConductivity = interfaceHydraulicConductivity;
        this.bottomBCType = bottomBCType;
    }

    public void setComputeDerivedQuantities(double bottomBC) {
        this.bottomBC = bottomBC;
    }

    public void computeThetasOld() {
        for (int i = 0; i < this.NUM_CONTROL_VOLUMES; ++i) {
            Variables.thetasOld[i] = i == this.NUM_CONTROL_VOLUMES - 1 ? this.totalDepth.totalDepth(Variables.waterSuctions[i]) : this.soilWaterRetentionCurve.waterContent(i);
        }
    }

    public void computeThetas() {
        for (int i = 0; i < this.NUM_CONTROL_VOLUMES; ++i) {
            Variables.thetas[i] = i == this.NUM_CONTROL_VOLUMES - 1 ? this.totalDepth.totalDepth(Variables.waterSuctions[i]) : this.soilWaterRetentionCurve.waterContent(i);
        }
    }

    public void computeKappas() {
        Variables.kappaBottom = this.unsaturatedHydraulicConductivity.hydraulicConductivity(this.bottomBC, 0);
        for (int i = 0; i < this.NUM_CONTROL_VOLUMES; ++i) {
            Variables.kappas[i] = i == this.NUM_CONTROL_VOLUMES - 1 ? this.unsaturatedHydraulicConductivity.hydraulicConductivity(Variables.waterSuctions[i], i - 1) : this.unsaturatedHydraulicConductivity.hydraulicConductivity(i);
        }
    }

    public void computeWaterVolumes() {
        for (int i = 0; i < this.NUM_CONTROL_VOLUMES; ++i) {
            Variables.volumes[i] = i == this.NUM_CONTROL_VOLUMES - 1 ? this.totalDepth.totalDepth(Variables.waterSuctions[i]) : this.soilWaterRetentionCurve.waterContent(i) * this.dx[i];
        }
    }

    public double computeTotalWaterVolumes() {
        this.volume = 0.0;
        for (int i = 0; i < this.NUM_CONTROL_VOLUMES; ++i) {
            this.volume += Variables.volumes[i];
        }
        return this.volume;
    }

    public void computeDarcyVelocities() {
        for (int i = 0; i < this.NUM_CONTROL_VOLUMES; ++i) {
            if (i == 0) {
                this.kP = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappas[i + 1], this.dx[i], this.dx[i + 1]);
                if (this.bottomBCType.equalsIgnoreCase("Bottom Free Drainage") || this.bottomBCType.equalsIgnoreCase("BottomFreeDrainage")) {
                    this.kM = Variables.kappas[i];
                    Variables.darcyVelocities[i] = -this.kM;
                    continue;
                }
                if (this.bottomBCType.equalsIgnoreCase("Bottom Impervious") || this.bottomBCType.equalsIgnoreCase("BottomImpervious")) {
                    Variables.darcyVelocities[i] = 0.0;
                    continue;
                }
                this.kM = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappaBottom, this.dx[i], this.dx[i]);
                Variables.darcyVelocities[i] = -this.kM * (Variables.waterSuctions[i] - this.bottomBC) / this.spaceDelta[i] - this.kM;
                continue;
            }
            if (i == this.NUM_CONTROL_VOLUMES - 1) {
                this.kP = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappas[i - 1], this.dx[i], this.dx[i - 1]);
                Variables.darcyVelocities[i] = -this.kP * (Variables.waterSuctions[i] - Variables.waterSuctions[i - 1]) / this.spaceDelta[i] - this.kP;
                continue;
            }
            this.kM = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappas[i - 1], this.dx[i], this.dx[i - 1]);
            Variables.darcyVelocities[i] = -this.kM * (Variables.waterSuctions[i] - Variables.waterSuctions[i - 1]) / this.spaceDelta[i] - this.kM;
        }
    }

    public void computeDarcyVelocitiesCapillary() {
        for (int i = 0; i < this.NUM_CONTROL_VOLUMES; ++i) {
            if (i == 0) {
                if (this.bottomBCType.equalsIgnoreCase("Bottom Free Drainage") || this.bottomBCType.equalsIgnoreCase("BottomFreeDrainage")) {
                    this.kM = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappas[i], this.dx[i], this.dx[i]);
                    Variables.darcyVelocitiesCapillary[i] = -this.kM;
                    continue;
                }
                if (this.bottomBCType.equalsIgnoreCase("Bottom Impervious") || this.bottomBCType.equalsIgnoreCase("BottomImpervious")) {
                    Variables.darcyVelocitiesCapillary[i] = 0.0;
                    continue;
                }
                this.kM = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappaBottom, this.dx[i], this.dx[i]);
                Variables.darcyVelocitiesCapillary[i] = -this.kM * (Variables.waterSuctions[i] - this.bottomBC) / this.spaceDelta[i];
                continue;
            }
            if (i == this.NUM_CONTROL_VOLUMES - 1) {
                this.kP = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappas[i - 1], this.dx[i], this.dx[i - 1]);
                Variables.darcyVelocitiesCapillary[i] = -this.kP * (Variables.waterSuctions[i] - Variables.waterSuctions[i - 1]) / this.spaceDelta[i];
                continue;
            }
            this.kM = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappas[i - 1], this.dx[i], this.dx[i - 1]);
            Variables.darcyVelocitiesCapillary[i] = -this.kM * (Variables.waterSuctions[i] - Variables.waterSuctions[i - 1]) / this.spaceDelta[i];
        }
    }

    public void computeDarcyVelocitiesGravity() {
        for (int i = 0; i < this.NUM_CONTROL_VOLUMES; ++i) {
            if (i == 0) {
                if (this.bottomBCType.equalsIgnoreCase("Bottom Free Drainage") || this.bottomBCType.equalsIgnoreCase("BottomFreeDrainage")) {
                    this.kM = Variables.kappas[i];
                    Variables.darcyVelocitiesGravity[i] = -this.kM;
                    continue;
                }
                if (this.bottomBCType.equalsIgnoreCase("Bottom Impervious") || this.bottomBCType.equalsIgnoreCase("BottomImpervious")) {
                    Variables.darcyVelocitiesGravity[i] = 0.0;
                    continue;
                }
                this.kM = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappaBottom, this.dx[i], this.dx[i]);
                Variables.darcyVelocitiesGravity[i] = -this.kM;
                continue;
            }
            if (i == this.NUM_CONTROL_VOLUMES - 1) {
                this.kP = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappas[i - 1], this.dx[i], this.dx[i - 1]);
                Variables.darcyVelocitiesGravity[i] = -this.kP;
                continue;
            }
            this.kM = this.interfaceHydraulicConductivity.compute(Variables.kappas[i], Variables.kappas[i - 1], this.dx[i], this.dx[i - 1]);
            Variables.darcyVelocitiesGravity[i] = -this.kM;
        }
    }

    public void computePoreVelocities() {
        for (int i = 0; i < this.NUM_CONTROL_VOLUMES; ++i) {
            if (i == 0) {
                if (this.bottomBCType.equalsIgnoreCase("Bottom Free Drainage") || this.bottomBCType.equalsIgnoreCase("BottomFreeDrainage")) {
                    this.kM = Variables.kappas[i];
                    Variables.poreVelocities[i] = Variables.darcyVelocities[i] / (SoilParameters.thetaS[i] - SoilParameters.thetaR[i]);
                    continue;
                }
                if (this.bottomBCType.equalsIgnoreCase("Bottom Impervious") || this.bottomBCType.equalsIgnoreCase("BottomImpervious")) {
                    Variables.poreVelocities[i] = 0.0;
                    continue;
                }
                Variables.poreVelocities[i] = Variables.darcyVelocities[i] / (SoilParameters.thetaS[i] - SoilParameters.thetaR[i]);
                continue;
            }
            Variables.poreVelocities[i] = i == this.NUM_CONTROL_VOLUMES - 1 ? Variables.darcyVelocities[i] / (SoilParameters.thetaS[i - 1] - SoilParameters.thetaR[i - 1]) : Variables.darcyVelocities[i] / (SoilParameters.thetaS[i] - SoilParameters.thetaR[i]);
        }
    }

    public double[] computeCelerity() {
        for (int i = 0; i < this.NUM_CONTROL_VOLUMES; ++i) {
            if (i == 0) {
                if (this.bottomBCType.equalsIgnoreCase("Bottom Free Drainage") || this.bottomBCType.equalsIgnoreCase("BottomFreeDrainage")) {
                    Variables.celerities[i] = -this.unsaturatedHydraulicConductivity.dHydraulicConductivity(Variables.waterSuctions[i], i);
                    continue;
                }
                if (this.bottomBCType.equalsIgnoreCase("Bottom Impervious") || this.bottomBCType.equalsIgnoreCase("BottomImpervious")) {
                    Variables.celerities[i] = 0.0;
                    continue;
                }
                this.kM = this.interfaceHydraulicConductivity.compute(this.unsaturatedHydraulicConductivity.dHydraulicConductivity(Variables.waterSuctions[i], i), this.unsaturatedHydraulicConductivity.dHydraulicConductivity(this.bottomBC, i), this.dx[i], this.dx[i]);
                Variables.celerities[i] = -this.kM * ((Variables.waterSuctions[i] - this.bottomBC) / this.spaceDelta[i] + 1.0);
                continue;
            }
            if (i == this.NUM_CONTROL_VOLUMES - 1) {
                this.kP = this.interfaceHydraulicConductivity.compute(this.unsaturatedHydraulicConductivity.dHydraulicConductivity(Variables.waterSuctions[i - 1], i - 1), this.unsaturatedHydraulicConductivity.dHydraulicConductivity(Variables.waterSuctions[i - 1], i - 1), this.dx[i], this.dx[i - 1]);
                Variables.celerities[i] = -this.kP * ((Variables.waterSuctions[i] - Variables.waterSuctions[i - 1]) / this.spaceDelta[i] + 1.0);
                continue;
            }
            this.kM = this.interfaceHydraulicConductivity.compute(this.unsaturatedHydraulicConductivity.dHydraulicConductivity(Variables.waterSuctions[i], i), this.unsaturatedHydraulicConductivity.dHydraulicConductivity(Variables.waterSuctions[i - 1], i - 1), this.dx[i], this.dx[i - 1]);
            Variables.celerities[i] = -this.kM * ((Variables.waterSuctions[i] - Variables.waterSuctions[i - 1]) / this.spaceDelta[i] + 1.0);
        }
        return Variables.celerities;
    }

    public void computeKinematicRatio() {
        for (int i = 0; i < this.NUM_CONTROL_VOLUMES; ++i) {
            if (i == 0) {
                if (this.bottomBCType.equalsIgnoreCase("Bottom Impervious") || this.bottomBCType.equalsIgnoreCase("BottomImpervious")) {
                    Variables.kinematicRatio[i] = Double.NaN;
                    continue;
                }
                Variables.kinematicRatio[i] = Variables.celerities[i] / Variables.poreVelocities[i];
                continue;
            }
            Variables.kinematicRatio[i] = Variables.celerities[i] / Variables.poreVelocities[i];
        }
    }
}

