/*
 * Decompiled with CFR 0.152.
 */
package richardsclasses;

import physicalquantities.Variables;
import richardsclasses.Thomas;
import richardsclasses.TotalDepth;
import swrc.SoilWaterRetentionCurve;

public class NestedNewton {
    private double outerResidual;
    private double innerResidual;
    int nestedNewton;
    int MAXITER_NEWT;
    int NUM_CONTROL_VOLUMES;
    double newtonTolerance;
    double[] psis;
    double[] mainDiagonal;
    double[] upperDiagonal;
    double[] lowerDiagonal;
    double[] rhss;
    double[] dx;
    double[] fs;
    double[] fks;
    double[] bb;
    double[] cc;
    double[] dis;
    double[] dpsis;
    double[] psis_outer;
    SoilWaterRetentionCurve soilWaterRetentionCurve;
    TotalDepth totalDepth;
    Thomas thomasAlg = new Thomas();

    public NestedNewton(int nestedNewton, double newtonTolerance, int MAXITER_NEWT, int NUM_CONTROL_VOLUMES, double[] dx, SoilWaterRetentionCurve soilWaterRetentionCurve, TotalDepth totalDepth) {
        this.nestedNewton = nestedNewton;
        this.newtonTolerance = newtonTolerance;
        this.MAXITER_NEWT = MAXITER_NEWT;
        this.NUM_CONTROL_VOLUMES = NUM_CONTROL_VOLUMES;
        this.soilWaterRetentionCurve = soilWaterRetentionCurve;
        this.totalDepth = totalDepth;
        this.dx = dx;
        this.psis = new double[this.NUM_CONTROL_VOLUMES];
        this.fs = new double[this.NUM_CONTROL_VOLUMES];
        this.fks = new double[this.NUM_CONTROL_VOLUMES];
        this.bb = new double[this.NUM_CONTROL_VOLUMES];
        this.cc = new double[this.NUM_CONTROL_VOLUMES];
        this.dis = new double[this.NUM_CONTROL_VOLUMES];
        this.dpsis = new double[this.NUM_CONTROL_VOLUMES];
        this.psis_outer = new double[this.NUM_CONTROL_VOLUMES];
    }

    public void set(double[] mainDiagonal, double[] upperDiagonal, double[] lowerDiagonal, double[] rhss) {
        this.mainDiagonal = mainDiagonal;
        this.upperDiagonal = upperDiagonal;
        this.lowerDiagonal = lowerDiagonal;
        this.rhss = rhss;
    }

    public void solver() {
        int i;
        for (i = 0; i < this.NUM_CONTROL_VOLUMES; ++i) {
            if (i == this.NUM_CONTROL_VOLUMES - 1) continue;
            Variables.waterSuctions[i] = Math.min(Variables.waterSuctions[i], this.soilWaterRetentionCurve.getPsiStar1(i));
        }
        block1: for (i = 0; i < this.MAXITER_NEWT; ++i) {
            int j;
            this.outerResidual = 0.0;
            for (j = 0; j < this.NUM_CONTROL_VOLUMES; ++j) {
                if (j == 0) {
                    this.fs[j] = this.soilWaterRetentionCurve.waterContent(j) * this.dx[j] - this.rhss[j] + this.mainDiagonal[j] * Variables.waterSuctions[j] + this.upperDiagonal[j] * Variables.waterSuctions[j + 1];
                    this.dis[j] = this.soilWaterRetentionCurve.dWaterContent(j);
                } else if (j == this.NUM_CONTROL_VOLUMES - 1) {
                    this.fs[j] = this.totalDepth.totalDepth(Variables.waterSuctions[j]) - this.rhss[j] + this.lowerDiagonal[j] * Variables.waterSuctions[j - 1] + this.mainDiagonal[j] * Variables.waterSuctions[j];
                    this.dis[j] = this.totalDepth.dTotalDepth(Variables.waterSuctions[j]);
                } else {
                    this.fs[j] = this.soilWaterRetentionCurve.waterContent(j) * this.dx[j] - this.rhss[j] + this.lowerDiagonal[j] * Variables.waterSuctions[j - 1] + this.mainDiagonal[j] * Variables.waterSuctions[j] + this.upperDiagonal[j] * Variables.waterSuctions[j + 1];
                    this.dis[j] = this.soilWaterRetentionCurve.dWaterContent(j);
                }
                this.outerResidual += this.fs[j] * this.fs[j];
            }
            this.outerResidual = Math.pow(this.outerResidual, 0.5);
            if (this.outerResidual < this.newtonTolerance) break;
            if (this.nestedNewton == 0) {
                this.bb = (double[])this.mainDiagonal.clone();
                this.cc = (double[])this.upperDiagonal.clone();
                for (int y = 0; y < this.NUM_CONTROL_VOLUMES; ++y) {
                    int n = y;
                    this.bb[n] = this.bb[n] + this.dis[y];
                }
                this.thomasAlg.set(this.cc, this.bb, this.lowerDiagonal, this.fs);
                this.dpsis = this.thomasAlg.solver();
                for (int s = 0; s < this.NUM_CONTROL_VOLUMES; ++s) {
                    Variables.waterSuctions[s] = Variables.waterSuctions[s] - this.dpsis[s];
                }
                continue;
            }
            this.psis_outer = (double[])Variables.waterSuctions.clone();
            for (j = 0; j < this.MAXITER_NEWT; ++j) {
                this.innerResidual = 0.0;
                for (int l = 0; l < this.NUM_CONTROL_VOLUMES; ++l) {
                    if (l == 0) {
                        this.fks[l] = this.soilWaterRetentionCurve.pIntegral(l) * this.dx[l] - (this.soilWaterRetentionCurve.qIntegral(this.psis_outer[l], l) + this.soilWaterRetentionCurve.q(this.psis_outer[l], l) * (Variables.waterSuctions[l] - this.psis_outer[l])) * this.dx[l] - this.rhss[l] + this.mainDiagonal[l] * Variables.waterSuctions[l] + this.upperDiagonal[l] * Variables.waterSuctions[l + 1];
                        this.dis[l] = (this.soilWaterRetentionCurve.p(l) - this.soilWaterRetentionCurve.q(this.psis_outer[l], l)) * this.dx[l];
                    } else if (l == this.NUM_CONTROL_VOLUMES - 1) {
                        this.fks[l] = this.totalDepth.pIntegral(Variables.waterSuctions[l]) - this.rhss[l] + this.lowerDiagonal[l] * Variables.waterSuctions[l - 1] + this.mainDiagonal[l] * Variables.waterSuctions[l];
                        this.dis[l] = this.totalDepth.p(Variables.waterSuctions[l]);
                        if (this.mainDiagonal[l] == 0.0) {
                            this.dis[l] = 1.0;
                        }
                    } else {
                        this.fks[l] = this.soilWaterRetentionCurve.pIntegral(l) * this.dx[l] - (this.soilWaterRetentionCurve.qIntegral(this.psis_outer[l], l) + this.soilWaterRetentionCurve.q(this.psis_outer[l], l) * (Variables.waterSuctions[l] - this.psis_outer[l])) * this.dx[l] - this.rhss[l] + this.lowerDiagonal[l] * Variables.waterSuctions[l - 1] + this.mainDiagonal[l] * Variables.waterSuctions[l] + this.upperDiagonal[l] * Variables.waterSuctions[l + 1];
                        this.dis[l] = (this.soilWaterRetentionCurve.p(l) - this.soilWaterRetentionCurve.q(this.psis_outer[l], l)) * this.dx[l];
                    }
                    this.innerResidual += this.fks[l] * this.fks[l];
                }
                this.innerResidual = Math.pow(this.innerResidual, 0.5);
                if (this.innerResidual < this.newtonTolerance) continue block1;
                this.bb = (double[])this.mainDiagonal.clone();
                this.cc = (double[])this.upperDiagonal.clone();
                for (int y = 0; y < this.NUM_CONTROL_VOLUMES; ++y) {
                    int n = y;
                    this.bb[n] = this.bb[n] + this.dis[y];
                }
                this.thomasAlg.set(this.cc, this.bb, this.lowerDiagonal, this.fks);
                this.dpsis = this.thomasAlg.solver();
                for (int s = 0; s < this.NUM_CONTROL_VOLUMES; ++s) {
                    Variables.waterSuctions[s] = Variables.waterSuctions[s] - this.dpsis[s];
                }
            }
        }
    }
}

