/*
 * Decompiled with CFR 0.152.
 */
package richardsclasses;

public class Thomas {
    double[] mainDiagonal;
    double[] upperDiagonal;
    double[] lowerDiagonal;
    double[] rhss;
    double[] solution;
    int DIM;

    public void set(double[] upperDiagonal, double[] mainDiagonal, double[] lowerDiagonal, double[] rhss) {
        this.upperDiagonal = upperDiagonal;
        this.mainDiagonal = mainDiagonal;
        this.lowerDiagonal = lowerDiagonal;
        this.rhss = rhss;
        this.DIM = this.mainDiagonal.length;
        this.solution = new double[this.DIM];
    }

    public double[] solver() {
        int i;
        double gamma = 0.0;
        if (this.mainDiagonal.length != this.upperDiagonal.length | this.mainDiagonal.length != this.lowerDiagonal.length | this.mainDiagonal.length != this.rhss.length) {
            throw new IllegalArgumentException("System size error! |nCheck the length of diagonal vectors and the right hand side term of the system ");
        }
        this.upperDiagonal[0] = this.upperDiagonal[0] / this.mainDiagonal[0];
        this.rhss[0] = this.rhss[0] / this.mainDiagonal[0];
        for (i = 1; i < this.DIM; ++i) {
            gamma = 1.0 / (this.mainDiagonal[i] - this.upperDiagonal[i - 1] * this.lowerDiagonal[i]);
            this.upperDiagonal[i] = this.upperDiagonal[i] * gamma;
            this.rhss[i] = (this.rhss[i] - this.lowerDiagonal[i] * this.rhss[i - 1]) * gamma;
        }
        this.solution[this.DIM - 1] = this.rhss[this.DIM - 1];
        for (i = this.DIM - 2; i > -1; --i) {
            this.solution[i] = this.rhss[i] - this.upperDiagonal[i] * this.solution[i + 1];
        }
        return this.solution;
    }

    public void printSolution() {
        System.out.println("The solution computed with Thomas algorithm is: \n");
        for (int i = 0; i < this.solution.length; ++i) {
            System.out.println(this.solution[i]);
        }
    }
}

