package rheology;


public class RheologyParameters {
	
	private static RheologyParameters uniqueInstance;
	
	public static RheologyParameters getInstance() {
		/*if (uniqueInstance == null) {
			uniqueInstance = new Variables(waterSuction, temperature);
		}*/
		return uniqueInstance;
	}
	
	public static RheologyParameters getInstance(double waterDensity, double iceDensity, double specificThermalCapacityWater,
			double specificThermalCapacityIce, double thermalConductivityWater, double thermalConductivityIce, double latentHeatFusion, double temperatureRef,
			double[] thetaS, double[] thetaR, double[] soilParticlesDensity, double[] specificThermalCapacitySoilParticles, double[] thermalConductivitySoilParticles,
			double[] meltingTemperature, double[] par1, double[] par2, double[] par3, double[] par4) {
		if (uniqueInstance == null) {
			uniqueInstance = new RheologyParameters(waterDensity, iceDensity, specificThermalCapacityWater,
					 specificThermalCapacityIce, thermalConductivityWater, thermalConductivityIce, latentHeatFusion, temperatureRef,
					 thetaS, thetaR, soilParticlesDensity, specificThermalCapacitySoilParticles, thermalConductivitySoilParticles,
					 meltingTemperature, par1, par2, par3, par4);
		}
		return uniqueInstance;
	}
	
	
	public double waterDensity;
	public double iceDensity;
	public double specificThermalCapacityIce;
	public double specificThermalCapacityWater;
	public double thermalConductivityWater;
	public double thermalConductivityIce;
	public double latentHeatFusion;
	public double temperatureRef;
	public double[] thetaS;
	public double[] thetaR;
	public double[] soilParticlesDensity;
	public double[] specificThermalCapacitySoilParticles;
	public double[] thermalConductivitySoilParticles;
	public double[] meltingTemperature;
	public double[] par1; //alpha VG
	public double[] par2; // n VG
	public double[] par3;
	public double[] par4;
	
		
	private RheologyParameters(double waterDensity, double iceDensity, double specificThermalCapacityWater,
			double specificThermalCapacityIce, double thermalConductivityWater, double thermalConductivityIce, double latentHeatFusion, double temperatureRef,
			double[] thetaS, double[] thetaR, double[] soilParticlesDensity, double[] specificThermalCapacitySoilParticles, double[] thermalConductivitySoilParticles,
			double[] meltingTemperature, double[] par1, double[] par2, double[] par3, double[] par4) {
		this.waterDensity = waterDensity;
		this.iceDensity = iceDensity;
		this.specificThermalCapacityIce = specificThermalCapacityIce;
		this.specificThermalCapacityWater = specificThermalCapacityWater;
		this.thermalConductivityWater = thermalConductivityWater;
		this.thermalConductivityIce = thermalConductivityIce;
		this.latentHeatFusion = latentHeatFusion;
		this.temperatureRef = temperatureRef;
		this.thetaS = thetaS.clone();
		this.thetaR = thetaR.clone();
		this.soilParticlesDensity = soilParticlesDensity.clone();
		this.specificThermalCapacitySoilParticles = specificThermalCapacitySoilParticles.clone();
		this.thermalConductivitySoilParticles = thermalConductivitySoilParticles.clone();
		this.meltingTemperature = meltingTemperature.clone();
		this.par1 = par1.clone();
		this.par2 = par2.clone();
		this.par3 = par3.clone();
		this.par4 = par4.clone();
	}


}
