/*
 * GNU GPL v3 License
 *
 * Copyright 2019 Niccolo` Tubini
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * 
 */
package rheology;

/**
 * @author Niccolo` Tubini
 *
 */
public abstract class SoilFreezingCharacteristicCurve extends Rheology{
	
	/**
	 * This method compute the water content using the SFCC
	 * @return the water content
	 */
	public abstract double f(double x, int id);
	
	
	
	/**
	 * This method compute the first derivative of the water content with respect to temperature
	 * @return the first derivative of the water content
	 */
	public abstract double df(double x, int id);
	
	
	
	/**
	 * This method compute the second derivative of the water content with respect to temperature
	 * @return the second derivative of the water content
	 */
	public abstract double ddf(double x, int id);
	

}
