package testreader;
/*
 * GNU GPL v3 License
 *
 * Copyright 2019 Niccolo` Tubini
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import monodimensionalProblemTimeDependent.ReadNetCDFExcessIce1D;


import org.junit.Test;


/**
 * Test the {@link ReadNetCDFEnergyGrid1D} module.
 * 
 * @author Niccolo' Tubini
 */
public class TestReadNetCDFExcessIce1D {

	@Test
	public void Test() throws Exception {

		ReadNetCDFExcessIce1D reader = new ReadNetCDFExcessIce1D();
		boolean checkData = true;
		reader.gridFilename = "resources/input/tmp3";
		reader.read();

		/*
		 * check data
		 */
		if(checkData == true) {
			
			System.out.println("KMAX: "+reader.KMAX);
			System.out.println("VECTOR_LENGTH: "+reader.VECTOR_LENGTH);

			
			System.out.println("Eta: lenght "+reader.eta.length);
			for(int i=0; i<reader.KMAX; i++) {
				System.out.println("\t"+reader.eta[i]);
			}

			System.out.println("Z: lenght "+reader.z.length);
			for(int i=0; i<reader.KMAX; i++) {
				System.out.println("\t"+reader.z[i]);
			}

			System.out.println("volumeSoil: lenght "+reader.volumeSoil.length);
			for(int i=0; i<reader.KMAX; i++) {
				System.out.println("\t"+reader.volumeSoil[i]);
			}
			
			System.out.println("volumeExcessIce: lenght "+reader.volumeExcessIce.length);
			for(int i=0; i<reader.KMAX; i++) {
				System.out.println("\t"+reader.volumeExcessIce[i]);
			}

			System.out.println("ic: lenght "+reader.temperatureIC.length);
			for(int i=0; i<reader.KMAX; i++) {
				System.out.println("\t"+reader.temperatureIC[i]);
			}

			System.out.println("rheologyID: lenght "+reader.rheologyID.length);
			for(int i=0; i<reader.KMAX; i++) {
				System.out.println("\t"+reader.rheologyID[i]);
			}

			System.out.println("soilID: lenght "+reader.parameterID.length);
			for(int i=0; i<reader.KMAX; i++) {
				System.out.println("\t"+reader.parameterID[i]);
			}

			System.out.println("spaceDelta: lenght "+reader.spaceDelta.length);
			for(int i=0; i<reader.KMAX+1; i++) {
				System.out.println("\t"+reader.spaceDelta[i]);
			}

			System.out.println("etaDual: lenght "+reader.etaDual.length);
			for(int i=0; i<reader.KMAX+1; i++) {
				System.out.println("\t"+reader.etaDual[i]);
			}

			System.out.println("zDual: lenght "+reader.zDual.length);
			for(int i=0; i<reader.KMAX+1; i++) {
				System.out.println("\t"+reader.zDual[i]);
			}
		}
	}

}


