      subroutine allocate_parms
!!    ~ ~ ~ PURPOSE ~ ~ ~
!!    this subroutine allocates array sizes

!!    ~ ~ ~ INCOMING VARIABLES ~ ~ ~
!!    name        |units         |definition
!!    ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
!!    mapp        |none          |max number of applications
!!    mch         |none          |max number of channels
!!    mcr         |none          |max number of crops grown per year
!!    mcrdb       |none          |max nunber of crops in crop.dat
!!    mcut        |none          |max number of cuttings per year
!!    mfdb        |none          |max number of fertilizers in fert.dat
!!    mgr         |none          |max number of grazings per year
!!    mhru        |none          |max number of HRUs
!!    mhyd        |none          |max number of hydrographs
!!    mlyr        |none          |max number of soil layers
!!    mnr         |none          |max number of years of rotation
!!    mpst        |none          |max number of pesticides used in wshed
!!    mpdb        |none          |max number of pesticides in pest.dat
!!    mrecc       |none          |max number of reccnst files
!!    mrecd       |none          |max number of recday files
!!    mrech       |none          |max number of rechour files
!!    mrecm       |none          |max number of recmon files
!!    mrecy       |none          |max number of recyear files
!!    mres        |none          |max number of reservoirs
!!    mrg         |none          |max number of rainfall/temp gages
!!    mstep       |none          |max number of time steps per day
!!    msub        |none          |max number of subbasins
!!    mtil        |none          |max number of tillage types in till.dat
!!    mudb        |none          |max number of urban land types in urban.dat
!!    myr         |none          |max number of years of simulation
!!    ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~

!!    ~ ~ ~ OUTGOING VARIABLES ~ ~ ~
!!    name        |units         |definition
!!    ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
!!    mhruo       |none          |max number of variables in output.hru
!!    mrcho       |none          |max number of variables in reach file
!!    mstdo       |none          |max number of variables summarized in 
!!                               |output.std
!!    msubo       |none          |max number of variables in output.sub
!!    mvaro       |none          |max number of variables routed through the
!!                               |reach
!!    ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~

!!    ~ ~ ~ ~ ~ ~ END SPECIFICATIONS ~ ~ ~ ~ ~ ~


      use parm

!! initialize variables    
      mvaro = 33
      mhruo = 70
      mrcho = 59
!     msubo = 18
!     changed for jennifer b
      msubo = 21
      mstdo = 112

!!    array that contains seeds for the random generator
      allocate (iseed(1))
!!    arrays which contain data related to the number of rechour commands
      allocate (ifirsthr(mrech))

!!    arrays which contain data related to the number of recday commands
      allocate (ifirstr(mrecd))

!!    arrays which contain data related to the date
      allocate (values(8))

!!    arrays which contain data related to rainfall/temperature gages
!!     test for JRW
      allocate (elevp(mrg))
      allocate (elevt(mrg))
      allocate (ifirstpcp(mrg))
      allocate (ifirstt(mrg))

!!    apex/command variables
      allocate (ifirsta(mapex))
      allocate (iypa(mapex))
      allocate (idapa(mapex))
      allocate (flodaya(mapex))
      allocate (seddaya(mapex))
      allocate (orgndaya(mapex))
      allocate (orgpdaya(mapex))
      allocate (no3daya(mapex))
      allocate (minpdaya(mapex))

!! septic inputs
      allocate (idspts(msdb+1))
      allocate (sptqs_dat(msdb+1))
      allocate (sptbodins(msdb+1))
      allocate (spttssconcs(msdb+1))
      allocate (spttnconcs(msdb+1))
      allocate (sptnh4concs(msdb+1))
      allocate (sptno3concs(msdb+1))
      allocate (sptno2concs(msdb+1))
      allocate (sptorgnconcs(msdb+1))
      allocate (spttpconcs(msdb+1))  
      allocate (sptminps(msdb+1))
      allocate (sptorgps(msdb+1))
      allocate (sptfcolis(msdb+1))
!! septic changes added 1/28/09 gsm
      allocate (sptqs(mhru))
      allocate (i_sep(mhru))
      allocate (bio_amn(mhru))
      allocate (bio_bod(mhru))
      allocate (biom(mhru))
      allocate (bio_fecal(mhru))
      allocate (bio_ntr(mhru))
      allocate (bz_perc(mhru))
      allocate (bz_z(mhru))
      allocate (bz_thk(mhru))
      allocate (bz_area(mhru))
      allocate (bio_bd(mhru))
      allocate (coeff_bod_dc(mhru))
      allocate (coeff_bod_conv(mhru))
      allocate (coeff_fc1(mhru))
      allocate (coeff_fc2(mhru))
      allocate (coeff_fecal(mhru))
      allocate (coeff_plq(mhru))
      allocate (coeff_mrt(mhru))
      allocate (coeff_rsp(mhru))
      allocate (coeff_slg1(mhru))
      allocate (coeff_slg2(mhru))
      allocate (coeff_nitr(mhru))
      allocate (coeff_denitr(mhru))
      allocate (isep_typ(mhru))
      allocate (ipop_sep(mhru))
      allocate (plqm(mhru))
!! septic changes added 1/28/09 gsm
      allocate (qird(mhru))
     
!!    arrays which contain data related to channels
      allocate (algae(mch))
      allocate (alpha_bnk(mch)) 
      allocate (alpha_bnke(msub))
      allocate (ammonian(mch))
      allocate (bankst(mch))
      allocate (bc1(mch))
      allocate (bc2(mch))
      allocate (bc3(mch))
      allocate (bc4(mch))
      allocate (ch_bnk_bd(mch))
      allocate (ch_cov1(mch))
      allocate (ch_cov2(mch))
      allocate (ch_bnk_d50(mch))
      allocate (ch_eqn(mch))    
      allocate (ch_d(msub+1))
      allocate (ch_di(mch))
!      allocate (ch_erod(mch))
      allocate (ch_l2(msub+1))
      allocate (ch_li(mch))
      allocate (ch_onco(mch))
      allocate (ch_opco(mch))
      allocate (ch_orgn(mch))
      allocate (ch_orgp(mch))
      allocate (ch_si(mch))
      allocate (ch_wdr(mch))
      allocate (ch_wi(mch))
      allocate (ch_erodmo(mch,12))
      allocate (chlora(mch))
      allocate (chpst_conc(mch))
      allocate (chpst_koc(mch))
      allocate (chpst_mix(mch))
      allocate (chpst_rea(mch))
      allocate (chpst_rsp(mch))
      allocate (chpst_stl(mch))
      allocate (chpst_vol(mch))
      allocate (chside(msub+1))
      allocate (dep_chan(mch))
      allocate (disolvp(mch))
      allocate (drift(mch))
      allocate (flwin(mch))
      allocate (flwout(mch))
      allocate (icanal(mch))
      allocate (nitraten(mch))
      allocate (nitriten(mch))
      allocate (organicn(mch))
      allocate (organicp(mch))
      allocate (orig_sedpstconc(mch))
      allocate (rch_bactlp(mch))
      allocate (rch_bactp(mch))
      allocate (rch_cbod(mch))
      allocate (rch_dox(mch))
      allocate (rchstor(mch))
      allocate (rk1(mch))
      allocate (rk2(mch))
      allocate (rk3(mch))
      allocate (rk4(mch))
      allocate (rk5(mch))
      allocate (rk6(mch))
      allocate (rs1(mch))
      allocate (rs2(mch))
      allocate (rs3(mch))
      allocate (rs4(mch))
      allocate (rs5(mch))
      allocate (rs6(mch))
      allocate (rs7(mch))
      allocate (sedpst_act(mch))
      allocate (sedpst_bry(mch))
      allocate (sedpst_conc(mch))
      allocate (sedpst_rea(mch))
      allocate (sedst(mch))
      allocate (vel_chan(mch))

      allocate (wurch(12,msub))

!!    arrays for channel added by Balaji for the new routines
      allocate (ch_bnk_san(mch))
      allocate (ch_bnk_sil(mch))
      allocate (ch_bnk_cla(mch))
      allocate (ch_bnk_gra(mch))
      allocate (ch_bed_san(mch))
      allocate (ch_bed_sil(mch))
      allocate (ch_bed_cla(mch))
      allocate (ch_bed_gra(mch))
      allocate (ch_bed_bd(mch))
      allocate (ch_bed_d50(mch))
      allocate (ch_bnk_kd(mch))
      allocate (ch_bed_kd(mch))
      allocate (tc_bnk(mch))
      allocate (tc_bed(mch))
      allocate (depfp(mch))
      allocate (depprfp(mch))
      allocate (depsanfp(mch))
      allocate (depsilfp(mch))
      allocate (depclafp(mch))
      allocate (depsagfp(mch))
      allocate (deplagfp(mch))
      allocate (depgrafp(mch))
      allocate (depch(mch))
      allocate (depprch(mch))
      allocate (depsanch(mch))
      allocate (depsilch(mch))
      allocate (depclach(mch))
      allocate (depsagch(mch))
      allocate (deplagch(mch))
      allocate (depgrach(mch))
      allocate (sanst(mch))
      allocate (silst(mch))
      allocate (clast(mch))
      allocate (sagst(mch))
      allocate (lagst(mch))
      allocate (grast(mch))

!!    arrays which contain data related to reach output 
      allocate (icolr(mrcho))
!     allocate (ipdvar(mrcho))
      allocate (ipdvar(42))    
      allocate (rchaao(mrcho,msub))
      allocate (rchdy(mrcho,msub))
      allocate (rchmono(mrcho,msub))
      allocate (rchyro(mrcho,msub))

!!    arrays which contain data related to subbasins
      allocate (ch_revap(msub))
      allocate (cncoef_sub(msub))
      allocate (co2(msub))
      allocate (daylmn(msub))
      allocate (drydep_no3(msub))
      allocate (drydep_nh4(msub))
      allocate (fcst_reg(msub))
      allocate (harg_petco(msub))
      allocate (hqd(73))
      allocate (hqdsave(msub,49))
      allocate (hru1(msub))
      allocate (hrutot(msub))
      allocate (ihgage(msub))
      allocate (ireg(msub))
      allocate (irelh(msub))
      allocate (irgage(msub))
      allocate (isgage(msub))
      allocate (itb(msub))
      allocate (itgage(msub))
      allocate (iwgage(msub))
      allocate (latcos(msub))
      allocate (latsin(msub))
      allocate (pcpdays(msub))
      allocate (phutot(msub))
      allocate (plaps(msub))
      allocate (rammo_sub(msub))
      allocate (rcn_sub(msub))
      allocate (sub_bactlp(msub))
      allocate (sub_bactp(msub))
      allocate (sub_bd(msub))
      allocate (sub_cbod(msub))
      allocate (sub_chl(msub))
      allocate (sub_dsan(msub))
      allocate (sub_dsil(msub))
      allocate (sub_dcla(msub))
      allocate (sub_dsag(msub))
      allocate (sub_dlag(msub))
      allocate (sub_dox(msub))
      allocate (sub_elev(msub))
      allocate (sub_etday(msub))
      allocate (sub_fr(msub))
      allocate (sub_gwno3(msub))
      allocate (sub_gwsolp(msub))
      allocate (sub_gwq(msub))
      allocate (sub_km(msub))
      allocate (sub_lat(msub))
      allocate (sub_latq(msub))
      allocate (sub_latno3(msub))
      allocate (sub_minp(msub))
      allocate (sub_minpa(msub))
      allocate (sub_minps(msub))
      allocate (sub_no3(msub))
      allocate (sub_orgn(msub))
      allocate (sub_orgp(msub))
      allocate (sub_pet(msub))
      allocate (sub_precip(msub))
      allocate (sub_qd(msub))
      allocate (sub_sedpa(msub))
      allocate (sub_sedps(msub))
      allocate (sub_sedy(msub))
      allocate (sub_sep(msub))
      allocate (sub_smfmx(msub))
      allocate (sub_smfmn(msub))
      allocate (sub_sftmp(msub))
      allocate (sub_smtmp(msub))
      allocate (sub_timp(msub))
      allocate (sub_snom(msub))
      allocate (sub_solp(msub))
      allocate (sub_solpst(msub))
      allocate (sub_sorpst(msub))
      allocate (sub_subp(msub))
      allocate (sub_sumfc(msub))
      allocate (sub_surfq(msub))
      allocate (sub_sw(msub))
      allocate (sub_tc(msub))
      allocate (sub_tran(msub))
      allocate (sub_wtmp(msub))
      allocate (sub_wyld(msub))
      allocate (sub_yorgn(msub))
      allocate (sub_yorgp(msub))
      allocate (subfr_nowtr(msub))
      allocate (subgis(msub))
      allocate (tlaps(msub))
      allocate (tmp_an(msub))
      allocate (wcklsp(msub))
      allocate (welev(msub))
      allocate (wlat(msub))

      allocate (sub_pst(mpst,msub))

      allocate (huminc(msub,12))
      allocate (radinc(msub,12))
      allocate (rfinc(msub,12))
      allocate (tmpinc(msub,12))
      allocate (sub_hhqd(msub,24))
      allocate (sub_hhwtmp(msub,24))
      allocate (uh(msub,49))

      allocate (ch_k(2,msub+1))
      allocate (ch_n(2,msub+1))
      allocate (ch_s(2,msub+1))
      allocate (ch_w(2,msub+1))
      allocate (elevb(10,msub))
      allocate (elevb_fr(10,msub))
      allocate (amp_r(12,msub))
      allocate (dewpt(12,msub))
      allocate (pcf(12,msub))
      allocate (solarav(12,msub))
      allocate (tmpmn(12,msub))
      allocate (tmpmx(12,msub))
      allocate (tmpstdmn(12,msub))
      allocate (tmpstdmx(12,msub))
      allocate (wndav(12,msub))

      allocate (pcp_stat(12,3,msub))
      allocate (pr_w(3,12,msub))

!!    arrays which contain data related to forecast parameters
      allocate (ftmpmn(12,msub))
      allocate (ftmpmx(12,msub))
      allocate (ftmpstdmn(12,msub))
      allocate (ftmpstdmx(12,msub))
      allocate (fpcp_stat(12,3,msub))
      allocate (fpr_w(3,12,msub))
      allocate (otmpmn(12,msub))
      allocate (otmpmx(12,msub))
      allocate (otmpstdmn(12,msub))
      allocate (otmpstdmx(12,msub))
      allocate (opcp_stat(12,3,msub))
      allocate (opr_w(3,12,msub))

!!    arrays which contain data related to subbasin output
      allocate (submono(msubo,msub))
      allocate (subaao(msubo,msub))
      allocate (subyro(msubo,msub))
      allocate (ipdvab(msubo))
      allocate (icolb(msubo))

!!    arrays which contain data related to soil layers, HRUs
      allocate (conv_wt(mlyr,mhru))
      allocate (crdep(mlyr,mhru))
      allocate (flat(mlyr,mhru))
      allocate (orig_solactp(mlyr,mhru))
      allocate (orig_solaorgn(mlyr,mhru))
      allocate (orig_solfon(mlyr,mhru))
      allocate (orig_solfop(mlyr,mhru))
      allocate (orig_solno3(mlyr,mhru))
      allocate (orig_solorgn(mlyr,mhru))
      allocate (orig_solorgp(mlyr,mhru))
      allocate (orig_solrsd(mlyr,mhru))
      allocate (orig_solsolp(mlyr,mhru))
      allocate (orig_solst(mlyr,mhru))
      allocate (orig_solstap(mlyr,mhru))
      allocate (orig_soltmp(mlyr,mhru))
      allocate (orig_volcr(mlyr,mhru))
      allocate (sol_actp(mlyr,mhru))
      allocate (sol_aorgn(mlyr,mhru))
      allocate (sol_awc(mlyr,mhru))
      allocate (sol_bd(mlyr,mhru))
      allocate (sol_cbn(mlyr,mhru))
      allocate (sol_clay(mlyr,mhru))
!  added 1/27/09 when making septic changes
      allocate (sol_ec(mlyr,mhru))
!  added 1/27/09 when making septic changes
      allocate (sol_fc(mlyr,mhru))
      allocate (sol_fon(mlyr,mhru))
      allocate (sol_fop(mlyr,mhru))
      allocate (sol_hk(mlyr,mhru))
      allocate (sol_hum(mlyr,mhru))
      allocate (sol_k(mlyr,mhru))
      allocate (sol_nh3(mlyr,mhru))
      allocate (sol_no3(mlyr,mhru))
      allocate (sol_orgn(mlyr,mhru))
      allocate (sol_orgp(mlyr,mhru))
      allocate (sol_por(mlyr,mhru))
      allocate (sol_prk(mlyr,mhru))
      allocate (sol_rock(mlyr,mhru))
      allocate (sol_rsd(mlyr,mhru))
      allocate (sol_sand(mlyr,mhru))
      allocate (sol_silt(mlyr,mhru))
      allocate (sol_solp(mlyr,mhru))
      allocate (sol_st(mlyr,mhru))
      allocate (sol_stap(mlyr,mhru))
      allocate (sol_tmp(mlyr,mhru))
      allocate (sol_ul(mlyr,mhru))
      allocate (sol_up(mlyr,mhru))
      allocate (sol_wp(mlyr,mhru))
      allocate (sol_wpmm(mlyr,mhru))
      allocate (sol_z(mlyr,mhru))
      allocate (volcr(mlyr,mhru))

!!    arrays which contain data related to soil layers, HRUs, pesticides
      allocate (orig_solpst(mpst,mhru,mlyr))
      allocate (sol_kp(mpst,mhru,mlyr))
      allocate (sol_pst(mpst,mhru,mlyr))

!!    arrays which contain data related to transfer command
      allocate (mo_transb(100))
      allocate (mo_transe(100))
      allocate (ih_tran(100))

!!    arrays which contain data related to reservoirs
      allocate (br1(mres))
      allocate (br2(mres))
      allocate (chlar(mres))
      allocate (evrsv(mres))
      allocate (iflod1r(mres))
      allocate (iflod2r(mres))
      allocate (ires1(mres))
      allocate (ires2(mres))
      allocate (iresco(mres))
      allocate (iyres(mres))
      allocate (lkpst_conc(mres))
      allocate (lkpst_koc(mres))
      allocate (lkpst_mix(mres))
      allocate (lkpst_rea(mres))
      allocate (lkpst_rsp(mres))
      allocate (lkpst_stl(mres))
      allocate (lkpst_vol(mres))
      allocate (lkspst_act(mres))
      allocate (lkspst_bry(mres))
      allocate (lkspst_conc(mres))
      allocate (lkspst_rea(mres))
      allocate (mores(mres))
      allocate (ndtargr(mres))
      allocate (oflowmn_fps(mres))
      allocate (orig_lkpstconc(mres))
      allocate (orig_lkspstconc(mres))
      allocate (orig_resnh3(mres))
      allocate (orig_resno2(mres))
      allocate (orig_resno3(mres))
      allocate (orig_resorgn(mres))
      allocate (orig_resorgp(mres))
      allocate (orig_ressed(mres))
      allocate (orig_ressolp(mres))
      allocate (orig_resvol(mres))
      allocate (res_bactlp(mres))
      allocate (res_bactp(mres))
      allocate (res_chla(mres))
      allocate (res_esa(mres))
      allocate (res_evol(mres))
      allocate (res_k(mres))
      allocate (res_nh3(mres))
      allocate (res_no2(mres))
      allocate (res_no3(mres))
      allocate (res_nsed(mres))
      allocate (res_orgn(mres))
      allocate (res_orgp(mres))
      allocate (res_psa(mres))
      allocate (res_pvol(mres))
      allocate (res_rr(mres))
      allocate (res_seci(mres))
      allocate (res_sed(mres))

      allocate (res_san(mres))
      allocate (res_sil(mres))
      allocate (res_cla(mres))
      allocate (res_sag(mres))
      allocate (res_lag(mres))
      allocate (res_gra(mres))

      allocate (res_solp(mres))
      allocate (res_sub(mres))
      allocate (res_vol(mres))
      allocate (seccir(mres))
      allocate (sed_stlr(mres))
      allocate (starg_fps(mres))
      allocate (wurtnf(mres))
      allocate (lkpst_mass(mres))
      allocate (lkspst_mass(mres))

      allocate (nsetlr(2,mres))
      allocate (psetlr(2,mres))
      allocate (oflowmx(12,mres))
      allocate (oflowmn(12,mres))
      allocate (starg(12,mres))
      allocate (wuresn(12,mres))

!! arrays for reservoir output
      allocate (icolrsv(41))
      allocate (resoutm(41,mres))
      allocate (resouta(41,mres))
      allocate (resouty(41,mres))

      allocate (resdata(7))

!!    arrays which contain data related to reservoirs, year
      allocate (res_out(mres,12,myr))

!!    arrays which contain data related to pesticides in database
      allocate (ap_ef(mpdb))
      allocate (decay_f(mpdb))
      allocate (decay_s(mpdb))
      allocate (hlife_f(mpdb))
      allocate (hlife_s(mpdb))
      allocate (nope(mpdb))
      allocate (pst_wof(mpdb))
      allocate (pst_wsol(mpdb))
      allocate (skoc(mpdb))

!!    arrays which contain data related to landcover/landuse in database
      allocate (alai_min(mcrdb))
!     allocate (air_str(mcrdb))
      allocate (bio_e(mcrdb))
      allocate (bio_leaf(mcrdb))
      allocate (bio_n1(mcrdb))
      allocate (bio_n2(mcrdb))
      allocate (bio_p1(mcrdb))
      allocate (bio_p2(mcrdb))
      allocate (blai(mcrdb))
      allocate (bm_dieoff(mcrdb))
      allocate (bmx_trees(mcrdb))
      allocate (chtmx(mcrdb))
      allocate (cnyld(mcrdb))
      allocate (cpyld(mcrdb))
      allocate (cvm(mcrdb))
      allocate (dlai(mcrdb))
      allocate (ext_coef(mcrdb))
      allocate (gsi(mcrdb))
      allocate (hvsti(mcrdb))
      allocate (idc(mcrdb))
      allocate (leaf1(mcrdb))
      allocate (leaf2(mcrdb))
      allocate (mat_yrs(mcrdb))
      allocate (rdmx(mcrdb))
      allocate (rsdco_pl(mcrdb))
      allocate (t_base(mcrdb))
      allocate (t_opt(mcrdb))
      allocate (vpd2(mcrdb))
      allocate (wac21(mcrdb))
      allocate (wac22(mcrdb))
      allocate (wavp(mcrdb))
      allocate (wsyf(mcrdb))

      allocate (pltnfr(3,mcrdb))
      allocate (pltpfr(3,mcrdb))

!!    arrays which contain data related to fertilizers in database
      allocate (bactkddb(mfdb))
      allocate (bactlpdb(mfdb))
      allocate (bactpdb(mfdb))
      allocate (fminn(mfdb))
      allocate (fminp(mfdb))
      allocate (fnh3n(mfdb))
      allocate (forgn(mfdb))
      allocate (forgp(mfdb))

!!    arrays which contain data related to urban land types in database
      allocate (curbden(mudb))
      allocate (dirtmx(mudb))
      allocate (fcimp(mudb))
      allocate (fimp(mudb))
      allocate (thalf(mudb))
      allocate (tnconc(mudb))
      allocate (tno3conc(mudb))
      allocate (tpconc(mudb))
      allocate (urbcoef(mudb))
      allocate (urbcn2(mudb))

!!    arrays which contain data related to years of rotation,
!!    applications, and HRUs
      allocate (auto_wstr(mnr,mapp,mhru))
!! burn 3/5/09   
      allocate (iburn(mnr,mapp,mhru))  
      allocate (burn_frlb(mnr,mapp,mhru))     
      allocate (fr_curb(mnr,mapp,mhru))
      allocate (cfrt_id(mnr,mapp,mhru))
      allocate (cfrt_kg(mnr,mapp,mhru))
      allocate (cpst_id(mnr,mapp,mhru))
      allocate (cpst_kg(mnr,mapp,mhru))
      allocate (cnop(mnr,mapp*2,mhru))
      allocate (frac_harvk(mnr,mapp*2,mhru))
      allocate (frt_kg(mnr,mapp,mhru))
      allocate (frt_surface(mnr,mapp,mhru))
      allocate (iafer(mnr,mapp,mhru))
      allocate (iairr(mnr,mapp,mhru))
      allocate (icfert(mnr,mapp,mhru))
      allocate (icpest(mnr,mapp,mhru))
      allocate (idtill(mnr,mapp,mhru))
      allocate (wstrs_id(mnr,mapp,mhru))
      allocate (ifert(mnr,mapp,mhru))
      allocate (ifrt_freq(mnr,mapp,mhru))
      allocate (ipst_freq(mnr,mapp,mhru))
      allocate (ifrttyp(mnr,mapp,mhru))
      allocate (iir(mnr,mapp,mhru))
      allocate (iop(mnr,mapp,mhru))
      allocate (ipest(mnr,mapp,mhru))
      allocate (ipst(mnr,mapp,mhru))
      allocate (imp_trig(mnr,mapp,mhru))
      allocate (irelease(mnr,mapp,mhru))
      allocate (irr_amt(mnr,mapp,mhru))
      allocate (irr_asq(mnr,mapp,mhru))
      allocate (irr_mx(mnr,mapp,mhru))
      allocate (irr_sq(mnr,mapp,mhru))
      allocate (irr_eff(mnr,mapp,mhru))
      allocate (irr_efm(mnr,mapp,mhru))
      allocate (irr_salt(mnr,mapp,mhru))
      allocate (isweep(mnr,mapp,mhru))
      allocate (fert_days(mnr,mapp,mhru))
      allocate (pest_days(mnr,mapp,mhru))
      allocate (phuaf(mnr,mapp,mhru))
      allocate (phuai(mnr,mapp,mhru))
 !!   burn 3/5/09
      allocate (phub(mnr,mapp,mhru))     
      allocate (phucf(mnr,mapp,mhru))
      allocate (phucp(mnr,mapp,mhru))
      allocate (phuimp(mnr,mapp,mhru))
      allocate (phuimp_nocrop(mnr,mapp,mhru))
      allocate (phuirr(mnr,mapp,mhru))
      allocate (phun(mnr,mapp,mhru))
      allocate (phun_nocrop(mnr,mapp,mhru))
      allocate (phupst(mnr,mapp,mhru))
      allocate (phupst_nocrop(mnr,mapp,mhru))
      allocate (phusw(mnr,mapp,mhru))
      allocate (phusw_nocrop(mnr,mapp,mhru))
      allocate (phut(mnr,mapp,mhru))
      allocate (phut_nocrop(mnr,mapp,mhru))
      allocate (pst_kg(mnr,mapp,mhru))
!!    changes pesticide incorporation in soil 3/31/08 gsm
      allocate (pst_dep(mnr,mapp,mhru))
      allocate (sweepeff(mnr,mapp,mhru))

!!    arrays which contain data related to years of rotation,
!!    crops grown per year, and HRUs
      allocate (lai_init(mnr,mcr,mhru))
      allocate (bio_aahv(mnr,mcr,mhru))
      allocate (bio_hv(mnr,mcr,mhru))
      allocate (bio_init(mnr,mcr,mhru))
      allocate (bio_targ(mnr,mcr,mhru))
      allocate (hi_targ(mnr,mcr,mhru))
      allocate (idplt(mnr,mcr,mhru))
      allocate (ihv(mnr,mcr,mhru))
      allocate (ikill(mnr,mcr,mhru))
      allocate (iplant(mnr,mcr,mhru))
      allocate (ncrops(mnr,mcr,mhru))
      allocate (orig_phu(mnr,mcr,mhru))
      allocate (orig_tnylda(mnr,mcr,mhru))
      allocate (phu_plt(mnr,mcr,mhru))
      allocate (phuh(mnr,mcr,mhru))
      allocate (phuk(mnr,mcr,mhru))
      allocate (phup(mnr,mcr,mhru))
      allocate (tnyld(mnr,mcr,mhru))
      allocate (tnylda(mnr,mcr,mhru))
      allocate (yldkg(mnr,mcr,mhru))
      allocate (yldn(mnr,mcr,mhru))

!!    arrays which contain data related to years of rotation,
!!    grazings per year, and HRUs
      allocate (bio_eat(mnr,mgr,mhru))
      allocate (bio_trmp(mnr,mgr,mhru))
      allocate (grz_days(mnr,mgr,mhru))
      allocate (manure_id(mnr,mgr,mhru))
      allocate (igraz(mnr,mgr,mhru))
      allocate (phug(mnr,mgr,mhru))
      allocate (manure_kg(mnr,mgr,mhru))

!!    arrays which contain data related to years of rotation,
!!    cuttings per year, and HRUs
      allocate (hi_ovr(mnr,mcut,mhru))
      allocate (harveff(mnr,mcut,mhru))
      allocate (ihvo(mnr,mcut,mhru))
      allocate (ihv_gbm(mnr,mcut,mhru))
      allocate (phuho(mnr,mcut,mhru))

!!    arrays which contain data related to tillages in the database
      allocate (deptil(mtil))
      allocate (effmix(mtil))

!!    arrays which contain data related to hydrograph nodes
      allocate (hyd_dakm(mhyd))
      allocate (icodes(mhyd))
      allocate (ihouts(mhyd))
      allocate (inum1s(mhyd))
      allocate (inum2s(mhyd))
      allocate (inum3s(mhyd))
      allocate (inum4s(mhyd))
      allocate (inum5s(mhyd))
      allocate (reccnstps(mhyd))
      allocate (recmonps(mhyd))
      allocate (rnum1s(mhyd))
      allocate (subed(mhyd))

      allocate (shyd(8,mhyd))
      allocate (varoute(mvaro,mhyd))
      allocate (hhvaroute(mvaro,mhyd,24))

!!    arrays which contain data related to HRUs
      allocate (aairr(mhru))
      allocate (afrt_surface(mhru))
      allocate (aird(mhru))
      allocate (alpha_bf(mhru))
      allocate (alpha_bfe(mhru))
      allocate (anano3(mhru))
      allocate (anion_excl(mhru))
      allocate (auto_eff(mhru))
      allocate (auto_nyr(mhru))
      allocate (auto_napp(mhru))
      allocate (auto_nstrs(mhru))
      allocate (bactlp_plt(mhru))
      allocate (bactlpq(mhru))
      allocate (bactlps(mhru))
      allocate (bactp_plt(mhru))
      allocate (bactpq(mhru))
      allocate (bactps(mhru))
      allocate (bio_aams(mhru))
      allocate (bio_min(mhru))
      allocate (bio_ms(mhru))
      allocate (bio_yrms(mhru))
      allocate (biomix(mhru))
      allocate (bp1(mhru))
      allocate (bp2(mhru))
      allocate (brt(mhru))
      allocate (bw1(mhru))
      allocate (bw2(mhru))
      allocate (canmx(mhru))
      allocate (canstor(mhru))
      allocate (cbodu(mhru))
      allocate (ch_l1(mhru))
      allocate (chl_a(mhru))
      allocate (chlap(mhru))
      allocate (chlaw(mhru))
      allocate (cht(mhru))
      allocate (cklsp(mhru))
      allocate (cn1(mhru))
      allocate (cn2(mhru))
      allocate (cn3(mhru))
      allocate (cnday(mhru))
      allocate (cont_cn(20,mhru))
      allocate (cont_p(20,mhru))
      allocate (cropno_upd(20,mhru))
      allocate (curyr_mat(mhru))
      allocate (dayl(mhru))
      allocate (det_san(mhru))
      allocate (det_sil(mhru))
      allocate (det_cla(mhru))
      allocate (det_sag(mhru))
      allocate (det_lag(mhru))
      allocate (ddrain(mhru))
      allocate (deepirr(mhru))
      allocate (deepst(mhru))
      allocate (delay(mhru))
      allocate (dep_imp(mhru))
      allocate (dis_stream(mhru))
      allocate (divmax(mhru))
      allocate (dormhr(mhru))
      allocate (doxq(mhru))
      allocate (drain_d(20,mhru))
      allocate (drain_idep(20,mhru))
      allocate (drain_t(20,mhru))
      allocate (drain_g(20,mhru))
      allocate (driftco(mhru))
      allocate (dr_sub(mhru))
      allocate (epco(mhru))
      allocate (esco(mhru))
      allocate (erorgn(mhru))
      allocate (erorgp(mhru))
      allocate (evpot(mhru))
      allocate (evpnd(mhru))
      allocate (evwet(mhru))
      allocate (ffc(mhru))
      allocate (filterw(mhru))
      allocate (filt_w(20,mhru))
      allocate (fire_cn(20,mhru))
      allocate (fld_fr(mhru))
      allocate (flowfr(mhru))
      allocate (flowmin(mhru))
      allocate (fsred(mhru))
      allocate (gdrain(mhru))
      allocate (grwat_n(mhru))
      allocate (grwat_i(mhru))
      allocate (grwat_l(mhru))
      allocate (grwat_w(mhru))
      allocate (grwat_d(mhru))
      allocate (grwat_s(mhru))
      allocate (grwat_spcon(mhru))
      allocate (gwati(20,mhru))
      allocate (gwatn(20,mhru))
      allocate (gwatl(20,mhru))
      allocate (gwatw(20,mhru))
      allocate (gwatd(20,mhru))
      allocate (gwatveg(20,mhru))
      allocate (gwats(20,mhru))
      allocate (gwatspcon(20,mhru))
      allocate (gwata(20,mhru))
      allocate (gw_delaye(mhru))
      allocate (gw_nloss(mhru))
      allocate (gw_q(mhru))
      allocate (gw_revap(mhru))
      allocate (gw_spyld(mhru))
      allocate (gwht(mhru))
      allocate (gwminp(mhru))
      allocate (gwno3(mhru))
      allocate (gwqmn(mhru))
      allocate (hi_upd(20,mhru))
      allocate (hru_dafr(mhru))
      allocate (hru_fr(mhru))
      allocate (hru_ha(mhru))
      allocate (hru_km(mhru))
      allocate (hru_ra(mhru))
      allocate (hru_rmx(mhru))
      allocate (hru_slp(mhru))
      allocate (hru_sub(mhru))
      allocate (hru_seq(mhru))
      allocate (hrugis(mhru))
      allocate (hrupest(mhru))
      allocate (hvstiadj(mhru))
      allocate (iafrttyp(mhru))
      !! burns 3/5/09
      allocate (i_burn(mhru))
      allocate (icont(20,mhru))
      allocate (icfrt(mhru))
      allocate (icpst(mhru))
      allocate (icnop(mhru))
      allocate (icr(mhru))
      allocate (iday_fert(mhru))
      allocate (iday_pest(mhru))
      allocate (idorm(mhru))
      allocate (ifilt(20,mhru))
      allocate (ifld(mhru))
      allocate (iflod1(mhru))
      allocate (iflod2(mhru))
      allocate (igro(mhru))
      allocate (igrz(mhru))
      allocate (iopday(20,mhru))
      allocate (iopyr(20,mhru))
      allocate (mgt_ops(20,mhru))
      allocate (ioper(mhru))
!     allocate (ipdhru(mhruo))
      imho = max(mhru,20)
      allocate (ipdhru(imho))
      allocate (ipnd1(mhru))
      allocate (ipnd2(mhru))
      allocate (ipot(mhru))
      allocate (irip(mhru))
      allocate (irn(mhru))
      allocate (irrno(mhru))
      allocate (irrsc(mhru))
      allocate (istrip(20,mhru))
      allocate (itdrain(20,mhru))
      allocate (iterr(20,mhru))
      allocate (iurban(mhru))
      allocate (iwatable(mhru))
      allocate (iycont(20,mhru))
      allocate (iyfilt(20,mhru))
      allocate (iydrain(20,mhru))
      allocate (iystrip(20,mhru))
      allocate (iyterr(20,mhru))
      allocate (lai_aamx(mhru))
      allocate (lai_yrmx(mhru))
      allocate (laiday(mhru))
      allocate (laimxfr(mhru))
      allocate (laimx_upd(20,mhru))
      allocate (lat_sed(mhru))
      allocate (lat_ttime(mhru))
      allocate (latno3(mhru))
      allocate (latq(mhru))
      allocate (ldrain(mhru))
      allocate (minpgw(mhru))
      allocate (nafert(mhru))
      allocate (nair(mhru))
      allocate (ncf(mhru))
      allocate (ncpest(mhru))
      allocate (ncut(mhru))
      allocate (ndeat(mhru))
      allocate (ndcfrt(mhru))
      allocate (ndcpst(mhru))
      allocate (ndtarg(mhru))
      allocate (newrti(mhru))
      allocate (nfert(mhru))
      allocate (ngr(mhru))
      allocate (ngrwat(mhru))
      allocate (nirr(mhru))
      allocate (nmgt(mhru))
      allocate (no3gw(mhru))
      allocate (npcp(mhru))
      allocate (npest(mhru))
      allocate (nplnt(mhru))
      allocate (nrelease(mhru))
      allocate (nro(mhru))
      allocate (nrot(mhru))
      allocate (nsweep(mhru))
      allocate (ntil(mhru))
      allocate (olai(mhru))
      allocate (orig_alai(mhru))
      allocate (orig_bioms(mhru))
      allocate (orig_deepst(mhru))
      allocate (orig_igro(mhru))
      allocate (orig_phuacc(mhru))
      allocate (orig_pndno3(mhru))
      allocate (orig_pndorgn(mhru))
      allocate (orig_pndorgp(mhru))
      allocate (orig_pndsed(mhru))
      allocate (orig_pndsolp(mhru))
      allocate (orig_pndvol(mhru))
      allocate (orig_potno3(mhru))
      allocate (orig_potsed(mhru))
      allocate (orig_potvol(mhru))
      allocate (orig_shallst(mhru))
      allocate (orig_snohru(mhru))
      allocate (orig_solcov(mhru))
      allocate (orig_solsw(mhru))
      allocate (orig_sumix(mhru))
      allocate (orig_wetno3(mhru))
      allocate (orig_wetorgn(mhru))
      allocate (orig_wetorgp(mhru))
      allocate (orig_wetsed(mhru))
      allocate (orig_wetsolp(mhru))
      allocate (orig_wetvol(mhru))
      allocate (ov_n(mhru))
      allocate (ovrlnd(mhru))
      allocate (percn(mhru))
      allocate (phuacc(mhru))
      allocate (phubase(mhru))
      allocate (plantn(mhru))
      allocate (plantp(mhru))
      allocate (plt_et(mhru))
      allocate (plt_pet(mhru))
      allocate (pltfr_n(mhru))
      allocate (pltfr_p(mhru))
      allocate (pnd_chla(mhru))
      allocate (pnd_esa(mhru))
      allocate (pnd_evol(mhru))
      allocate (pnd_fr(mhru))
      allocate (pnd_k(mhru))
      allocate (pnd_no3(mhru))
      allocate (pnd_no3g(mhru))
      allocate (pnd_no3s(mhru))
      allocate (pnd_nsed(mhru))
      allocate (pnd_orgn(mhru))
      allocate (pnd_orgp(mhru))
      allocate (pnd_psa(mhru))
      allocate (pnd_psed(mhru))
      allocate (pnd_pvol(mhru))
      allocate (pnd_seci(mhru))
      allocate (pnd_sed(mhru))

      allocate (pnd_san(mhru))
      allocate (pnd_sil(mhru))
      allocate (pnd_cla(mhru))
      allocate (pnd_sag(mhru))
      allocate (pnd_lag(mhru))

      allocate (pnd_solp(mhru))
      allocate (pnd_solpg(mhru))
      allocate (pnd_vol(mhru))
      allocate (pot_fr(mhru))
      allocate (pot_no3(mhru))
      allocate (pot_no3l(mhru))
      allocate (pot_nsed(mhru))
      allocate (pot_sed(mhru))
      allocate (pot_san(mhru))
      allocate (pot_sil(mhru))
      allocate (pot_cla(mhru))
      allocate (pot_sag(mhru))
      allocate (pot_lag(mhru))

      allocate (pot_tile(mhru))
      allocate (pot_vol(mhru))
      allocate (pot_volx(mhru))
      allocate (potflwi(mhru))
      allocate (potsa(mhru))
      allocate (potsedi(mhru))
      
      allocate (potsani(mhru))
      allocate (potsili(mhru))
      allocate (potclai(mhru))
      allocate (potsagi(mhru))
      allocate (potlagi(mhru))

      allocate (pplnt(mhru))
      allocate (qdr(mhru))
      allocate (rch_dakm(mhru))
      allocate (rchrg(mhru))
      allocate (rchrg_n(mhru))
      allocate (rchrg_dp(mhru))
      allocate (revapmn(mhru))
      allocate (rhd(mhru))
      allocate (rip_fr(mhru))
      allocate (rnd2(mhru))
      allocate (rnd3(mhru))
      allocate (rnd8(mhru))
      allocate (rnd9(mhru))
      allocate (rsdin(mhru))
      allocate (rwt(mhru))
      allocate (sci(mhru))
      allocate (seccip(mhru))
      allocate (secciw(mhru))
      allocate (sed_stl(mhru))
      allocate (sedminpa(mhru))
      allocate (sedminps(mhru))
      allocate (sedorgn(mhru))
      allocate (sedorgp(mhru))
      allocate (sedyld(mhru))

      allocate (sanyld(mhru))
      allocate (silyld(mhru))
      allocate (clayld(mhru))
      allocate (sagyld(mhru))
      allocate (lagyld(mhru))
      allocate (grayld(mhru))

      allocate (sepbtm(mhru))
      allocate (shallirr(mhru))
      allocate (rchrg_src(mhru))
      allocate (shallst(mhru))
      allocate (shallst_n(mhru))
      allocate (slsoil(mhru))
      allocate (slsubbsn(mhru))
      allocate (smx(mhru))
      allocate (sno_hru(mhru))
      allocate (snotmp(mhru))
      allocate (sol_alb(mhru))
      allocate (sol_avbd(mhru))
      allocate (sol_avpor(mhru))
      allocate (sol_cnsw(mhru))
      allocate (sol_cov(mhru))
      allocate (sol_crk(mhru))
      allocate (sol_nly(mhru))
      allocate (sol_sumfc(mhru))
      allocate (sol_sumul(mhru))
      allocate (sol_sumwp(mhru))
      allocate (sol_sw(mhru))
      allocate (sol_zmx(mhru))
      allocate (strip_n(20,mhru))
      allocate (strip_cn(20,mhru))
      allocate (strip_c(20,mhru))
      allocate (strip_p(20,mhru))
      allocate (strsa(mhru))
      allocate (strsn(mhru))
      allocate (strsp(mhru))
      allocate (strstmp(mhru))
      allocate (strsw(mhru))
      allocate (stsol_rd(mhru))
      allocate (subp(mhru))
      allocate (sumix(mhru))
      allocate (surfq(mhru))
      allocate (surqno3(mhru))
      allocate (surqsolp(mhru))
      allocate (swtrg(mhru))
      allocate (t_ov(mhru))
      allocate (tauton(mhru))
      allocate (tautop(mhru))
      allocate (tcfrtn(mhru))
      allocate (tcfrtp(mhru))
      allocate (tconc(mhru))
      allocate (tdrain(mhru))
      allocate (tc_gwat(mhru))
      allocate (terr_cn(20,mhru))
      allocate (terr_p(20,mhru))
      allocate (terr_sl(20,mhru))
      allocate (tfertn(mhru))
      allocate (tfertp(mhru))
      allocate (tgrazn(mhru))
      allocate (tgrazp(mhru))
      allocate (tile_ttime(mhru))
      allocate (tileq(mhru))
      allocate (tileno3(mhru))
      allocate (tmn(mhru))
      allocate (tmp_hi(mhru))
      allocate (tmp_lo(mhru))
      allocate (tmpav(mhru))
      allocate (tmpavp(mhru))
      allocate (tmx(mhru))
      allocate (trapeff(mhru))
      allocate (twash(mhru))
      allocate (u10(mhru))
      allocate (urblu(mhru))
      allocate (usle_k(mhru))
      allocate (usle_mult(mhru))
      allocate (usle_ls(mhru))
      allocate (usle_p(mhru))
      allocate (wtab(mhru))
      allocate (wtab_mn(mhru))
      allocate (wtab_mx(mhru))
      allocate (wet_chla(mhru))
      allocate (wet_fr(mhru))
      allocate (wet_k(mhru))
      allocate (wet_mxsa(mhru))
      allocate (wet_mxvol(mhru))
      allocate (wet_no3(mhru))
      allocate (wet_no3g(mhru))
      allocate (wet_no3s(mhru))
      allocate (wet_nsa(mhru))
      allocate (wet_nsed(mhru))
      allocate (wet_nvol(mhru))
      allocate (wet_orgn(mhru))
      allocate (wet_orgp(mhru))
      allocate (wet_psed(mhru))
      allocate (wet_seci(mhru))
      allocate (wet_sed(mhru))
      allocate (wet_solp(mhru))
      allocate (wet_solpg(mhru))
      allocate (wet_vol(mhru))
      allocate (wfsh(mhru))
      allocate (yldaa(mhru))
      allocate (yldanu(mhru))

      allocate (wet_san(mhru))
      allocate (wet_sil(mhru))
      allocate (wet_cla(mhru))
      allocate (wet_sag(mhru))
      allocate (wet_lag(mhru))

      allocate (frad(mhru,24))
      allocate (hhsubp(mhru,24))

      allocate (rainsub(mhru,mstep))
      allocate (precipdt(mstep+1))

      allocate (bss(4,mhru))
      allocate (nsetlp(2,mhru))
      allocate (nsetlw(2,mhru))
      allocate (psetlp(2,mhru))
      allocate (psetlw(2,mhru))
      allocate (wrt(2,mhru))
      allocate (wgncur(3,mhru))
      allocate (wgnold(3,mhru))
      allocate (surf_bs(17,mhru))
      allocate (rndseed(10,mhru))
      allocate (pcpband(10,mhru))
      allocate (snoeb(10,mhru))
      allocate (orig_snoeb(10,mhru))
      allocate (snotmpeb(10,mhru))
      allocate (tavband(10,mhru))
      allocate (tmnband(10,mhru))
      allocate (tmxband(10,mhru))
      allocate (wudeep(12,mhru))
      allocate (wupnd(12,mhru))
      allocate (wushal(12,mhru))
      allocate (phi(13,msub+1))
      allocate (wat_phi(13,mhru))
      allocate (rfqeo_30d(30,mhru))
      allocate (eo_30d(30,mhru))


!!    arrays which contain data related to pesticides, HRUs
      allocate (orig_pltpst(mpst,mhru))
      allocate (plt_pst(mpst,mhru))
      allocate (pst_enr(mpst,mhru))
      allocate (pst_sed(mpst,mhru))
      allocate (pst_surq(mpst,mhru))
      allocate (zdb(mpst,mhru))

      allocate (pst_lag(mpst,3,mhru))


!!    arrays which contain data related to HRU output 
      allocate (hrupsta(mpst,4,mhru))
      allocate (hrupstd(mpst,4,mhru))
      allocate (hrupstm(mpst,4,mhru))
      allocate (hrupsty(mpst,4,mhru))
      allocate (icols(mhruo))
      allocate (ipdvas(mhruo))
      allocate (hrumono(70,mhru))
      allocate (hruyro(70,mhru))
      allocate (hruaao(70,mhru))
      allocate (wtrmon(40,mhru))
      allocate (wtryr(40,mhru))
      allocate (wtraa(40,mhru))

!!    arrays which contain data related to pesticides
      allocate (lat_pst(mpst))
      allocate (npno(mpst))
      allocate (pstsol(mpst))
      allocate (wshd_pstap(mpst))
      allocate (wshd_pstdg(mpst))

!!    arrays which contain data related to years
      allocate (flocnst(mrecc))
      allocate (sedcnst(mrecc))
      allocate (orgncnst(mrecc))
      allocate (orgpcnst(mrecc))
      allocate (no3cnst(mrecc))
      allocate (minpcnst(mrecc))
      allocate (nh3cnst(mrecc))
      allocate (no2cnst(mrecc))
      allocate (bactpcnst(mrecc))
      allocate (bactlpcnst(mrecc))
      allocate (cmtl1cnst(mrecc))
      allocate (cmtl2cnst(mrecc))
      allocate (cmtl3cnst(mrecc))
      allocate (chlacnst(mrecc))
      allocate (disoxcnst(mrecc))
      allocate (cbodcnst(mrecc))
      allocate (solpstcnst(mrecc))
      allocate (srbpstcnst(mrecc))

      allocate (floyr(mrecy,myr))
      allocate (sedyr(mrecy,myr))
      allocate (orgnyr(mrecy,myr))
      allocate (orgpyr(mrecy,myr))
      allocate (no3yr(mrecy,myr))
      allocate (minpyr(mrecy,myr))
      allocate (nh3yr(mrecy,myr))
      allocate (no2yr(mrecy,myr))
      allocate (bactpyr(mrecy,myr))
      allocate (bactlpyr(mrecy,myr))
      allocate (cmtl1yr(mrecy,myr))
      allocate (cmtl2yr(mrecy,myr))
      allocate (cmtl3yr(mrecy,myr))
      allocate (chlayr(mrecy,myr))
      allocate (disoxyr(mrecy,myr))
      allocate (cbodyr(mrecy,myr))
      allocate (solpstyr(mrecy,myr))
      allocate (srbpstyr(mrecy,myr))

      allocate (flomon(mrecm,myr,12))
      allocate (sedmon(mrecm,myr,12))
      allocate (orgnmon(mrecm,myr,12))
      allocate (orgpmon(mrecm,myr,12))
      allocate (no3mon(mrecm,myr,12))
      allocate (minpmon(mrecm,myr,12))
      allocate (nh3mon(mrecm,myr,12))
      allocate (no2mon(mrecm,myr,12))
      allocate (bactpmon(mrecm,myr,12))
      allocate (bactlpmon(mrecm,myr,12))
      allocate (cmtl1mon(mrecm,myr,12))
      allocate (cmtl2mon(mrecm,myr,12))
      allocate (cmtl3mon(mrecm,myr,12))
      allocate (chlamon(mrecm,myr,12))
      allocate (disoxmon(mrecm,myr,12))
      allocate (cbodmon(mrecm,myr,12))
      allocate (solpstmon(mrecm,myr,12))
      allocate (srbpstmon(mrecm,myr,12))

!!    arrays
      allocate (ndays(13))
      allocate (idg(9))
      allocate (ndmo(12))
      allocate (halgae(24))
      allocate (hbactlp(24))
      allocate (hbactp(24))
      allocate (hbod(24))
      allocate (hchla(24))
      allocate (hdepth(24))
      allocate (hdisox(24))
      allocate (hharea(24))
      allocate (hhprecip(24))
      allocate (hhqday(24))
      allocate (hhstor(24))
      allocate (hhtime(24))
      allocate (hnh4(24))
      allocate (hno2(24))
      allocate (hno3(24))
      allocate (horgn(24))
      allocate (horgp(24))
      allocate (hrchwtr(24))
      allocate (hrtwtr(24))
      allocate (hsdti(24))
      allocate (hsedst(24))
      allocate (hsedyld(24))
      allocate (hsolp(24))
      allocate (hsolpst(24))
      allocate (hsorpst(24))
      allocate (wshdaao(mstdo))
      allocate (wshddayo(mstdo))
      allocate (wshdmono(mstdo))
      allocate (wshdyro(mstdo))
      allocate (fcstaao(24))

      allocate (wpstaao(mpst,5))
      allocate (wpstmono(mpst,5))
      allocate (wpstyro(mpst,5))
      allocate (wpstdayo(mpst,5))

      allocate (wshd_aamon(12,8))

!!arrays that store initial values
      allocate (ivar_orig(10))
      allocate (rvar_orig(10))
      allocate (wattemp(mch))
      allocate (variimon(nauto,16))
      allocate (variiyr(nauto,16))
      allocate (itelmon(nauto))
      allocate (itelyr(nauto))
      allocate (variimons(nsave,16))
      allocate (variiyrs(nsave,16))
      allocate (itelmons(nsave))
      allocate (itelyrs(nsave))
      

!! sj, june 07 modifications to carbon balance routines
      allocate (sol_n(mlyr,mhru))
!! sj, june 07 end

!! sj dec 07 modification tillage
      allocate (sol_bdp(mlyr,mhru))
!! sj dec 07 end

!!Armen Jan 2008
      allocate (tillagef(mlyr,mhru))
!  test rtfr
      allocate (rtfr(mlyr))

!!    added for manure Armen Jan 2009
      allocate (sol_mc(mlyr,mhru))
      allocate (sol_mn(mlyr,mhru))
      allocate (sol_mp(mlyr,mhru))



!!Armen Jan 2008 end
!! additional var by Ann
!! Filter Strip variable allocation MJW
      allocate (vfscon(mhru))
      allocate (vfsratio(mhru))
      allocate (vfsch(mhru))
      allocate (vfsi(mhru))
      allocate (filter_i(20,mhru))
      allocate (filter_ratio(20,mhru))
      allocate (filter_con(20,mhru))
      allocate (filter_ch(20,mhru))  
	  
      call zero0
      call zero1
      call zero2
      call zeroini
	   
      return
      end
