/* 
make_zero_flux_struct.c
create structures initialized with zero for forcing fluxes to zero
between simulation days

*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
Biome-BGC version 4.2 (final release)
See copyright.txt for Copyright information
*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
*/

#include "bgc.h"

int make_zero_flux_struct(wflux_struct* wf, cflux_struct* cf,
nflux_struct* nf)
{
	int ok=1;
	/* daily water fluxes */
	wf->prcp_to_canopyw = 0.0;
	wf->prcp_to_soilw = 0.0;
	wf->prcp_to_snoww = 0.0;
	wf->canopyw_evap = 0.0;
	wf->canopyw_to_soilw = 0.0;
	wf->snoww_subl = 0.0;
	wf->snoww_to_soilw = 0.0;
	wf->soilw_evap = 0.0;
	wf->soilw_trans = 0.0;
	wf->soilw_outflow = 0.0;
	
	/* daily carbon fluxes */
	cf->m_leafc_to_litr1c = 0.0;
	cf->m_leafc_to_litr2c = 0.0;
	cf->m_leafc_to_litr3c = 0.0;
	cf->m_leafc_to_litr4c = 0.0;
	cf->m_frootc_to_litr1c = 0.0;
	cf->m_frootc_to_litr2c = 0.0;
	cf->m_frootc_to_litr3c = 0.0;
	cf->m_frootc_to_litr4c = 0.0;
	cf->m_leafc_storage_to_litr1c = 0.0;
	cf->m_frootc_storage_to_litr1c = 0.0;
	cf->m_livestemc_storage_to_litr1c = 0.0;
	cf->m_deadstemc_storage_to_litr1c = 0.0;
	cf->m_livecrootc_storage_to_litr1c = 0.0;
	cf->m_deadcrootc_storage_to_litr1c = 0.0;
	cf->m_leafc_transfer_to_litr1c = 0.0;
	cf->m_frootc_transfer_to_litr1c = 0.0;
	cf->m_livestemc_transfer_to_litr1c = 0.0;
	cf->m_deadstemc_transfer_to_litr1c = 0.0;
	cf->m_livecrootc_transfer_to_litr1c = 0.0;
	cf->m_deadcrootc_transfer_to_litr1c = 0.0;
    cf->m_livestemc_to_cwdc = 0.0;
    cf->m_deadstemc_to_cwdc = 0.0;
    cf->m_livecrootc_to_cwdc = 0.0;
    cf->m_deadcrootc_to_cwdc = 0.0;
	cf->m_gresp_storage_to_litr1c = 0.0;
    cf->m_gresp_transfer_to_litr1c = 0.0;
	cf->m_leafc_to_fire = 0.0;
	cf->m_frootc_to_fire = 0.0;
	cf->m_leafc_storage_to_fire = 0.0;
	cf->m_frootc_storage_to_fire = 0.0;
	cf->m_livestemc_storage_to_fire = 0.0;
	cf->m_deadstemc_storage_to_fire = 0.0;
	cf->m_livecrootc_storage_to_fire = 0.0;
	cf->m_deadcrootc_storage_to_fire = 0.0;
	cf->m_leafc_transfer_to_fire = 0.0;
	cf->m_frootc_transfer_to_fire = 0.0;
	cf->m_livestemc_transfer_to_fire = 0.0;
	cf->m_deadstemc_transfer_to_fire = 0.0;
	cf->m_livecrootc_transfer_to_fire = 0.0;
	cf->m_deadcrootc_transfer_to_fire = 0.0;
    cf->m_livestemc_to_fire = 0.0;
    cf->m_deadstemc_to_fire = 0.0;
    cf->m_livecrootc_to_fire = 0.0;
    cf->m_deadcrootc_to_fire = 0.0;
	cf->m_gresp_storage_to_fire = 0.0;
    cf->m_gresp_transfer_to_fire = 0.0;
	cf->m_litr1c_to_fire = 0.0;
	cf->m_litr2c_to_fire = 0.0;
	cf->m_litr3c_to_fire = 0.0;
	cf->m_litr4c_to_fire = 0.0;
	cf->m_cwdc_to_fire = 0.0;
    cf->leafc_transfer_to_leafc = 0.0;
    cf->frootc_transfer_to_frootc = 0.0;
    cf->livestemc_transfer_to_livestemc = 0.0;
    cf->deadstemc_transfer_to_deadstemc = 0.0;
    cf->livecrootc_transfer_to_livecrootc = 0.0;
    cf->deadcrootc_transfer_to_deadcrootc = 0.0;
    cf->leafc_to_litr1c = 0.0;
    cf->leafc_to_litr2c = 0.0;
    cf->leafc_to_litr3c = 0.0;
    cf->leafc_to_litr4c = 0.0;
    cf->frootc_to_litr1c = 0.0;
    cf->frootc_to_litr2c = 0.0;
    cf->frootc_to_litr3c = 0.0;
    cf->frootc_to_litr4c = 0.0;
    cf->leaf_day_mr = 0.0;
    cf->leaf_night_mr = 0.0;
    cf->froot_mr = 0.0;
    cf->livestem_mr = 0.0;
	cf->livecroot_mr = 0.0;
    cf->psnsun_to_cpool = 0.0;
    cf->psnshade_to_cpool = 0.0;
    cf->cwdc_to_litr2c = 0.0;
    cf->cwdc_to_litr3c = 0.0;
    cf->cwdc_to_litr4c = 0.0;
    cf->litr1_hr = 0.0;
    cf->litr1c_to_soil1c = 0.0;
    cf->litr2_hr = 0.0;
    cf->litr2c_to_soil2c = 0.0;
    cf->litr3c_to_litr2c = 0.0;
    cf->litr4_hr = 0.0;
    cf->litr4c_to_soil3c = 0.0;
    cf->soil1_hr = 0.0;
    cf->soil1c_to_soil2c = 0.0;
    cf->soil2_hr = 0.0;
    cf->soil2c_to_soil3c = 0.0;
    cf->soil3_hr = 0.0;
    cf->soil3c_to_soil4c = 0.0;
    cf->soil4_hr = 0.0;
    cf->cpool_to_leafc = 0.0;
    cf->cpool_to_leafc_storage = 0.0;
    cf->cpool_to_frootc = 0.0;
    cf->cpool_to_frootc_storage = 0.0;
    cf->cpool_to_livestemc = 0.0;
    cf->cpool_to_livestemc_storage = 0.0;
    cf->cpool_to_deadstemc = 0.0;
    cf->cpool_to_deadstemc_storage = 0.0;
    cf->cpool_to_livecrootc = 0.0;
    cf->cpool_to_livecrootc_storage = 0.0;
    cf->cpool_to_deadcrootc = 0.0;
    cf->cpool_to_deadcrootc_storage = 0.0;
    cf->cpool_to_gresp_storage = 0.0;
    cf->cpool_leaf_gr = 0.0;
    cf->cpool_leaf_storage_gr = 0.0;
    cf->transfer_leaf_gr = 0.0;
    cf->cpool_froot_gr = 0.0;
    cf->cpool_froot_storage_gr = 0.0;
    cf->transfer_froot_gr = 0.0;
    cf->cpool_livestem_gr = 0.0;
    cf->cpool_livestem_storage_gr = 0.0;
    cf->transfer_livestem_gr = 0.0;
    cf->cpool_deadstem_gr = 0.0;
    cf->cpool_deadstem_storage_gr = 0.0;
    cf->transfer_deadstem_gr = 0.0;
    cf->cpool_livecroot_gr = 0.0;
    cf->cpool_livecroot_storage_gr = 0.0;
    cf->transfer_livecroot_gr = 0.0;
    cf->cpool_deadcroot_gr = 0.0;
    cf->cpool_deadcroot_storage_gr = 0.0;
    cf->transfer_deadcroot_gr = 0.0;
    cf->leafc_storage_to_leafc_transfer = 0.0;
    cf->frootc_storage_to_frootc_transfer = 0.0;
    cf->livestemc_storage_to_livestemc_transfer = 0.0;
    cf->deadstemc_storage_to_deadstemc_transfer = 0.0;
    cf->livecrootc_storage_to_livecrootc_transfer = 0.0;
    cf->deadcrootc_storage_to_deadcrootc_transfer = 0.0;
    cf->gresp_storage_to_gresp_transfer = 0.0;
    cf->livestemc_to_deadstemc = 0.0;
    cf->livecrootc_to_deadcrootc = 0.0;
	         	
	/* daily nitrogen fluxes */
	nf->m_leafn_to_litr1n = 0.0;
	nf->m_leafn_to_litr2n = 0.0;
	nf->m_leafn_to_litr3n = 0.0;
	nf->m_leafn_to_litr4n = 0.0;
	nf->m_frootn_to_litr1n = 0.0;
	nf->m_frootn_to_litr2n = 0.0;
	nf->m_frootn_to_litr3n = 0.0;
	nf->m_frootn_to_litr4n = 0.0;
	nf->m_leafn_storage_to_litr1n = 0.0;
    nf->m_frootn_storage_to_litr1n = 0.0;
    nf->m_livestemn_storage_to_litr1n = 0.0;
    nf->m_deadstemn_storage_to_litr1n = 0.0;
    nf->m_livecrootn_storage_to_litr1n = 0.0;
    nf->m_deadcrootn_storage_to_litr1n = 0.0;
    nf->m_leafn_transfer_to_litr1n = 0.0;
    nf->m_frootn_transfer_to_litr1n = 0.0;
    nf->m_livestemn_transfer_to_litr1n = 0.0;
    nf->m_deadstemn_transfer_to_litr1n = 0.0;
    nf->m_livecrootn_transfer_to_litr1n = 0.0;
    nf->m_deadcrootn_transfer_to_litr1n = 0.0;
    nf->m_livestemn_to_litr1n = 0.0;
    nf->m_livestemn_to_cwdn = 0.0;
    nf->m_deadstemn_to_cwdn = 0.0;
    nf->m_livecrootn_to_litr1n = 0.0;
    nf->m_livecrootn_to_cwdn = 0.0;
    nf->m_deadcrootn_to_cwdn = 0.0;
	nf->m_retransn_to_litr1n = 0.0;
	nf->m_leafn_to_fire = 0.0;
	nf->m_frootn_to_fire = 0.0;
	nf->m_leafn_storage_to_fire = 0.0;
    nf->m_frootn_storage_to_fire = 0.0;
    nf->m_livestemn_storage_to_fire = 0.0;
    nf->m_deadstemn_storage_to_fire = 0.0;
    nf->m_livecrootn_storage_to_fire = 0.0;
    nf->m_deadcrootn_storage_to_fire = 0.0;
    nf->m_leafn_transfer_to_fire = 0.0;
    nf->m_frootn_transfer_to_fire = 0.0;
    nf->m_livestemn_transfer_to_fire = 0.0;
    nf->m_deadstemn_transfer_to_fire = 0.0;
    nf->m_livecrootn_transfer_to_fire = 0.0;
    nf->m_deadcrootn_transfer_to_fire = 0.0;
    nf->m_livestemn_to_fire = 0.0;
    nf->m_deadstemn_to_fire = 0.0;
    nf->m_livecrootn_to_fire = 0.0;
    nf->m_deadcrootn_to_fire = 0.0;
	nf->m_retransn_to_fire = 0.0;
	nf->m_litr1n_to_fire = 0.0;
	nf->m_litr2n_to_fire = 0.0;
	nf->m_litr3n_to_fire = 0.0;
	nf->m_litr4n_to_fire = 0.0;
	nf->m_cwdn_to_fire = 0.0;
    nf->leafn_transfer_to_leafn = 0.0;
    nf->frootn_transfer_to_frootn = 0.0;
    nf->livestemn_transfer_to_livestemn = 0.0;
    nf->deadstemn_transfer_to_deadstemn = 0.0;
    nf->livecrootn_transfer_to_livecrootn = 0.0;
    nf->deadcrootn_transfer_to_deadcrootn = 0.0;
    nf->leafn_to_litr1n = 0.0;
    nf->leafn_to_litr2n = 0.0;
    nf->leafn_to_litr3n = 0.0;
    nf->leafn_to_litr4n = 0.0;
    nf->leafn_to_retransn = 0.0;
    nf->frootn_to_litr1n = 0.0;
    nf->frootn_to_litr2n = 0.0;
    nf->frootn_to_litr3n = 0.0;
    nf->frootn_to_litr4n = 0.0;
    nf->ndep_to_sminn = 0.0; 
    nf->nfix_to_sminn = 0.0; 
    nf->cwdn_to_litr2n = 0.0;
    nf->cwdn_to_litr3n = 0.0;
    nf->cwdn_to_litr4n = 0.0;
    nf->litr1n_to_soil1n = 0.0;
    nf->sminn_to_soil1n_l1 = 0.0;
    nf->litr2n_to_soil2n = 0.0;
    nf->sminn_to_soil2n_l2 = 0.0;
    nf->litr3n_to_litr2n = 0.0;
    nf->litr4n_to_soil3n = 0.0;
    nf->sminn_to_soil3n_l4 = 0.0;
    nf->soil1n_to_soil2n = 0.0;
    nf->sminn_to_soil2n_s1 = 0.0;
    nf->soil2n_to_soil3n = 0.0;
    nf->sminn_to_soil3n_s2 = 0.0;
    nf->soil3n_to_soil4n = 0.0;
    nf->sminn_to_soil4n_s3 = 0.0;
    nf->soil4n_to_sminn = 0.0;
	nf->sminn_to_nvol_l1s1 = 0.0;
	nf->sminn_to_nvol_l2s2 = 0.0;
	nf->sminn_to_nvol_l4s3 = 0.0;
	nf->sminn_to_nvol_s1s2 = 0.0;
	nf->sminn_to_nvol_s2s3 = 0.0;
	nf->sminn_to_nvol_s3s4 = 0.0;
	nf->sminn_to_nvol_s4 = 0.0;
	nf->sminn_to_denitrif = 0.0;
    nf->sminn_leached = 0.0; 
	nf->retransn_to_npool = 0.0;  
    nf->sminn_to_npool = 0.0;
    nf->npool_to_leafn = 0.0;
    nf->npool_to_leafn_storage = 0.0;
    nf->npool_to_frootn = 0.0;
    nf->npool_to_frootn_storage = 0.0;
    nf->npool_to_livestemn = 0.0;
    nf->npool_to_livestemn_storage = 0.0;
    nf->npool_to_deadstemn = 0.0;
    nf->npool_to_deadstemn_storage = 0.0;
    nf->npool_to_livecrootn = 0.0;
    nf->npool_to_livecrootn_storage = 0.0;
    nf->npool_to_deadcrootn = 0.0;
    nf->npool_to_deadcrootn_storage = 0.0;
    nf->leafn_storage_to_leafn_transfer = 0.0;
    nf->frootn_storage_to_frootn_transfer = 0.0;
    nf->livestemn_storage_to_livestemn_transfer = 0.0;
    nf->deadstemn_storage_to_deadstemn_transfer = 0.0;
    nf->livecrootn_storage_to_livecrootn_transfer = 0.0;
    nf->deadcrootn_storage_to_deadcrootn_transfer = 0.0;
    nf->livestemn_to_deadstemn = 0.0;
    nf->livestemn_to_retransn = 0.0;
    nf->livecrootn_to_deadcrootn = 0.0;
    nf->livecrootn_to_retransn = 0.0;
	
	return (!ok);
}
