This searchable *Browser* shows the C++ class (object) structure of
PISM, the [Parallel Ice Sheet Model](http://www.pism-docs.org/).  It
shows all the classes, inheritance structure, source files,
and class members (variables and methods) in the PISM source code.
It was automatically generated by [doxygen](http://www.doxygen.org/)
from comments in the PISM source code.  It is the source of PISM technical
information, including that needed to extend PISM functionality.

Click on "Classes" above to see the full list of classes in this library.  Some
key classes include:

### The "manager" class

The pism::IceModel class manages time-stepping, I/O, initialization, and
contains parts of the model that were not modularized yet.

Many aspects of PISM's behavior can be modified by writing a new class
derived from pism::IceModel and re-implementing one or more of its methods.

### Major sub-models

See these namespaces and classes, as well as *the ones derived from
these classes*. (This is a summary.)

- pism::stressbalance (stress balance models)
- pism::energy (energy balance models)
- pism::hydrology (sub-glacial hydrology models)
- pism::bed::BedDef (bed deformation models)
- pism::YieldStress, pism::IceBasalResistancePlasticLaw (basal strength)
- pism::calving (calving and "iceberg removal")
- pism::rheology (ice rheology)

#### Climatic inputs

- pism::surface ("surface" models, i.e. melt and snow processes)
- pism::atmosphere ("atmosphere", provides inputs to a pism::surface::SurfaceModel)
- pism::ocean ("ocean" model, provides sub-shelf boundary conditions,
  melange back-pressure, and sea level elevation)

### Infrastructure (utility) classes

- pism::IceGrid (computational grid)
- pism::Component and pism::Component_TS (interface shared by most sub-models)
- pism::IceModelVec2S, pism::IceModelVec2Stag, pism::IceModelVec2V, and pism::IceModelVec3 (storage)
- pism::Timeseries (scalar forcing)
- pism::IceModelVec2T (2D time-dependent forcing)
- pism::VariableMetadata (variable metadata such as physical units)
- pism::Config (configuration parameter database)
- pism::Time (time management, including calendars)
- pism::PIO (file I/O)

### Some important infrastructure concepts and techniques:

- [Organization of PISM's computational grid](@ref computational_grid)
- [pism::IceModelVec and friends: storing, reading, writing, accessing 2D and 3D fields](@ref icemodelvec_use)
- [PISM's model components and their interface](@ref pism_components)
- [Reading scalar time-series (Timeseries)](@ref timeseries_overview)

### Other useful pages

The [Related Pages tab](pages.html) links to some overview pages for
PISM usage and design. You will find
- [list of References](@ref references), and other helpful material.

This doxygen source *Browser* can be regenerated in any source code release.
Just do `"make browser"` in the build directory and look in
`doc/browser/html/` therein.

### Where to go next (other PISM documentation)

- The website [www.pism-docs.org](http://www.pism-docs.org/) is the
  *root* for all PISM information.

- You can *get help,* send comments, or ask for new features by email to
  uaf-pism@alaska.edu.

- To *download* the PISM source code see https://github.com/pism/pism.
  Use of [Git](http://git-scm.com/) to download is strongly
  recommended because, even for the stable branches of the code, bug
  fixes are easy to distribute by `" git pull "`.

- For help *installing* PISM, see the
  [PISM Installation Manual](http://www.pism-docs.org/).

- For help *using* PISM, see the
  [PISM User's Manual](http://www.pism-docs.org/). The *User's Manual*
  should suffice for understanding PISM unless one wants to modify it
  or couple another model to it.

> Copyright (C) 2008-2017 the PISM authors.

> This document is part of PISM. PISM is free software; you can redistribute it
> and/or modify it under the terms of the GNU General Public License as published
> by the Free Software Foundation; either version 3 of the License, or (at your
> option) any later version. PISM is distributed in the hope that it will be
> useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
> MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
> License for more details. You should have received a copy of the GNU General
> Public License along with PISM; see `COPYING` in the PISM source directory; if
> not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
> Boston, MA 02110-1301 USA
