/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.colos.ejs.library.EmersionLink;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.utils.SwingWorker;

public class MoodleConnection
implements EmersionLink {
    private URL moodleURL = null;
    private String moodleCID = null;
    private Component parentComponent = null;
    private Simulation simulation = null;
    private SavePanel savePanel = new SavePanel();
    private ReadPanel readPanel = new ReadPanel();
    private ProgressDialog progressMonitor;
    private LongTask task;
    private Timer timer;
    private int previous;

    public MoodleConnection(JApplet jApplet, Simulation simulation) {
        this.simulation = simulation;
        String string = jApplet.getParameter("MoodleURL");
        try {
            this.moodleURL = new URL(string);
            this.moodleCID = jApplet.getParameter("MoodleCID");
            System.out.println("Connected to Moodle at " + string + "\n");
        }
        catch (MalformedURLException malformedURLException) {
            if (string != null) {
                System.out.println("Malformed URL exception for URL = <" + string + ">");
            }
            this.moodleURL = null;
            this.moodleCID = null;
        }
    }

    public boolean isConnected() {
        return this.moodleURL != null && this.moodleCID != null;
    }

    public void setParentComponent(Component component) {
        this.parentComponent = component;
    }

    public void setNameLabel(String string) {
        this.savePanel.nameLabel.setText(string);
    }

    public void setAnnotationLabel(String string) {
        this.savePanel.annotationLabel.setText(string);
    }

    private void delay(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Delay interrupted!");
        }
    }

    public String saveBinary(String string, String string2, byte[] byArray) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        if (string.length() <= 0) {
            return null;
        }
        string2 = this.savePanel.annotationField.getText();
        this.task = new LongTask(string, string2, byArray);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return string;
    }

    public String saveImage(String string, String string2, Image image) {
        if (!this.isConnected()) {
            return null;
        }
        if (!string.toLowerCase().endsWith(".gif")) {
            string = String.valueOf(string) + ".gif";
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        if (string.length() <= 0) {
            return null;
        }
        string2 = this.savePanel.annotationField.getText();
        if (string.toLowerCase().endsWith(".gif")) {
            string = string.substring(0, string.length() - 4);
        }
        this.task = new LongTask(string, string2, image);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return string;
    }

    public String saveText(String string, String string2, String string3) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        int n = string.lastIndexOf(46);
        string = n > 0 ? String.valueOf(string.substring(0, n)) + "_cid_" + this.moodleCID + string.substring(n) : String.valueOf(string) + "_cid_" + this.moodleCID + ".txt";
        if (string.length() <= 0) {
            return null;
        }
        string2 = this.savePanel.annotationField.getText();
        this.task = new LongTask(string, string2, string3, true);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return string;
    }

    public String saveXML(String string, String string2, String string3) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        if (string.length() <= 0) {
            return null;
        }
        string2 = this.savePanel.annotationField.getText();
        this.task = new LongTask(string, string2, string3, false);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return string;
    }

    public byte[] readBinary(String string) {
        if (!this.isConnected()) {
            return null;
        }
        return null;
    }

    public String readText(String string) {
        if (!this.isConnected()) {
            return null;
        }
        return null;
    }

    public String readXML(String string) {
        if (!this.isConnected()) {
            return null;
        }
        return null;
    }

    public Image readImage(String string) {
        if (!this.isConnected()) {
            return null;
        }
        return null;
    }

    private void httpRequest(String string, String string2, byte[] byArray, Image image) {
        String string3 = "\r\n";
        String string4 = "--";
        String string5 = "***232404jkg4220957934FW**";
        try {
            String string6;
            URLConnection uRLConnection = this.moodleURL.openConnection();
            ((HttpURLConnection)uRLConnection).setRequestMethod("POST");
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            uRLConnection.setRequestProperty("Connection", "Keep-Alive");
            uRLConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + string5);
            DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
            dataOutputStream.writeBytes(String.valueOf(string4) + string5 + string3);
            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"user_file\"; filename=\"" + string + "\"" + string3);
            dataOutputStream.writeBytes(string3);
            if (string2 != null) {
                dataOutputStream.writeUTF(string2);
            }
            if (byArray != null) {
                dataOutputStream.write(byArray);
            }
            if (image != null) {
                dataOutputStream.writeUTF("Image of size: " + image.getWidth(null) + " x " + image.getHeight(null));
            }
            dataOutputStream.writeBytes(string3);
            dataOutputStream.writeBytes(String.valueOf(string4) + string5 + string4 + string3);
            System.out.println("Server response is: \n");
            DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
            while ((string6 = dataInputStream.readLine()) != null) {
                System.out.println(string6);
                System.out.println("");
            }
            dataInputStream.close();
            System.out.println("\nEND Server response  ");
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("CLIENT REQUEST:" + malformedURLException);
        }
        catch (IOException iOException) {
            System.out.println("CLIENT REQUEST:" + iOException);
        }
    }

    private Component getParentComponent() {
        if (this.simulation != null) {
            return this.simulation.getParentComponent();
        }
        return this.parentComponent;
    }

    private void showException(Exception exception) {
        exception.printStackTrace();
        System.out.println("A dialog should appear now");
        JOptionPane.showMessageDialog(this.getParentComponent(), exception.getLocalizedMessage());
    }

    static /* synthetic */ void access$1(MoodleConnection moodleConnection, int n) {
        moodleConnection.delay(n);
    }

    static /* synthetic */ void access$2(MoodleConnection moodleConnection, String string, String string2, byte[] byArray, Image image) {
        moodleConnection.httpRequest(string, string2, byArray, image);
    }

    static /* synthetic */ void access$3(MoodleConnection moodleConnection, Exception exception) {
        moodleConnection.showException(exception);
    }

    private class LongTask {
        private int lengthOfTask;
        private int current = 0;
        private String statMessage;
        private String filename;
        private String annotation;
        private Image image;
        private String txt;
        private byte[] data;
        private boolean isText;
        private String kindFragment;
        private boolean isOk = false;

        LongTask(String string, String string2, Image image) {
            this.kindFragment = "image";
            this.filename = string;
            this.annotation = string2;
            this.image = image;
            this.lengthOfTask = 100;
        }

        LongTask(String string, String string2, String string3, boolean bl) {
            this.kindFragment = "text";
            this.filename = string;
            this.annotation = string2;
            this.txt = string3;
            this.isText = bl;
            this.lengthOfTask = 100;
        }

        LongTask(String string, String string2, byte[] byArray) {
            this.kindFragment = "data";
            this.filename = string;
            this.annotation = string2;
            this.data = byArray;
            this.lengthOfTask = 100;
        }

        void go() {
            this.current = 0;
            new SwingWorker(){

                public Object construct() {
                    if (LongTask.this.kindFragment.equals("image")) {
                        return new ActualTask(LongTask.this, LongTask.this.filename, LongTask.this.annotation, LongTask.this.image);
                    }
                    if (LongTask.this.kindFragment.equals("text")) {
                        return new ActualTask(LongTask.this, LongTask.this.filename, LongTask.this.annotation, LongTask.this.txt, LongTask.this.isText);
                    }
                    return new ActualTask(LongTask.this, LongTask.this.filename, LongTask.this.annotation, LongTask.this.data);
                }
            };
        }

        int getCurrent() {
            return this.current;
        }

        void stop() {
            this.current = this.lengthOfTask;
        }

        boolean getStatus() {
            return this.isOk;
        }

        boolean done() {
            return this.current >= this.lengthOfTask;
        }

        String getMessage() {
            return this.statMessage;
        }

        static /* synthetic */ void access$0(LongTask longTask, int n) {
            longTask.current = n;
        }

        static /* synthetic */ int access$1(LongTask longTask) {
            return longTask.current;
        }

        static /* synthetic */ void access$2(LongTask longTask, String string) {
            longTask.statMessage = string;
        }

        static /* synthetic */ int access$3(LongTask longTask) {
            return longTask.lengthOfTask;
        }

        static /* synthetic */ void access$4(LongTask longTask, boolean bl) {
            longTask.isOk = bl;
        }

        static /* synthetic */ MoodleConnection access$12(LongTask longTask) {
            return longTask.MoodleConnection.this;
        }

        /*
         * Exception performing whole class analysis.
         */
        class ActualTask {
            final /* synthetic */ LongTask this$1;

            /*
             * Unable to fully structure code
             */
            ActualTask(LongTask var1_1, String var2_2, String var3_3, Image var4_4) {
                block5: {
                    this.this$1 = var1_1;
                    super();
                    try {
                        var5_5 = 0;
                        while (var5_5 < 50) {
                            LongTask.access$0(var1_1, var5_5);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 20);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + 100 + "%.");
                            ++var5_5;
                        }
                        MoodleConnection.access$2(LongTask.access$12(var1_1), var2_2, null, null, var4_4);
                        var5_5 = 50;
                        while (var5_5 < 101) {
                            LongTask.access$0(var1_1, var5_5);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 50);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            LongTask.access$4(var1_1, true);
                            ++var5_5;
                        }
                        break block5;
                    }
                    catch (Exception var5_6) {
                        MoodleConnection.access$3(LongTask.access$12(var1_1), var5_6);
                        var6_7 = 50;
                        ** while (var6_7 < 101)
                    }
lbl-1000:
                    // 1 sources

                    {
                        LongTask.access$0(var1_1, var6_7);
                        MoodleConnection.access$1(LongTask.access$12(var1_1), 10);
                        LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                        LongTask.access$4(var1_1, false);
                        ++var6_7;
                        continue;
                    }
                }
            }

            /*
             * Unable to fully structure code
             */
            ActualTask(LongTask var1_1, String var2_2, String var3_3, String var4_4, boolean var5_5) {
                block5: {
                    this.this$1 = var1_1;
                    super();
                    try {
                        var6_6 = 0;
                        while (var6_6 < 50) {
                            LongTask.access$0(var1_1, var6_6);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 20);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            ++var6_6;
                        }
                        MoodleConnection.access$2(LongTask.access$12(var1_1), var2_2, var4_4, null, null);
                        var6_6 = 50;
                        while (var6_6 < 101) {
                            LongTask.access$0(var1_1, var6_6);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 50);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            LongTask.access$4(var1_1, true);
                            ++var6_6;
                        }
                        break block5;
                    }
                    catch (Exception var6_7) {
                        MoodleConnection.access$3(LongTask.access$12(var1_1), var6_7);
                        var7_8 = 50;
                        ** while (var7_8 < 101)
                    }
lbl-1000:
                    // 1 sources

                    {
                        LongTask.access$0(var1_1, var7_8);
                        MoodleConnection.access$1(LongTask.access$12(var1_1), 10);
                        LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                        LongTask.access$4(var1_1, false);
                        ++var7_8;
                        continue;
                    }
                }
            }

            /*
             * Unable to fully structure code
             */
            ActualTask(LongTask var1_1, String var2_2, String var3_3, byte[] var4_4) {
                block5: {
                    this.this$1 = var1_1;
                    super();
                    try {
                        var5_5 = 0;
                        while (var5_5 < 50) {
                            LongTask.access$0(var1_1, var5_5);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 20);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            ++var5_5;
                        }
                        MoodleConnection.access$2(LongTask.access$12(var1_1), var2_2, null, var4_4, null);
                        var5_5 = 50;
                        while (var5_5 < 101) {
                            LongTask.access$0(var1_1, var5_5);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 50);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            LongTask.access$4(var1_1, true);
                            ++var5_5;
                        }
                        break block5;
                    }
                    catch (Exception var5_6) {
                        MoodleConnection.access$3(LongTask.access$12(var1_1), var5_6);
                        var6_7 = 50;
                        ** while (var6_7 < 101)
                    }
lbl-1000:
                    // 1 sources

                    {
                        LongTask.access$0(var1_1, var6_7);
                        MoodleConnection.access$1(LongTask.access$12(var1_1), 10);
                        LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                        LongTask.access$4(var1_1, false);
                        ++var6_7;
                        continue;
                    }
                }
            }
        }
    }

    class ProgressDialog
    extends JDialog {
        private JProgressBar progressBar;
        private JLabel msg;
        private JLabel note;

        public ProgressDialog() {
            super(JOptionPane.getFrameForComponent(MoodleConnection.this.getParentComponent()), "Progress");
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.msg = new JLabel("Monitoring the Delivery");
            this.note = new JLabel("Initializing progress...");
            JPanel jPanel = new JPanel(new GridLayout(3, 0));
            jPanel.add(this.msg);
            jPanel.add(this.note);
            jPanel.add(this.progressBar);
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.setContentPane(jPanel);
            this.setSize(380, 120);
            this.setLocation(300, 300);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ProgressDialog.this.dispose();
                    MoodleConnection.this.progressMonitor.dispose();
                    MoodleConnection.this.progressMonitor = null;
                }
            });
        }

        public void setProgress(int n) {
            this.progressBar.setValue(n);
        }

        public void setNote(String string) {
            this.note.setText(string);
        }

        public void showProgressDialog(boolean bl) {
            this.setVisible(bl);
        }

        public void setBarIndeterminate(boolean bl) {
            this.progressBar.setIndeterminate(bl);
        }

        public void setBarString(String string) {
            this.progressBar.setString(string);
        }
    }

    private class ReadPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        DefaultListModel listModel = new DefaultListModel();
        JList list = new JList(this.listModel);

        ReadPanel() {
            this.list.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.list);
            this.setLayout(new BorderLayout());
            this.add((Component)jScrollPane, "Center");
        }

        String chooseFragment(String string) {
            return null;
        }
    }

    private class SavePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JLabel nameLabel = new JLabel("Name");
        JLabel annotationLabel;
        JTextField nameField;
        JTextField annotationField;

        SavePanel() {
            this.nameLabel.setHorizontalAlignment(0);
            this.nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.nameField = new JTextField();
            this.nameField.setColumns(10);
            this.annotationLabel = new JLabel("Annotation");
            this.annotationLabel.setHorizontalAlignment(0);
            this.annotationLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.annotationField = new JTextField();
            this.annotationField.setColumns(10);
            JPanel jPanel = new JPanel(new GridLayout(0, 1));
            jPanel.add(this.nameLabel);
            jPanel.add(this.annotationLabel);
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
            jPanel2.add(this.nameField);
            jPanel2.add(this.annotationField);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "West");
            this.add((Component)jPanel2, "Center");
        }

        boolean showSaveOptions(String string, String string2) {
            int n;
            if (string != null) {
                this.nameField.setText(string);
            }
            if (string2 != null) {
                this.annotationField.setText(string2);
            }
            return (n = JOptionPane.showConfirmDialog(MoodleConnection.this.getParentComponent(), this, "eMersion", 2)) == 0;
        }
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (MoodleConnection.this.task.done()) {
                if (MoodleConnection.this.task.getStatus()) {
                    MoodleConnection.this.progressMonitor.setProgress(100);
                    MoodleConnection.this.progressMonitor.setNote("Completed 100% out of 100%.");
                    MoodleConnection.this.progressMonitor.setBarString("Successful Delivery... Close this window and refresh eJournal");
                } else {
                    MoodleConnection.this.progressMonitor.setBarString("Sending with problems. Try it again!!!");
                    MoodleConnection.this.progressMonitor.setNote(MoodleConnection.this.task.getMessage());
                }
                MoodleConnection.this.task.stop();
                Toolkit.getDefaultToolkit().beep();
                MoodleConnection.this.timer.stop();
            } else {
                int n = MoodleConnection.this.task.getCurrent();
                if (n == MoodleConnection.this.previous) {
                    MoodleConnection.this.progressMonitor.setBarIndeterminate(true);
                    MoodleConnection.this.progressMonitor.setBarString("Sending Fragment... Please wait");
                } else {
                    MoodleConnection.this.progressMonitor.setBarIndeterminate(false);
                    MoodleConnection.this.progressMonitor.setBarString("Progress");
                }
                MoodleConnection.this.previous = n;
                MoodleConnection.this.progressMonitor.setNote(MoodleConnection.this.task.getMessage());
                MoodleConnection.this.progressMonitor.setProgress(n);
            }
        }
    }
}

