/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawables;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawables.ControlDrawable2D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display2d.BinaryLattice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlBinaryLattice
extends ControlDrawable2D {
    private BinaryLattice lattice;
    private Color[] palette;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private int nx;
    private int ny;
    private static List<String> infoList = null;

    @Override
    protected Drawable createDrawable() {
        this.lattice = new BinaryLattice(30, 30);
        this.lattice.setShowGrid(true);
        this.lattice.setGridLineColor(Color.lightGray);
        this.nx = this.lattice.getNx();
        this.ny = this.lattice.getNy();
        this.minX = -1.0;
        this.maxX = 1.0;
        this.minY = -1.0;
        this.maxY = 1.0;
        this.lattice.setMinMax(-1.0, 1.0, -1.0, 1.0);
        this.lattice.randomize();
        this.palette = new Color[]{Color.black, Color.white};
        this.lattice.setColorPalette(this.palette);
        return this.lattice;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("data");
            infoList.add("deadcolor");
            infoList.add("color");
            infoList.add("showgrid");
            infoList.add("gridcolor");
            infoList.add("visible");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("minimumX")) {
            return "int|double";
        }
        if (string.equals("maximumX")) {
            return "int|double";
        }
        if (string.equals("minimumY")) {
            return "int|double";
        }
        if (string.equals("maximumY")) {
            return "int|double";
        }
        if (string.equals("data")) {
            return "int[][]";
        }
        if (string.equals("color")) {
            return "Color|Object";
        }
        if (string.equals("deadcolor")) {
            return "Color|Object";
        }
        if (string.equals("showgrid")) {
            return "boolean";
        }
        if (string.equals("gridcolor")) {
            return "Color|Object";
        }
        if (string.equals("visible")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getDouble() == this.minX) break;
                this.minX = value.getDouble();
                this.lattice.setMinMax(this.minX, this.maxX, this.minY, this.maxY);
                break;
            }
            case 1: {
                if (value.getDouble() == this.maxX) break;
                this.maxX = value.getDouble();
                this.lattice.setMinMax(this.minX, this.maxX, this.minY, this.maxY);
                break;
            }
            case 2: {
                if (value.getDouble() == this.minY) break;
                this.minY = value.getDouble();
                this.lattice.setMinMax(this.minX, this.maxX, this.minY, this.maxY);
                break;
            }
            case 3: {
                if (value.getDouble() == this.maxY) break;
                this.maxY = value.getDouble();
                this.lattice.setMinMax(this.minX, this.maxX, this.minY, this.maxY);
                break;
            }
            case 4: {
                if (!(value.getObject() instanceof int[][])) break;
                int[][] nArray = (int[][])value.getObject();
                if (nArray.length != this.nx || nArray[0].length != this.ny) {
                    this.nx = nArray.length;
                    this.ny = nArray[0].length;
                    this.lattice.resizeLattice(this.nx, this.ny);
                }
                this.lattice.setBlock(0, 0, nArray);
                break;
            }
            case 5: {
                if (!(value.getObject() instanceof Color) || this.palette[0] == (Color)value.getObject()) break;
                this.palette[0] = (Color)value.getObject();
                this.lattice.setColorPalette(this.palette);
                break;
            }
            case 6: {
                if (!(value.getObject() instanceof Color) || this.palette[1] == (Color)value.getObject()) break;
                this.palette[1] = (Color)value.getObject();
                this.lattice.setColorPalette(this.palette);
                break;
            }
            case 7: {
                this.lattice.setShowGrid(value.getBoolean());
                break;
            }
            case 8: {
                if (!(value.getObject() instanceof Color)) break;
                this.lattice.setGridLineColor((Color)value.getObject());
                break;
            }
            case 9: {
                this.lattice.setVisible(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 10, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.minX = -1.0;
                this.lattice.setXMin(-1.0);
                break;
            }
            case 1: {
                this.maxX = 1.0;
                this.lattice.setXMax(1.0);
                break;
            }
            case 2: {
                this.minY = -1.0;
                this.lattice.setYMin(-1.0);
                break;
            }
            case 3: {
                this.maxY = 1.0;
                this.lattice.setYMax(1.0);
                break;
            }
            case 4: {
                this.lattice.randomize();
                break;
            }
            case 5: {
                this.palette[0] = Color.black;
                this.lattice.setColorPalette(this.palette);
                break;
            }
            case 6: {
                this.palette[1] = Color.white;
                this.lattice.setColorPalette(this.palette);
                break;
            }
            case 7: {
                this.lattice.setShowGrid(true);
                break;
            }
            case 8: {
                this.lattice.setGridLineColor(Color.lightGray);
                break;
            }
            case 9: {
                this.lattice.setVisible(true);
                break;
            }
            default: {
                super.setDefaultValue(n - 10);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "-1";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "-1";
            }
            case 3: {
                return "1";
            }
            case 4: {
                return "<none>";
            }
            case 5: {
                return "BLACK";
            }
            case 6: {
                return "WHITE";
            }
            case 7: {
                return "true";
            }
            case 8: {
                return "LIGHTGRAY";
            }
            case 9: {
                return "true";
            }
        }
        return super.getDefaultValueString(n - 10);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return null;
            }
        }
        return super.getValue(n - 10);
    }
}

