/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawables;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawables.ControlDrawable2D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display2d.CellLattice;
import org.opensourcephysics.display2d.ColorMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlCellLattice
extends ControlDrawable2D {
    private CellLattice lattice;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private int nx;
    private int ny;
    private int numColors;
    private int paletteType;
    private Color[] palette = new Color[1];
    private static List<String> infoList = null;

    @Override
    protected Drawable createDrawable() {
        this.lattice = new CellLattice(30, 30);
        this.lattice.setShowGridLines(true);
        this.lattice.setGridLineColor(Color.lightGray);
        this.nx = this.lattice.getNx();
        this.ny = this.lattice.getNy();
        this.minX = -1.0;
        this.maxX = 1.0;
        this.minY = -1.0;
        this.maxY = 1.0;
        this.lattice.setMinMax(-1.0, 1.0, -1.0, 1.0);
        this.lattice.randomize();
        this.numColors = 256;
        this.paletteType = 0;
        this.setColorMode(256, 0);
        return this.lattice;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("data");
            infoList.add("numcolors");
            infoList.add("colormode");
            infoList.add("showgrid");
            infoList.add("gridcolor");
            infoList.add("visible");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("minimumX")) {
            return "int|double";
        }
        if (string.equals("maximumX")) {
            return "int|double";
        }
        if (string.equals("minimumY")) {
            return "int|double";
        }
        if (string.equals("maximumY")) {
            return "int|double";
        }
        if (string.equals("data")) {
            return "int[][]";
        }
        if (string.equals("numcolors")) {
            return "int";
        }
        if (string.equals("colormode")) {
            return "int|ColorMode|Object[]";
        }
        if (string.equals("showgrid")) {
            return "boolean";
        }
        if (string.equals("gridcolor")) {
            return "Color|Object";
        }
        if (string.equals("visible")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getDouble() == this.minX) break;
                this.minX = value.getDouble();
                this.lattice.setMinMax(this.minX, this.maxX, this.minY, this.maxY);
                break;
            }
            case 1: {
                if (value.getDouble() == this.maxX) break;
                this.maxX = value.getDouble();
                this.lattice.setMinMax(this.minX, this.maxX, this.minY, this.maxY);
                break;
            }
            case 2: {
                if (value.getDouble() == this.minY) break;
                this.minY = value.getDouble();
                this.lattice.setMinMax(this.minX, this.maxX, this.minY, this.maxY);
                break;
            }
            case 3: {
                if (value.getDouble() == this.maxY) break;
                this.maxY = value.getDouble();
                this.lattice.setMinMax(this.minX, this.maxX, this.minY, this.maxY);
                break;
            }
            case 4: {
                if (!(value.getObject() instanceof int[][])) break;
                int[][] nArray = (int[][])value.getObject();
                if (nArray.length != this.nx || nArray[0].length != this.ny) {
                    this.nx = nArray.length;
                    this.ny = nArray[0].length;
                    this.lattice.resizeLattice(this.nx, this.ny);
                }
                this.lattice.setBlock(0, 0, nArray);
                break;
            }
            case 5: {
                if (this.numColors == value.getInteger()) break;
                this.numColors = value.getInteger();
                this.setColorMode(this.numColors, this.paletteType);
                break;
            }
            case 6: {
                if (value.getObject() instanceof Object[]) {
                    this.paletteType = -1;
                    Object[] objectArray = (Object[])value.getObject();
                    if (objectArray.length != this.palette.length) {
                        this.palette = new Color[objectArray.length];
                    }
                    boolean bl = false;
                    int n2 = 0;
                    int n3 = this.palette.length;
                    while (n2 < n3) {
                        if (this.palette[n2] != (Color)objectArray[n2]) {
                            this.palette[n2] = (Color)objectArray[n2];
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl) break;
                    this.lattice.setColorPalette(this.palette);
                    break;
                }
                if (this.paletteType == value.getInteger()) break;
                this.paletteType = value.getInteger();
                this.setColorMode(this.numColors, this.paletteType);
                break;
            }
            case 7: {
                this.lattice.setShowGridLines(value.getBoolean());
                break;
            }
            case 8: {
                if (!(value.getObject() instanceof Color)) break;
                this.lattice.setGridLineColor((Color)value.getObject());
                break;
            }
            case 9: {
                this.lattice.setVisible(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 10, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.minX = -1.0;
                this.lattice.setXMin(-1.0);
                break;
            }
            case 1: {
                this.maxX = 1.0;
                this.lattice.setXMax(1.0);
                break;
            }
            case 2: {
                this.minY = -1.0;
                this.lattice.setYMin(-1.0);
                break;
            }
            case 3: {
                this.maxY = 1.0;
                this.lattice.setYMax(1.0);
                break;
            }
            case 4: {
                this.lattice.randomize();
                break;
            }
            case 5: {
                this.numColors = 256;
                this.setColorMode(256, this.paletteType);
                break;
            }
            case 6: {
                this.paletteType = 0;
                this.setColorMode(this.numColors, 0);
                break;
            }
            case 7: {
                this.lattice.setShowGridLines(true);
                break;
            }
            case 8: {
                this.lattice.setGridLineColor(Color.lightGray);
                break;
            }
            case 9: {
                this.lattice.setVisible(true);
                break;
            }
            default: {
                super.setDefaultValue(n - 10);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "-1";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "-1";
            }
            case 3: {
                return "1";
            }
            case 4: {
                return "<none>";
            }
            case 5: {
                return "256";
            }
            case 6: {
                return "SPECTRUM";
            }
            case 7: {
                return "true";
            }
            case 8: {
                return "LIGHTGRAY";
            }
            case 9: {
                return "true";
            }
        }
        return super.getDefaultValueString(n - 10);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return null;
            }
        }
        return super.getValue(n - 8);
    }

    protected void setColorMode(int n, int n2) {
        Color[] colorArray;
        if (this.paletteType < 0) {
            return;
        }
        if (n > 256) {
            n = 256;
        }
        if ((colorArray = ColorMapper.getColorPalette(n, n2)) == null) {
            this.lattice.createDefaultColors();
        } else {
            colorArray[0] = new Color(0, 0, 0, 0);
            this.lattice.setColorPalette(colorArray);
        }
    }
}

