/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawables;

import java.awt.Color;
import java.util.ArrayList;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.DataCollector;
import org.colos.ejs.library.control.Resetable;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.Histogram;
import org.opensourcephysics.tools.ToolForData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlHistogram
extends ControlDrawable
implements NeedsPreUpdate,
Resetable,
DataCollector {
    private static final int HISTOGRAM_ADDED = 14;
    private Histogram histogram;
    protected double x;
    protected double[] xArray;
    protected boolean enabled;
    protected boolean clearAtInput;
    protected int occurences;
    protected Color lineColor;
    protected Color fillColor;
    protected int isSet = -1;
    protected String inputLabel = "x";
    protected String occurrencesLabel = "occurrences";
    private static ArrayList<String> infoList = null;

    @Override
    protected Drawable createDrawable() {
        this.x = 0.0;
        this.lineColor = Color.BLACK;
        this.fillColor = Color.BLUE;
        this.occurences = 1;
        this.enabled = true;
        this.clearAtInput = false;
        this.histogram = new Histogram();
        this.histogram.setBinColor(this.fillColor, this.lineColor);
        return this.histogram;
    }

    @Override
    protected void setName(String string) {
        this.histogram.setName(string);
    }

    @Override
    public void initialize() {
        this.histogram.clear();
    }

    @Override
    public void reset() {
        this.histogram.clear();
    }

    @Override
    public void onExit() {
        this.histogram.clear();
    }

    @Override
    public void preupdate() {
        if (!this.enabled) {
            return;
        }
        switch (this.isSet) {
            case 0: {
                if (this.clearAtInput) {
                    this.histogram.clear();
                }
                this.histogram.append(this.x, this.occurences);
                break;
            }
            case 1: {
                if (this.clearAtInput) {
                    this.histogram.clear();
                }
                this.histogram.append(this.xArray);
            }
        }
        this.isSet = -1;
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null || !ToolForData.getTool().isFullTool()) {
            return;
        }
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), ControlHistogram.getDataInformationMenuEntries(this.getParent().getDrawingPanel(), this.histogram));
    }

    @Override
    public ControlElement setProperty(String string, String string2) {
        if ((string = string.trim()).equals("input")) {
            this.inputLabel = string2;
            this.histogram.setXYColumnNames(this.inputLabel, this.occurrencesLabel);
        } else if (string.equals("occurrences")) {
            this.occurrencesLabel = string2;
            this.histogram.setXYColumnNames(this.inputLabel, this.occurrencesLabel);
        }
        return super.setProperty(string, string2);
    }

    public ArrayList<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("input");
            infoList.add("occurences");
            infoList.add("barOffset");
            infoList.add("lineColor");
            infoList.add("fillColor");
            infoList.add("binOffset");
            infoList.add("binStyle");
            infoList.add("binWidth");
            infoList.add("discrete");
            infoList.add("normalized");
            infoList.add("enabled");
            infoList.add("clearAtInput");
            infoList.add("visible");
            infoList.add("measured");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("input")) {
            return "int|double|double[]";
        }
        if (string.equals("occurences")) {
            return "int|double";
        }
        if (string.equals("barOffset")) {
            return "int|double";
        }
        if (string.equals("lineColor")) {
            return "int|Color|Object";
        }
        if (string.equals("fillColor")) {
            return "int|Color|Object";
        }
        if (string.equals("binOffset")) {
            return "int|double";
        }
        if (string.equals("binStyle")) {
            return "BinStyle|int";
        }
        if (string.equals("binWidth")) {
            return "int|double";
        }
        if (string.equals("discrete")) {
            return "boolean";
        }
        if (string.equals("normalized")) {
            return "boolean";
        }
        if (string.equals("enabled")) {
            return "boolean";
        }
        if (string.equals("clearAtInput")) {
            return "boolean";
        }
        if (string.equals("visible")) {
            return "boolean";
        }
        if (string.equals("measured")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("BinStyle") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("point")) {
                return new IntegerValue(0);
            }
            if (string2.equals("bin")) {
                return new IntegerValue(1);
            }
        }
        return super.parseConstant(string, string2);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof double[]) {
                    this.xArray = (double[])value.getObject();
                    this.isSet = 1;
                    break;
                }
                this.x = value.getDouble();
                this.isSet = 0;
                break;
            }
            case 1: {
                this.occurences = value.getInteger();
                break;
            }
            case 2: {
                this.histogram.setBarOffset(value.getDouble());
                break;
            }
            case 3: {
                if (value.getObject() instanceof Color) {
                    this.lineColor = (Color)value.getObject();
                    this.histogram.setBinColor(this.fillColor, this.lineColor);
                    break;
                }
                this.lineColor = DisplayColors.getLineColor(value.getInteger());
                this.histogram.setBinColor(this.fillColor, this.lineColor);
                break;
            }
            case 4: {
                if (value.getObject() instanceof Color) {
                    this.fillColor = (Color)value.getObject();
                    this.histogram.setBinColor(this.fillColor, this.lineColor);
                    break;
                }
                this.fillColor = DisplayColors.getLineColor(value.getInteger());
                this.histogram.setBinColor(this.fillColor, this.lineColor);
                break;
            }
            case 5: {
                this.histogram.setBinOffset(value.getDouble());
                break;
            }
            case 6: {
                this.histogram.setBinStyle((short)value.getInteger());
                break;
            }
            case 7: {
                this.histogram.setBinWidth(value.getDouble());
                break;
            }
            case 8: {
                this.histogram.setDiscrete(value.getBoolean());
                break;
            }
            case 9: {
                this.histogram.setNormalizedToOne(value.getBoolean());
                break;
            }
            case 10: {
                this.enabled = value.getBoolean();
                break;
            }
            case 11: {
                this.clearAtInput = value.getBoolean();
                break;
            }
            case 12: {
                this.histogram.setVisible(value.getBoolean());
                break;
            }
            case 13: {
                this.histogram.setMeasured(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 14, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.x = 0.0;
                this.isSet = -1;
                break;
            }
            case 1: {
                this.occurences = 1;
                break;
            }
            case 2: {
                this.histogram.setBarOffset(0.0);
                break;
            }
            case 3: {
                this.lineColor = Color.BLACK;
                this.histogram.setBinColor(this.fillColor, this.lineColor);
                break;
            }
            case 4: {
                this.fillColor = Color.BLUE;
                this.histogram.setBinColor(this.fillColor, this.lineColor);
                break;
            }
            case 5: {
                this.histogram.setBinOffset(0.0);
                break;
            }
            case 6: {
                this.histogram.setBinStyle(1);
                break;
            }
            case 7: {
                this.histogram.setBinWidth(1.0);
                break;
            }
            case 8: {
                this.histogram.setDiscrete(true);
                break;
            }
            case 9: {
                this.histogram.setNormalizedToOne(false);
                break;
            }
            case 10: {
                this.enabled = true;
                break;
            }
            case 11: {
                this.clearAtInput = false;
                break;
            }
            case 12: {
                this.histogram.setVisible(true);
                break;
            }
            case 13: {
                this.histogram.setMeasured(true);
                break;
            }
            default: {
                super.setDefaultValue(n - 14);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "0";
            }
            case 3: {
                return "BLACK";
            }
            case 4: {
                return "BLUE";
            }
            case 5: {
                return "0";
            }
            case 6: {
                return "BIN";
            }
            case 7: {
                return "1";
            }
            case 8: {
                return "true";
            }
            case 9: {
                return "false";
            }
            case 10: {
                return "true";
            }
            case 11: {
                return "false";
            }
            case 12: {
                return "true";
            }
            case 13: {
                return "true";
            }
        }
        return super.getDefaultValueString(n - 14);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return null;
            }
        }
        return super.getValue(n - 14);
    }
}

