/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPropertyElement
implements XMLProperty {
    protected XMLProperty parent;
    protected String name;
    protected String type;
    protected String className;
    protected List<Object> content;

    public XMLPropertyElement(XMLProperty xMLProperty) {
        this.content = new ArrayList<Object>();
        this.parent = xMLProperty;
    }

    public XMLPropertyElement(XMLProperty xMLProperty, String string, String string2, Object object) {
        block9: {
            boolean bl;
            block12: {
                block11: {
                    block10: {
                        block8: {
                            this(xMLProperty);
                            this.name = string;
                            this.type = string2;
                            if (!this.type.equals("string")) break block8;
                            if (XML.requiresCDATA((String)object)) {
                                this.content.add("<![CDATA[" + object + "]]>");
                            } else {
                                this.content.add(object.toString());
                            }
                            break block9;
                        }
                        if ("intdoubleboolean".indexOf(this.type) == -1) break block10;
                        this.content.add(object.toString());
                        break block9;
                    }
                    if (!this.type.equals("object")) break block11;
                    this.className = object.getClass().getName();
                    XMLControlElement xMLControlElement = new XMLControlElement(this);
                    xMLControlElement.saveObject(object);
                    this.content.add(xMLControlElement);
                    break block9;
                }
                if (!this.type.equals("collection")) break block12;
                this.className = object.getClass().getName();
                for (Object e : (Collection)object) {
                    String string3 = XML.getDataType(e);
                    if (string3 == null) continue;
                    this.content.add(new XMLPropertyElement(this, "item", string3, e));
                }
                break block9;
            }
            if (!this.type.equals("array")) break block9;
            this.className = object.getClass().getName();
            Class<?> clazz = object.getClass().getComponentType();
            Object object2 = object;
            int n = Array.getLength(object2);
            while (n > 0 && clazz.getComponentType() != null) {
                clazz = clazz.getComponentType();
                if ((object2 = Array.get(object2, 0)) == null) break;
                n *= Array.getLength(object2);
            }
            boolean bl2 = bl = "intdoubleboolean".indexOf(clazz.getName()) != -1;
            if (bl && n > XMLControlElement.compactArraySize) {
                String string4 = this.getArrayString(object);
                this.content.add(new XMLPropertyElement(this, "array", "string", string4));
            } else {
                int n2 = Array.getLength(object);
                int n3 = 0;
                while (n3 < n2) {
                    Object object3 = Array.get(object, n3);
                    String string5 = XML.getDataType(object3);
                    if (string5 != null) {
                        this.content.add(new XMLPropertyElement(this, "[" + n3 + "]", string5, object3));
                    }
                    ++n3;
                }
            }
        }
    }

    @Override
    public String getPropertyName() {
        return this.name;
    }

    @Override
    public String getPropertyType() {
        return this.type;
    }

    @Override
    public Class<?> getPropertyClass() {
        if (this.type.equals("int")) {
            return Integer.TYPE;
        }
        if (this.type.equals("double")) {
            return Double.TYPE;
        }
        if (this.type.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (this.type.equals("string")) {
            return String.class;
        }
        try {
            return Class.forName(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public XMLProperty getParentProperty() {
        return this.parent;
    }

    @Override
    public int getLevel() {
        return this.parent.getLevel() + 1;
    }

    @Override
    public List<Object> getPropertyContent() {
        return this.content;
    }

    @Override
    public XMLControl getChildControl(String string) {
        XMLControl[] xMLControlArray = this.getChildControls();
        int n = 0;
        while (n < xMLControlArray.length) {
            if (xMLControlArray[n].getPropertyName().equals(string)) {
                return xMLControlArray[n];
            }
            ++n;
        }
        return null;
    }

    @Override
    public XMLControl[] getChildControls() {
        if (this.type.equals("object")) {
            XMLControl xMLControl = (XMLControl)this.getPropertyContent().get(0);
            return new XMLControl[]{xMLControl};
        }
        if ("arraycollection".indexOf(this.type) != -1) {
            ArrayList<XMLControl> arrayList = new ArrayList<XMLControl>();
            for (XMLProperty xMLProperty : this.getPropertyContent()) {
                if (!xMLProperty.getPropertyType().equals("object")) continue;
                arrayList.add((XMLControl)xMLProperty.getPropertyContent().get(0));
            }
            return arrayList.toArray(new XMLControl[0]);
        }
        return new XMLControl[0];
    }

    @Override
    public void setValue(String string) {
        boolean bl = true;
        try {
            if (this.type.equals("int")) {
                Integer.parseInt(string);
            } else if (this.type.equals("double")) {
                Double.parseDouble(string);
            } else if (this.type.equals("boolean")) {
                string = string.equals("true") ? "true" : "false";
            } else if ("objectarraycollection".indexOf(this.type) != -1) {
                bl = false;
            } else if (this.type.equals("string") && XML.requiresCDATA(string)) {
                string = "<![CDATA[" + string + "]]>";
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (bl) {
            this.content.clear();
            this.content.add(string);
        }
    }

    public String toString() {
        List<Object> list;
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(XML.NEW_LINE) + this.indent(this.getLevel()) + "<property name=\"" + this.name + "\" type=\"" + this.type + "\"");
        if ("arraycollection".indexOf(this.type) != -1) {
            stringBuffer.append(" class=\"" + this.className + "\"");
        }
        if ((list = this.getPropertyContent()).isEmpty()) {
            stringBuffer.append("/>");
            return stringBuffer.toString();
        }
        stringBuffer.append(">");
        boolean bl = false;
        for (Object object : list) {
            bl = bl || object instanceof XMLProperty;
            stringBuffer.append(object);
        }
        if (bl) {
            stringBuffer.append(String.valueOf(XML.NEW_LINE) + this.indent(this.getLevel()));
        }
        stringBuffer.append("</property>");
        return stringBuffer.toString();
    }

    protected String indent(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < 4 * n) {
            string = String.valueOf(string) + " ";
            ++n2;
        }
        return string;
    }

    protected String getArrayString(Object object) {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = Array.getLength(object);
        int n2 = 0;
        while (n2 < n) {
            Object object2;
            if (n2 > 0) {
                stringBuffer.append(',');
            }
            if ((object2 = Array.get(object, n2)) != null && object2.getClass().isArray()) {
                stringBuffer.append(this.getArrayString(object2));
            } else {
                stringBuffer.append(object2);
            }
            ++n2;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

