/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.HistogramDataset;
import org.opensourcephysics.display.LogMeasurable;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.TeXParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Histogram
extends AbstractTableModel
implements Measurable,
LogMeasurable,
Data {
    HistogramDataset histogramDataset;
    public static final int DRAW_POINT = 0;
    public static final int DRAW_BIN = 1;
    public boolean logScale = false;
    public boolean adjustForWidth = false;
    private boolean visible = true;
    private boolean measured = true;
    protected Color binFillColor = Color.red;
    protected Color binEdgeColor = Color.red;
    protected int binStyle = 1;
    HashMap<Integer, Double> bins;
    double binWidth = 1.0;
    double binOffset = 0.0;
    boolean discrete = true;
    double xmin;
    double xmax;
    final int YMIN = 0;
    double ymax;
    String name;
    String binColumnName;
    String xColumnName = "x";
    String yColumnName;
    Map.Entry<?, ?>[] entries = new Map.Entry[0];
    boolean dataChanged;
    double sum;
    boolean normalizedToOne = false;
    double barOffset;
    protected int datasetID = this.hashCode();

    public Histogram() {
        this.binColumnName = DisplayRes.getString("Histogram.Column.BinNumber");
        this.yColumnName = DisplayRes.getString("Histogram.Column.Occurrences");
        this.name = DisplayRes.getString("Histogram.Title");
        this.clear();
    }

    public void read(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).equals("") || string2.length() == 0 || string2.charAt(0) == '#') continue;
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
                int n = Integer.parseInt(stringTokenizer.nextToken());
                double d = Double.parseDouble(stringTokenizer.nextToken());
                Double d2 = this.bins.get(new Integer(n));
                if (d2 == null) {
                    this.bins.put(new Integer(n), new Double(d));
                } else {
                    this.bins.put(new Integer(n), new Double(d += d2.doubleValue()));
                }
                this.ymax = Math.max(d, this.ymax);
                this.xmin = Math.min((double)n * this.binWidth + this.binOffset, this.xmin);
                this.xmax = Math.max((double)n * this.binWidth + this.binWidth + this.binOffset, this.xmax);
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        this.dataChanged = true;
    }

    public String toSortedString() {
        Set<Integer> set = this.bins.keySet();
        Object[] objectArray = set.toArray();
        Arrays.sort(objectArray);
        String string = "x\tx";
        StringBuffer stringBuffer = new StringBuffer(string.length() * objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            stringBuffer.append(object);
            stringBuffer.append("\t");
            stringBuffer.append(this.bins.get(objectArray[n]));
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        Set<Integer> set = this.bins.keySet();
        Iterator<Integer> iterator = set.iterator();
        String string = "x\tx";
        StringBuffer stringBuffer = new StringBuffer(string.length() * set.size());
        while (iterator.hasNext()) {
            Integer n = iterator.next();
            Double d = this.bins.get(n);
            stringBuffer.append(n);
            stringBuffer.append("\t");
            stringBuffer.append(d);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int hashCode(double d) {
        return (int)Math.floor((d - this.binOffset) / this.binWidth);
    }

    public synchronized void append(double d, double d2) {
        this.sum += d2;
        int n = this.hashCode(d);
        Double d3 = this.bins.get(new Integer(n));
        if (d3 == null) {
            this.bins.put(new Integer(n), new Double(d2));
        } else {
            this.bins.put(new Integer(n), new Double(d2 += d3.doubleValue()));
        }
        this.ymax = Math.max(d2, this.ymax);
        this.xmin = Math.min((double)n * this.binWidth + this.binOffset, this.xmin);
        this.xmax = Math.max((double)n * this.binWidth + this.binWidth + this.binOffset, this.xmax);
        this.dataChanged = true;
    }

    public void append(double d) {
        this.append(d, 1.0);
    }

    public void append(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).equals("") || string2.length() == 0 || string2.charAt(0) == '#') continue;
            try {
                double d = Double.parseDouble(string2);
                this.append(d, 1.0);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
    }

    public void append(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            this.append(dArray[n], 1.0);
            ++n;
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public synchronized void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.bins.size() == 0 || !this.visible) {
            return;
        }
        Shape shape = graphics.getClip();
        graphics.setColor(this.binFillColor);
        graphics.clipRect(0, 0, drawingPanel.getWidth(), drawingPanel.getHeight());
        for (Integer n : this.bins.keySet()) {
            Double d = this.bins.get(n);
            if (d == null) {
                return;
            }
            double d2 = d;
            if (this.normalizedToOne) {
                d2 /= this.sum;
            }
            if (this.binStyle == 1) {
                this.drawBin(drawingPanel, graphics, n, d2);
                continue;
            }
            this.drawPoint(drawingPanel, graphics, n, d2);
        }
        graphics.setClip(shape);
    }

    public synchronized void clear() {
        this.bins = new HashMap();
        this.xmin = 2.147483647E9;
        this.xmax = -2.147483648E9;
        this.ymax = -2.147483648E9;
        this.sum = 0.0;
        this.dataChanged = true;
    }

    public Map.Entry<?, ?>[] entries() {
        this.updateEntries();
        return this.entries;
    }

    public void setBinStyle(int n) {
        this.binStyle = n;
    }

    public void setDiscrete(boolean bl) {
        this.discrete = bl;
    }

    public void setBinOffset(double d) {
        this.binOffset = d;
    }

    public void setBarOffset(double d) {
        this.barOffset = d;
    }

    public Color getLineColor() {
        return this.binEdgeColor;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{this.binEdgeColor, this.binEdgeColor};
    }

    public Color getFillColor() {
        return this.binFillColor;
    }

    @Override
    public Color[] getFillColors() {
        return new Color[]{this.binFillColor, this.binFillColor};
    }

    public void setBinColor(Color color) {
        this.binFillColor = color;
        this.binEdgeColor = color;
    }

    public void setBinColor(Color color, Color color2) {
        this.binFillColor = color;
        this.binEdgeColor = color2;
    }

    public void setBinWidth(double d) {
        this.binWidth = d;
    }

    public void setName(String string) {
        this.name = TeXParser.parseTeX(string);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{this.xColumnName, this.yColumnName};
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    public void setXYColumnNames(String string, String string2) {
        this.xColumnName = TeXParser.parseTeX(string);
        this.yColumnName = TeXParser.parseTeX(string2);
    }

    public void setXYColumnNames(String string, String string2, String string3) {
        this.xColumnName = TeXParser.parseTeX(string);
        this.yColumnName = TeXParser.parseTeX(string2);
        this.name = TeXParser.parseTeX(string3);
    }

    public void setNormalizedToOne(boolean bl) {
        this.normalizedToOne = bl;
    }

    public double getBinWidth() {
        return this.binWidth;
    }

    public double getBinOffset() {
        return this.binOffset;
    }

    @Override
    public double getXMin() {
        return this.discrete && this.bins.size() > 1 ? this.xmin - this.binWidth : this.xmin;
    }

    @Override
    public double getXMax() {
        return this.xmax;
    }

    @Override
    public double getYMin() {
        return 0.0;
    }

    @Override
    public double getYMax() {
        double d;
        double d2 = d = this.normalizedToOne ? this.ymax / this.sum : this.ymax;
        if (this.adjustForWidth) {
            d /= this.getBinWidth();
        }
        if (this.logScale) {
            d = Math.log(d);
        }
        return d;
    }

    @Override
    public double getXMinLogscale() {
        double d = this.getXMin();
        if (d > 0.0) {
            return d;
        }
        return this.binOffset;
    }

    @Override
    public double getXMaxLogscale() {
        double d = this.getXMax();
        if (d > 0.0) {
            return d;
        }
        return this.binOffset + 10.0;
    }

    @Override
    public double getYMinLogscale() {
        return 1.0;
    }

    @Override
    public double getYMaxLogscale() {
        return Math.max(10.0, this.getYMax());
    }

    @Override
    public boolean isMeasured() {
        return this.bins.size() > 0 && this.measured;
    }

    public void setMeasured(boolean bl) {
        this.measured = bl;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return this.binColumnName;
        }
        if (n == 1) {
            return this.xColumnName;
        }
        return this.yColumnName;
    }

    @Override
    public int getRowCount() {
        return this.bins.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        this.updateEntries();
        Map.Entry<?, ?> entry = this.entries[n];
        if (n2 == 0) {
            return entry.getKey();
        }
        if (n2 == 1) {
            return new Double(((Integer)entry.getKey()).doubleValue() * this.binWidth + this.binWidth / 2.0 + this.binOffset);
        }
        if (this.normalizedToOne) {
            Double d = (Double)entry.getValue();
            return new Double(d / this.sum);
        }
        return entry.getValue();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n == 0 ? Integer.class : Double.class;
    }

    @Override
    public void setID(int n) {
        this.datasetID = n;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    protected void drawPoint(DrawingPanel drawingPanel, Graphics graphics, int n, double d) {
        int n2 = drawingPanel.xToPix(this.getLeftMostBinPosition(n));
        int n3 = drawingPanel.yToPix(d);
        int n4 = 2;
        if (this.discrete) {
            graphics.fillRect(n2 - n4, n3 - n4, n4 * 2, n4 * 2);
        } else {
            int n5 = drawingPanel.xToPix(this.getRightMostBinPosition(n));
            int n6 = n5 - n2;
            graphics.fillRect(n2, n3, n6, n4 * 2);
        }
    }

    protected void drawBin(DrawingPanel drawingPanel, Graphics graphics, int n, double d) {
        if (this.adjustForWidth) {
            d /= this.getBinWidth();
        }
        if (this.logScale) {
            d = Math.max(0.0, Math.log(d));
        }
        int n2 = drawingPanel.xToPix(this.getLeftMostBinPosition(n));
        if (this.discrete) {
            if (this.binEdgeColor != null) {
                graphics.setColor(this.binEdgeColor);
                graphics.drawLine(n2, drawingPanel.yToPix(0.0), n2, drawingPanel.yToPix(d));
            }
        } else {
            int n3 = drawingPanel.xToPix(this.getRightMostBinPosition(n));
            int n4 = n3 - n2;
            double d2 = drawingPanel.getYPixPerUnit() * d;
            Rectangle2D.Double double_ = new Rectangle2D.Double(n2, drawingPanel.yToPix(d), n4, d2);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.binFillColor != null) {
                graphics.setColor(this.binFillColor);
                graphics2D.fill(double_);
            }
            if (this.binEdgeColor != null) {
                graphics.setColor(this.binEdgeColor);
                graphics2D.draw(double_);
            }
        }
    }

    public double[] getXPoints() {
        int n = 1 + (int)((this.xmax - this.xmin) / this.binWidth);
        if (n < 1) {
            return new double[0];
        }
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.xmin + (double)n2 * this.binWidth + this.binOffset + this.binWidth / 2.0;
            ++n2;
        }
        return dArray;
    }

    public double[] getYPoints() {
        int n = 1 + (int)((this.xmax - this.xmin) / this.binWidth);
        if (n < 1) {
            return new double[0];
        }
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = new Integer(n2);
            Double d = this.bins.get(n3);
            dArray[n2] = d == null ? 0.0 : d;
            ++n2;
        }
        return dArray;
    }

    public double[][] getPoints() {
        int n = 1 + (int)((this.xmax - this.xmin) / this.binWidth);
        if (n < 1) {
            return new double[2][0];
        }
        double[][] dArray = new double[2][n];
        int n2 = (int)(this.xmin / this.binWidth);
        int n3 = 0;
        while (n3 < n) {
            Integer n4 = new Integer(n3 + n2);
            Double d = this.bins.get(n4);
            dArray[0][n3] = this.xmin + (double)n3 * this.binWidth + this.binOffset + this.binWidth / 2.0;
            dArray[1][n3] = d == null ? 0.0 : d;
            ++n3;
        }
        return dArray;
    }

    public double[][] getLogPoints() {
        int n = (int)Math.round((this.xmax - this.xmin) / this.binWidth);
        if (n < 1) {
            return new double[2][0];
        }
        double[][] dArray = new double[2][n];
        int n2 = (int)(this.xmin / this.binWidth);
        int n3 = 0;
        while (n3 < n) {
            Integer n4 = new Integer(n3 + n2);
            Double d = this.bins.get(n4);
            dArray[0][n3] = this.xmin + (double)n3 * this.binWidth + this.binOffset + this.binWidth / 2.0;
            dArray[1][n3] = d == null ? 0.0 : d;
            dArray[1][n3] = dArray[1][n3] > 0.0 ? Math.log(dArray[1][n3]) : 0.0;
            ++n3;
        }
        return dArray;
    }

    public double getLeftMostBinPosition(int n) {
        return (double)n * this.binWidth + this.binOffset + this.binWidth * this.barOffset;
    }

    public double getRightMostBinPosition(int n) {
        return (double)n * this.binWidth + this.binWidth + this.binOffset + this.binWidth * this.barOffset;
    }

    private synchronized void updateEntries() {
        if (this.dataChanged) {
            this.entries = this.bins.entrySet().toArray(this.entries);
            this.dataChanged = false;
        }
    }

    @Override
    public double[][] getData2D() {
        double[][] dArray = this.logScale ? this.getLogPoints() : this.getPoints();
        return dArray;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        double[][] dArray = this.logScale ? this.getLogPoints() : this.getPoints();
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        double d = 0.0;
        double d2 = this.getBinWidth();
        if (dArray2 != null && dArray2.length > 0) {
            d = dArray2[0] - this.getBinWidth() / 2.0;
            d2 = dArray2[dArray2.length - 1] + this.getBinWidth() / 2.0;
        }
        if (this.histogramDataset == null) {
            this.histogramDataset = new HistogramDataset(d, d2, this.getBinWidth());
        } else {
            this.histogramDataset.clear();
            this.histogramDataset.setBinWidth(d, d2, this.getBinWidth());
        }
        this.histogramDataset.setXYColumnNames(this.xColumnName, this.yColumnName, this.name);
        this.histogramDataset.append(dArray2, dArray3);
        this.histogramDataset.setMarkerColor(this.binFillColor, this.binEdgeColor);
        ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
        arrayList.add(this.histogramDataset);
        return arrayList;
    }

    public static XML.ObjectLoader getLoader() {
        return new HistogramLoader();
    }

    protected static class HistogramLoader
    extends XMLLoader {
        protected HistogramLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            Histogram histogram = (Histogram)object;
            double[][] dArray = histogram.logScale ? histogram.getLogPoints() : histogram.getPoints();
            double[] dArray2 = dArray[0];
            double[] dArray3 = dArray[1];
            xMLControl.setValue("log_scale", histogram.logScale);
            xMLControl.setValue("discrete", histogram.discrete);
            xMLControl.setValue("adjust_for_width", histogram.adjustForWidth);
            xMLControl.setValue("bin_fill_color", histogram.binFillColor);
            xMLControl.setValue("bin_edge_color", histogram.binEdgeColor);
            xMLControl.setValue("bin_style", histogram.binStyle);
            xMLControl.setValue("bin_width", histogram.binWidth);
            xMLControl.setValue("bin_offset", histogram.binOffset);
            xMLControl.setValue("name", histogram.name);
            xMLControl.setValue("x_column_name", histogram.xColumnName);
            xMLControl.setValue("y_column_name", histogram.yColumnName);
            xMLControl.setValue("bin_column_name", histogram.binColumnName);
            xMLControl.setValue("bins", dArray2);
            xMLControl.setValue("vals", dArray3);
        }

        public Object createObject(XMLControl xMLControl) {
            return new Histogram();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Histogram histogram = (Histogram)object;
            double[] dArray = (double[])xMLControl.getObject("bins");
            double[] dArray2 = (double[])xMLControl.getObject("vals");
            histogram.name = xMLControl.getString("name");
            histogram.xColumnName = xMLControl.getString("x_column_name");
            histogram.yColumnName = xMLControl.getString("y_column_name");
            histogram.binColumnName = xMLControl.getString("bin_column_name");
            histogram.logScale = xMLControl.getBoolean("log_scale");
            histogram.discrete = xMLControl.getBoolean("discrete");
            histogram.adjustForWidth = xMLControl.getBoolean("adjust_for_width");
            histogram.binFillColor = (Color)xMLControl.getObject("bin_fill_color");
            histogram.binEdgeColor = (Color)xMLControl.getObject("bin_edge_color");
            histogram.binStyle = xMLControl.getInt("bin_style");
            histogram.binWidth = xMLControl.getDouble("bin_width");
            histogram.binOffset = xMLControl.getDouble("bin_offset");
            histogram.adjustForWidth = xMLControl.getBoolean("adjust_for_width");
            if (dArray != null && dArray2 != null) {
                int n = 0;
                int n2 = dArray.length;
                while (n < n2) {
                    histogram.append(dArray[n], dArray2[n]);
                    ++n;
                }
            }
            return object;
        }
    }
}

