/*
 * Decompiled with CFR 0.152.
 */
package users.murcia.fem.ModellingLaboratory.SandPilesAvalanches_pkg;

import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.murcia.fem.ModellingLaboratory.SandPilesAvalanches_pkg.SandPilesAvalanchesSimulation;
import users.murcia.fem.ModellingLaboratory.SandPilesAvalanches_pkg.SandPilesAvalanchesView;

public class SandPilesAvalanches
extends Model {
    public SandPilesAvalanchesSimulation _simulation = null;
    public SandPilesAvalanchesView _view = null;
    public SandPilesAvalanches _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    public int nCells = 30;
    public int maxPile = 4;
    public int[][] sandPile;
    public int[][] avalanche;
    public int stepCounter = 0;
    public int avalancheSize = 0;
    public int histogramStart = 1000;
    public boolean highSpeed = false;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_evolution2 = true;

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return SandPilesAvalanches._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/users/murcia/fem/ModellingLaboratory/SandPilesAvalanches.ejs";
    }

    public static String _getModelDirectory() {
        return "users/murcia/fem/ModellingLaboratory/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(568, 572);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/murcia/fem/ModellingLaboratory/SandPiles/avalanche.jpg");
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/murcia/fem/ModellingLaboratory/");
        n = 0;
        boolean bl2 = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("/Users/Paco/Documents/Eclipse Workspaces/EJS_4.3.5/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("/Users/Paco/Documents/Eclipse Workspaces/EJS_4.3.5/bin/config/");
        }
        SandPilesAvalanches._addHtmlPageInfo("Avalanches in Sand Piles", "_default_", "Avalanches in Sand Piles", "./SandPilesAvalanches_Intro 1.html");
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!SandPilesAvalanches._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        SandPilesAvalanches sandPilesAvalanches = new SandPilesAvalanches(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!SandPilesAvalanches._common_initialization(stringArray)) {
            return null;
        }
        SandPilesAvalanches sandPilesAvalanches = new SandPilesAvalanches("drawingFrame", jFrame, null, null, stringArray, true);
        return (JComponent)sandPilesAvalanches._getView().getComponent("drawingFrame");
    }

    public SandPilesAvalanches() {
        this(null, null, null, null, null, false);
    }

    public SandPilesAvalanches(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public SandPilesAvalanches(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new SandPilesAvalanchesSimulation(this, string, frame, uRL, bl);
        this._view = (SandPilesAvalanchesView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public String _getClassEjsModel() {
        return SandPilesAvalanches._getEjsModel();
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return SandPilesAvalanches._getEjsResources();
    }

    @Override
    public String _getClassModelDirectory() {
        return SandPilesAvalanches._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        int n;
        int n2;
        this._isEnabled_evolution1 = true;
        this._isEnabled_evolution2 = true;
        this.nCells = 30;
        this.maxPile = 4;
        this.sandPile = new int[this.nCells][this.nCells];
        for (n2 = 0; n2 < this.nCells; ++n2) {
            for (n = 0; n < this.nCells; ++n) {
                this.sandPile[n2][n] = (int)Math.floor(4.0 * Math.random()) % 4;
            }
        }
        this.avalanche = new int[this.nCells][this.nCells];
        for (n2 = 0; n2 < this.nCells; ++n2) {
            for (n = 0; n < this.nCells; ++n) {
                this.avalanche[n2][n] = 0;
            }
        }
        this.stepCounter = 0;
        this.avalancheSize = 0;
        this.histogramStart = 1000;
        this.highSpeed = false;
    }

    public void _initializeSolvers() {
    }

    @Override
    public void _initializeModel() {
        this.__shouldBreak = false;
        this._initializeSolvers();
    }

    @Override
    public void _automaticResetSolvers() {
    }

    @Override
    public void _resetSolvers() {
    }

    @Override
    public void _stepModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_evolution1) {
            this._evolution1();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (this._isEnabled_evolution2) {
            this._evolution2();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _updateModel() {
        this.__shouldBreak = false;
    }

    @Override
    public void _freeMemory() {
        this.sandPile = null;
        this.avalanche = null;
        System.gc();
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Evolution".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
        }
        if ("Histogram".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution2 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _evolution1() {
        int n;
        int n2;
        ++this.stepCounter;
        for (n2 = 0; n2 < this.nCells; ++n2) {
            for (n = 0; n < this.nCells; ++n) {
                this.avalanche[n2][n] = 0;
            }
        }
        n2 = (int)((double)this.nCells * Math.random() + 0.5) % this.nCells;
        n = (int)((double)this.nCells * Math.random() + 0.5) % this.nCells;
        int[] nArray = this.sandPile[n2];
        int n3 = n;
        nArray[n3] = nArray[n3] + 1;
        this.avalanche[n2][n] = 1;
        this.computeAvalanches();
    }

    public void _evolution2() {
        this.avalancheSize = 0;
        for (int i = 0; i < this.nCells; ++i) {
            for (int j = 0; j < this.nCells; ++j) {
                if (this.avalanche[i][j] <= 0) continue;
                ++this.avalancheSize;
            }
        }
        if (this.stepCounter < this.histogramStart) {
            return;
        }
        if (this.avalancheSize > 1) {
            this._view.histogram.append(this.avalancheSize);
        }
    }

    public void computeAvalanches() {
        boolean bl;
        int[][] nArray = new int[this.nCells][this.nCells];
        do {
            int n;
            int n2;
            bl = false;
            for (n2 = 0; n2 < this.nCells; ++n2) {
                for (n = 0; n < this.nCells; ++n) {
                    nArray[n2][n] = 0;
                }
            }
            for (n2 = 0; n2 < this.nCells; ++n2) {
                for (n = 0; n < this.nCells; ++n) {
                    if (this.sandPile[n2][n] < this.maxPile) continue;
                    bl = true;
                    int[] nArray2 = nArray[n2];
                    int n3 = n;
                    nArray2[n3] = nArray2[n3] - 4;
                    this.avalanche[n2][n] = 1;
                    if (n2 > 0) {
                        int[] nArray3 = nArray[n2 - 1];
                        int n4 = n;
                        nArray3[n4] = nArray3[n4] + 1;
                        this.avalanche[n2 - 1][n] = 1;
                    }
                    if (n > 0) {
                        int[] nArray4 = nArray[n2];
                        int n5 = n - 1;
                        nArray4[n5] = nArray4[n5] + 1;
                        this.avalanche[n2][n - 1] = 1;
                    }
                    if (n2 < this.nCells - 1) {
                        int[] nArray5 = nArray[n2 + 1];
                        int n6 = n;
                        nArray5[n6] = nArray5[n6] + 1;
                        this.avalanche[n2 + 1][n] = 1;
                    }
                    if (n >= this.nCells - 1) continue;
                    int[] nArray6 = nArray[n2];
                    int n7 = n + 1;
                    nArray6[n7] = nArray6[n7] + 1;
                    this.avalanche[n2][n + 1] = 1;
                }
            }
            if (!bl) continue;
            for (n2 = 0; n2 < this.nCells; ++n2) {
                for (n = 0; n < this.nCells; ++n) {
                    int[] nArray7 = this.sandPile[n2];
                    int n8 = n;
                    nArray7[n8] = nArray7[n8] + nArray[n2][n];
                }
            }
        } while (bl);
    }

    public void _method_for_playPauseButton_actionOn() {
        this._play();
    }

    public void _method_for_playPauseButton_actionOff() {
        this._pause();
    }

    public void _method_for_stepButton_action() {
        this._step();
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public void _method_for_zeroButton_action() {
        this.stepCounter = 0;
        this.avalancheSize = 0;
        this._view.histogram.clear();
        for (int i = 0; i < this.nCells; ++i) {
            for (int j = 0; j < this.nCells; ++j) {
                this.sandPile[i][j] = 0;
                this.avalanche[i][j] = 0;
            }
        }
    }

    public void _method_for_highSpeedCkeckBox_actionon() {
        this._setSPD(100);
    }

    public void _method_for_highSpeedCkeckBox_actionoff() {
        this._setSPD(1);
    }

    static {
        __translatorUtil = new TranslatorUtil();
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }
}

