/*
 * Decompiled with CFR 0.152.
 */
package users.murcia.fem.ModellingLaboratory.SandPilesAvalanches_pkg;

import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.drawables.ControlBinaryLattice;
import org.colos.ejs.library.control.drawables.ControlCellLattice;
import org.colos.ejs.library.control.drawables.ControlHistogram;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlLabel;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlParsedNumberField;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.display.Histogram;
import org.opensourcephysics.display2d.BinaryLattice;
import org.opensourcephysics.display2d.CellLattice;
import org.opensourcephysics.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing2d.PlottingPanel2D;
import users.murcia.fem.ModellingLaboratory.SandPilesAvalanches_pkg.SandPilesAvalanches;
import users.murcia.fem.ModellingLaboratory.SandPilesAvalanches_pkg.SandPilesAvalanchesSimulation;

class SandPilesAvalanchesView
extends EjsControl
implements View {
    private SandPilesAvalanchesSimulation _simulation = null;
    private SandPilesAvalanches _model = null;
    public Component drawingFrame;
    public JPanel centerPanel;
    public JPanel cellsPanel;
    public DrawingPanel2D pilesDrawingPanel;
    public CellLattice pilesCellLattice;
    public DrawingPanel2D avalanchesDrawingPanel;
    public BinaryLattice avalanchesLattice;
    public PlottingPanel2D histogramPlottingPanel;
    public Histogram histogram;
    public JPanel buttonsPanel;
    public JButton playPauseButton;
    public JButton stepButton;
    public JButton resetButton;
    public JButton zeroButton;
    public JPanel stepPanel;
    public JLabel stepLabel;
    public JTextField stepField;
    public JPanel sizePanel;
    public JLabel sizeLabel;
    public JTextField sizeField;
    public JCheckBox highSpeedCkeckBox;
    private boolean __nCells_canBeChanged__ = true;
    private boolean __maxPile_canBeChanged__ = true;
    private boolean __sandPile_canBeChanged__ = true;
    private boolean __avalanche_canBeChanged__ = true;
    private boolean __stepCounter_canBeChanged__ = true;
    private boolean __avalancheSize_canBeChanged__ = true;
    private boolean __histogramStart_canBeChanged__ = true;
    private boolean __highSpeed_canBeChanged__ = true;

    public SandPilesAvalanchesView(SandPilesAvalanchesSimulation sandPilesAvalanchesSimulation, String string, Frame frame) {
        super(sandPilesAvalanchesSimulation, string, frame);
        this._simulation = sandPilesAvalanchesSimulation;
        this._model = (SandPilesAvalanches)sandPilesAvalanchesSimulation.getModel();
        this._model._view = this;
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model._resetModel();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        if (SwingUtilities.isEventDispatchThread()) {
            this.createControl();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SandPilesAvalanchesView.this.createControl();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("nCells", "apply(\"nCells\")");
        this.addListener("maxPile", "apply(\"maxPile\")");
        this.addListener("sandPile", "apply(\"sandPile\")");
        this.addListener("avalanche", "apply(\"avalanche\")");
        this.addListener("stepCounter", "apply(\"stepCounter\")");
        this.addListener("avalancheSize", "apply(\"avalancheSize\")");
        this.addListener("histogramStart", "apply(\"histogramStart\")");
        this.addListener("highSpeed", "apply(\"highSpeed\")");
    }

    @Override
    public void read() {
    }

    @Override
    public void read(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int[][] nArray;
        if ("nCells".equals(string)) {
            this._model.nCells = this.getInt("nCells");
            this.__nCells_canBeChanged__ = true;
        }
        if ("maxPile".equals(string)) {
            this._model.maxPile = this.getInt("maxPile");
            this.__maxPile_canBeChanged__ = true;
        }
        if ("sandPile".equals(string)) {
            nArray = (int[][])this.getValue("sandPile").getObject();
            n4 = nArray.length;
            if (n4 > this._model.sandPile.length) {
                n4 = this._model.sandPile.length;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = nArray[n3].length;
                if (n2 > this._model.sandPile[n3].length) {
                    n2 = this._model.sandPile[n3].length;
                }
                for (n = 0; n < n2; ++n) {
                    this._model.sandPile[n3][n] = nArray[n3][n];
                }
            }
            this.__sandPile_canBeChanged__ = true;
        }
        if ("avalanche".equals(string)) {
            nArray = (int[][])this.getValue("avalanche").getObject();
            n4 = nArray.length;
            if (n4 > this._model.avalanche.length) {
                n4 = this._model.avalanche.length;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = nArray[n3].length;
                if (n2 > this._model.avalanche[n3].length) {
                    n2 = this._model.avalanche[n3].length;
                }
                for (n = 0; n < n2; ++n) {
                    this._model.avalanche[n3][n] = nArray[n3][n];
                }
            }
            this.__avalanche_canBeChanged__ = true;
        }
        if ("stepCounter".equals(string)) {
            this._model.stepCounter = this.getInt("stepCounter");
            this.__stepCounter_canBeChanged__ = true;
        }
        if ("avalancheSize".equals(string)) {
            this._model.avalancheSize = this.getInt("avalancheSize");
            this.__avalancheSize_canBeChanged__ = true;
        }
        if ("histogramStart".equals(string)) {
            this._model.histogramStart = this.getInt("histogramStart");
            this.__histogramStart_canBeChanged__ = true;
        }
        if ("highSpeed".equals(string)) {
            this._model.highSpeed = this.getBoolean("highSpeed");
            this.__highSpeed_canBeChanged__ = true;
        }
    }

    @Override
    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        if (this.__nCells_canBeChanged__) {
            this.setValue("nCells", this._model.nCells);
        }
        if (this.__maxPile_canBeChanged__) {
            this.setValue("maxPile", this._model.maxPile);
        }
        if (this.__sandPile_canBeChanged__) {
            this.setValue("sandPile", this._model.sandPile);
        }
        if (this.__avalanche_canBeChanged__) {
            this.setValue("avalanche", this._model.avalanche);
        }
        if (this.__stepCounter_canBeChanged__) {
            this.setValue("stepCounter", this._model.stepCounter);
        }
        if (this.__avalancheSize_canBeChanged__) {
            this.setValue("avalancheSize", this._model.avalancheSize);
        }
        if (this.__histogramStart_canBeChanged__) {
            this.setValue("histogramStart", this._model.histogramStart);
        }
        if (this.__highSpeed_canBeChanged__) {
            this.setValue("highSpeed", this._model.highSpeed);
        }
    }

    @Override
    public void blockVariable(String string) {
        if ("nCells".equals(string)) {
            this.__nCells_canBeChanged__ = false;
        }
        if ("maxPile".equals(string)) {
            this.__maxPile_canBeChanged__ = false;
        }
        if ("sandPile".equals(string)) {
            this.__sandPile_canBeChanged__ = false;
        }
        if ("avalanche".equals(string)) {
            this.__avalanche_canBeChanged__ = false;
        }
        if ("stepCounter".equals(string)) {
            this.__stepCounter_canBeChanged__ = false;
        }
        if ("avalancheSize".equals(string)) {
            this.__avalancheSize_canBeChanged__ = false;
        }
        if ("histogramStart".equals(string)) {
            this.__histogramStart_canBeChanged__ = false;
        }
        if ("highSpeed".equals(string)) {
            this.__highSpeed_canBeChanged__ = false;
        }
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.drawingFrame = (Component)this.addElement(new ControlFrame(), "drawingFrame").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", "Avalanches in Sand Piles").setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "0,22").setProperty("size", "568,572").getObject();
        this.centerPanel = (JPanel)this.addElement(new ControlPanel(), "centerPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "drawingFrame").setProperty("layout", "GRID:0,1,0,0").getObject();
        this.cellsPanel = (JPanel)this.addElement(new ControlPanel(), "cellsPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "centerPanel").setProperty("layout", "grid:1,0,0,0").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.pilesDrawingPanel = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "pilesDrawingPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "cellsPanel").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1.0").setProperty("maximumX", "1.0").setProperty("minimumY", "-1.0").setProperty("maximumY", "1.0").setProperty("background", "black").getObject();
        this.pilesCellLattice = (CellLattice)this.addElement(new ControlCellLattice(), "pilesCellLattice").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "pilesDrawingPanel").setProperty("data", "sandPile").setProperty("numcolors", "maxPile").setProperty("colormode", "GRAYSCALE").setProperty("showgrid", "true").setProperty("gridcolor", "black").getObject();
        this.avalanchesDrawingPanel = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "avalanchesDrawingPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "cellsPanel").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1.0").setProperty("maximumX", "1.0").setProperty("minimumY", "-1.0").setProperty("maximumY", "1.0").getObject();
        this.avalanchesLattice = (BinaryLattice)this.addElement(new ControlBinaryLattice(), "avalanchesLattice").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "avalanchesDrawingPanel").setProperty("data", "avalanche").setProperty("deadcolor", "white").setProperty("color", "RED").getObject();
        this.histogramPlottingPanel = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "histogramPlottingPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "centerPanel").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("xMarginPercentage", "5").setProperty("title", "Histogram").setProperty("titleX", "Avalanche size").setProperty("titleY", "Frequency").setProperty("yaxisType", "LOG10").setProperty("gutters", "60,35,25,35").getObject();
        this.histogram = (Histogram)this.addElement(new ControlHistogram(), "histogram").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "histogramPlottingPanel").setProperty("discrete", "false").setProperty("lineColor", "BLUE").setProperty("fillColor", "BLUE").getObject();
        this.buttonsPanel = (JPanel)this.addElement(new ControlPanel(), "buttonsPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "drawingFrame").setProperty("layout", "FLOW:center,0,0").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.playPauseButton = (JButton)this.addElement(new ControlTwoStateButton(), "playPauseButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttonsPanel").setProperty("variable", "_isPaused").setProperty("imageOn", "/org/opensourcephysics/resources/controls/images/play.gif").setProperty("actionOn", "_model._method_for_playPauseButton_actionOn()").setProperty("imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif").setProperty("actionOff", "_model._method_for_playPauseButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttonsPanel").setProperty("image", "/org/opensourcephysics/resources/controls/images/stepforward.gif").setProperty("action", "_model._method_for_stepButton_action()").getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttonsPanel").setProperty("image", "/org/opensourcephysics/resources/controls/images/reset.gif").setProperty("action", "_model._method_for_resetButton_action()").getObject();
        this.zeroButton = (JButton)this.addElement(new ControlButton(), "zeroButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttonsPanel").setProperty("text", "Clean").setProperty("action", "_model._method_for_zeroButton_action()").getObject();
        this.stepPanel = (JPanel)this.addElement(new ControlPanel(), "stepPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttonsPanel").setProperty("layout", "border").getObject();
        this.stepLabel = (JLabel)this.addElement(new ControlLabel(), "stepLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "stepPanel").setProperty("text", " Step:").getObject();
        this.stepField = (JTextField)this.addElement(new ControlParsedNumberField(), "stepField").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "stepPanel").setProperty("variable", "stepCounter").setProperty("format", "0").setProperty("editable", "false").setProperty("columns", "6").getObject();
        this.sizePanel = (JPanel)this.addElement(new ControlPanel(), "sizePanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttonsPanel").setProperty("layout", "border").getObject();
        this.sizeLabel = (JLabel)this.addElement(new ControlLabel(), "sizeLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "sizePanel").setProperty("text", " Size:").getObject();
        this.sizeField = (JTextField)this.addElement(new ControlParsedNumberField(), "sizeField").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "sizePanel").setProperty("variable", "avalancheSize").setProperty("format", "0").setProperty("editable", "false").setProperty("columns", "6").getObject();
        this.highSpeedCkeckBox = (JCheckBox)this.addElement(new ControlCheckBox(), "highSpeedCkeckBox").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttonsPanel").setProperty("variable", "highSpeed").setProperty("text", "High speed").setProperty("actionon", "_model._method_for_highSpeedCkeckBox_actionon()").setProperty("actionoff", "_model._method_for_highSpeedCkeckBox_actionoff()").getObject();
    }

    @Override
    public void reset() {
        this.getElement("drawingFrame").setProperty("title", "Avalanches in Sand Piles").setProperty("visible", "true");
        this.getElement("centerPanel");
        this.getElement("cellsPanel").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("pilesDrawingPanel").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1.0").setProperty("maximumX", "1.0").setProperty("minimumY", "-1.0").setProperty("maximumY", "1.0").setProperty("background", "black");
        this.getElement("pilesCellLattice").setProperty("colormode", "GRAYSCALE").setProperty("showgrid", "true").setProperty("gridcolor", "black");
        this.getElement("avalanchesDrawingPanel").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1.0").setProperty("maximumX", "1.0").setProperty("minimumY", "-1.0").setProperty("maximumY", "1.0");
        this.getElement("avalanchesLattice").setProperty("deadcolor", "white").setProperty("color", "RED");
        this.getElement("histogramPlottingPanel").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("xMarginPercentage", "5").setProperty("title", "Histogram").setProperty("titleX", "Avalanche size").setProperty("titleY", "Frequency").setProperty("yaxisType", "LOG10").setProperty("gutters", "60,35,25,35");
        this.getElement("histogram").setProperty("discrete", "false").setProperty("lineColor", "BLUE").setProperty("fillColor", "BLUE");
        this.getElement("buttonsPanel").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("playPauseButton").setProperty("imageOn", "/org/opensourcephysics/resources/controls/images/play.gif").setProperty("imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif");
        this.getElement("stepButton").setProperty("image", "/org/opensourcephysics/resources/controls/images/stepforward.gif");
        this.getElement("resetButton").setProperty("image", "/org/opensourcephysics/resources/controls/images/reset.gif");
        this.getElement("zeroButton").setProperty("text", "Clean");
        this.getElement("stepPanel");
        this.getElement("stepLabel").setProperty("text", " Step:");
        this.getElement("stepField").setProperty("format", "0").setProperty("editable", "false").setProperty("columns", "6");
        this.getElement("sizePanel");
        this.getElement("sizeLabel").setProperty("text", " Size:");
        this.getElement("sizeField").setProperty("format", "0").setProperty("editable", "false").setProperty("columns", "6");
        this.getElement("highSpeedCkeckBox").setProperty("text", "High speed");
        this.__nCells_canBeChanged__ = true;
        this.__maxPile_canBeChanged__ = true;
        this.__sandPile_canBeChanged__ = true;
        this.__avalanche_canBeChanged__ = true;
        this.__stepCounter_canBeChanged__ = true;
        this.__avalancheSize_canBeChanged__ = true;
        this.__histogramStart_canBeChanged__ = true;
        this.__highSpeed_canBeChanged__ = true;
        super.reset();
    }
}

