/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.render;

import gov.usgs.plot.color.ColorCycler;
import gov.usgs.plot.data.Data;
import gov.usgs.plot.render.DataPointRenderer;
import gov.usgs.plot.render.FrameRenderer;
import gov.usgs.plot.render.LegendRenderer;
import gov.usgs.plot.render.PointRenderer;
import gov.usgs.plot.render.Renderer;
import gov.usgs.plot.render.ShapeRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class DataRenderer
extends FrameRenderer {
    protected Data data;
    protected Renderer[] lineRenderers;
    protected Renderer[] pointRenderers;

    public DataRenderer(Data d) {
        this.data = d;
    }

    public Data getData() {
        return this.data;
    }

    public Renderer[] getLineRenderers() {
        return this.lineRenderers;
    }

    public Renderer[] getPointRenderers() {
        return this.pointRenderers;
    }

    @Override
    public void createDefaultLegendRenderer(String[] s) {
        this.setLegendRenderer(new LegendRenderer());
        this.getLegendRenderer().x = this.graphX + 6;
        this.getLegendRenderer().y = this.graphY + 6;
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null) continue;
            ShapeRenderer sr = null;
            if (this.lineRenderers != null) {
                sr = (ShapeRenderer)this.lineRenderers[i];
            }
            PointRenderer pr = null;
            if (this.pointRenderers != null) {
                pr = (PointRenderer)this.pointRenderers[i];
            }
            this.getLegendRenderer().addLine(sr, pr, s[i]);
        }
    }

    public void createDefaultLineRenderers() {
        if (this.data == null) {
            return;
        }
        double[][] d = this.data.getData();
        this.lineRenderers = new Renderer[d[0].length - 1];
        ColorCycler cc = new ColorCycler();
        for (int i = 1; i < d[0].length; ++i) {
            if (!this.data.isVisible(i - 1)) continue;
            ShapeRenderer sr = new ShapeRenderer(new GeneralPath());
            sr.color = cc.getNextColor();
            this.lineRenderers[i - 1] = sr;
        }
    }

    public void createDefaultPointRenderers() {
        if (this.data == null) {
            return;
        }
        double[][] d = this.data.getData();
        this.pointRenderers = new Renderer[d[0].length - 2];
        for (int i = 2; i < d[0].length; ++i) {
            if (!this.data.isVisible(i - 2)) continue;
            DataPointRenderer pr = new DataPointRenderer();
            pr.transformer = this;
            this.pointRenderers[i - 2] = pr;
        }
    }

    @Override
    public void render(Graphics2D g) {
        AffineTransform origAT = g.getTransform();
        Color origColor = g.getColor();
        Stroke origStroke = g.getStroke();
        Shape origClip = g.getClip();
        if (this.axis != null) {
            this.axis.render(g);
        }
        g.clip(new Rectangle(this.graphX + 1, this.graphY + 1, this.graphWidth - 1, this.graphHeight - 1));
        double[][] d = this.data.getData();
        for (int j = 2; j < d[0].length; ++j) {
            if (!this.data.isVisible(j - 2)) continue;
            ShapeRenderer sr = null;
            if (this.lineRenderers != null) {
                sr = (ShapeRenderer)this.lineRenderers[j - 2];
            }
            PointRenderer pr = null;
            if (this.pointRenderers != null) {
                pr = (PointRenderer)this.pointRenderers[j - 2];
            }
            GeneralPath gp = null;
            if (sr != null) {
                gp = (GeneralPath)sr.shape;
                gp.reset();
                gp.moveTo((float)this.getXPixel(d[0][0]), (float)this.getYPixel(d[0][j]));
            }
            boolean lastnd = false;
            for (int i = 0; i < d.length; ++i) {
                if (pr != null && d[i][j] != Data.NO_DATA) {
                    pr.x = d[i][0];
                    pr.y = d[i][j];
                    pr.render(g);
                }
                if (gp == null || i == 0) continue;
                if (d[i][j] != Data.NO_DATA) {
                    if (lastnd) {
                        gp.moveTo((float)this.getXPixel(d[i][0]), (float)this.getYPixel(d[i][j]));
                    } else {
                        gp.lineTo((float)this.getXPixel(d[i][0]), (float)this.getYPixel(d[i][j]));
                    }
                    lastnd = false;
                    continue;
                }
                lastnd = true;
            }
            if (sr == null) continue;
            sr.render(g);
        }
        g.setClip(origClip);
        g.setStroke(origStroke);
        g.setColor(origColor);
        g.setTransform(origAT);
        if (this.getLegendRenderer() != null) {
            this.getLegendRenderer().render(g);
        }
    }
}

