/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.map;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.EventIterator;
import edu.sc.seis.seisFile.fdsnws.quakeml.Magnitude;
import edu.sc.seis.seisFile.fdsnws.quakeml.Origin;
import edu.sc.seis.seisFile.fdsnws.quakeml.Quakeml;
import gov.usgs.proj.GeoRange;
import gov.usgs.swarm.map.ClickableGeoLabel;
import gov.usgs.swarm.map.Hypocenter;
import gov.usgs.swarm.map.LabelSource;
import gov.usgs.swarm.map.MapFrame;
import gov.usgs.util.Time;
import java.awt.geom.Point2D;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.xml.stream.XMLStreamException;

public class FdsnLabelSource
implements LabelSource {
    @Override
    public List<? extends ClickableGeoLabel> getLabels() {
        FDSNEventQueryParams queryParams = new FDSNEventQueryParams();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        MapFrame mapFrame = MapFrame.getInstance();
        if (mapFrame == null) {
            return null;
        }
        GeoRange range = mapFrame.getRange();
        float minLat = (float)range.getSouth();
        float maxLat = (float)range.getNorth();
        float minLon = (float)range.getWest();
        float maxLon = (float)range.getEast();
        Date endTime = new Date(System.currentTimeMillis());
        Date startTime = new Date(System.currentTimeMillis() - 86400000L);
        queryParams.area(minLat, maxLat, minLon, maxLon).setStartTime(startTime).setEndTime(endTime).setMaxDepth(100.0f).setMinMagnitude(1.0f).setOrderBy("time-asc");
        FDSNEventQuerier querier = new FDSNEventQuerier(queryParams);
        Quakeml quakeml = null;
        try {
            quakeml = querier.getQuakeML();
        }
        catch (FDSNWSException e1) {
            e1.printStackTrace();
        }
        if (!quakeml.checkSchemaVersion()) {
            System.out.println("");
            System.out.println("WARNING: XmlSchema of this document does not match this code, results may be incorrect.");
            System.out.println("XmlSchema (code): http://quakeml.org/xmlns/quakeml/1.2");
            System.out.println("XmlSchema (doc): " + quakeml.getSchemaVersion());
        }
        ArrayList<Hypocenter> hypos = new ArrayList<Hypocenter>();
        EventIterator eIt = quakeml.getEventParameters().getEvents();
        try {
            while (eIt.hasNext()) {
                Event e = eIt.next();
                Origin o = (Origin)e.getOriginList().get(0);
                Magnitude m = (Magnitude)e.getMagnitudeList().get(0);
                System.out.println(o.getLatitude() + "/" + o.getLongitude() + " " + m.getMag().getValue() + " " + m.getType() + " " + o.getTime().getValue());
                Hypocenter h = new Hypocenter();
                double lat = o.getLatitude().getValue().floatValue();
                double lon = o.getLongitude().getValue().floatValue();
                h.location = new Point2D.Double(lon, lat);
                h.text = "M" + m.getMag().getValue();
                h.depth = o.getDepth().getValue().floatValue();
                h.time = Time.parse("yyyy-MM-dd'T'HH:mm:ss.SSSS", o.getTime().getValue());
                hypos.add(h);
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (SeisFileException e) {
            e.printStackTrace();
        }
        return hypos;
    }
}

