/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class FileCopy {
    public static final int OVERWRITE_ALWAYS = 1;
    public static final int OVERWRITE_NEVER = 2;
    public static final int OVERWRITE_ASK = 3;
    private static int bufferSize = 4096;
    private static boolean clock = true;
    private static boolean copyOriginalTimestamp = true;
    private static boolean verify = true;
    private static int override = 3;

    public static Long fileCopy(File srcFile, File destFile) throws IOException {
        int bytesRead;
        FileInputStream in = new FileInputStream(srcFile);
        FileOutputStream out = new FileOutputStream(destFile);
        long millis = System.currentTimeMillis();
        CRC32 checksum = null;
        if (verify) {
            checksum = new CRC32();
            checksum.reset();
        }
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = ((InputStream)in).read(buffer)) >= 0) {
            if (verify) {
                checksum.update(buffer, 0, bytesRead);
            }
            ((OutputStream)out).write(buffer, 0, bytesRead);
        }
        ((OutputStream)out).close();
        ((InputStream)in).close();
        if (clock) {
            millis = System.currentTimeMillis() - millis;
        }
        if (verify) {
            return new Long(checksum.getValue());
        }
        return null;
    }

    public static Long createChecksum(File file) throws IOException {
        int bytesRead;
        long millis = System.currentTimeMillis();
        FileInputStream in = new FileInputStream(file);
        CRC32 checksum = new CRC32();
        checksum.reset();
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = ((InputStream)in).read(buffer)) >= 0) {
            checksum.update(buffer, 0, bytesRead);
        }
        ((InputStream)in).close();
        if (clock) {
            millis = System.currentTimeMillis() - millis;
        }
        return new Long(checksum.getValue());
    }

    public static boolean doCopy(File file) {
        boolean exists = file.exists();
        if (override == 1 || !exists) {
            return true;
        }
        if (override == 2) {
            return false;
        }
        if (override == 3) {
            return FileCopy.readYesNoFromStandardInput("File exists. Overwrite (y/n)?");
        }
        throw new InternalError("Program error. Invalid value for override: " + override);
    }

    public static void main(String[] args) throws IOException {
        File destFile;
        File destDir;
        File srcFile;
        if (args.length != 2) {
            System.err.println("Usage: FileCopy SRC-FILE-NAME DEST-DIR-NAME");
            System.exit(1);
        }
        if (!(srcFile = new File(args[0])).isFile() || !srcFile.canRead()) {
            System.err.println("Not a readable file: " + srcFile.getName());
            System.exit(1);
        }
        if (!(destDir = new File(args[1])).isDirectory()) {
            System.err.println("Not a directory: " + destDir.getName());
            System.exit(1);
        }
        if (!FileCopy.doCopy(destFile = new File(destDir, srcFile.getName()))) {
            return;
        }
        Long checksumSrc = FileCopy.fileCopy(srcFile, destFile);
        if (copyOriginalTimestamp && !destFile.setLastModified(srcFile.lastModified())) {
            System.err.println("Error: Could not set timestamp of copied file.");
        }
        if (verify) {
            System.out.print("Verifying destination file...");
            Long checksumDest = FileCopy.createChecksum(destFile);
            if (checksumSrc.equals(checksumDest)) {
                System.out.println(" OK, files are equal.");
            } else {
                System.out.println(" Error: Checksums differ.");
            }
        }
    }

    public static boolean readYesNoFromStandardInput(String message) {
        System.out.println(message);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        Boolean answer = null;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if ("y".equals(line = line.toLowerCase()) || "yes".equals(line)) {
                    answer = Boolean.TRUE;
                    break;
                }
                if ("n".equals(line) || "no".equals(line)) {
                    answer = Boolean.FALSE;
                    break;
                }
                System.out.println("Could not understand answer (\"" + line + "\"). Please use y for yes or n for no.");
            }
            if (answer == null) {
                throw new IOException("Unexpected end of input from stdin.");
            }
            in.close();
            return answer;
        }
        catch (IOException ioe) {
            throw new InternalError("Cannot read from stdin or write to stdout.");
        }
    }
}

