/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class Time {
    public static final String INPUT_TIME_FORMAT = "yyyyMMddHHmmss";
    public static final String STANDARD_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String STANDARD_TIME_FORMAT_MS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FDSN_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSS";
    public static final double SECONDSPERYEAR = 3.15576E7;
    public static final double UNIXZERO = -9.46728E8;
    private static Map<String, SimpleDateFormat> formats = new HashMap<String, SimpleDateFormat>();

    public static synchronized String format(String fs, long t) {
        return Time.format(fs, (double)t / 1000.0 + -9.46728E8);
    }

    public static synchronized String format(String fs, double j2k) {
        return Time.format(fs, Util.j2KToDate(j2k));
    }

    public static synchronized String format(String fs, Date d) {
        return Time.getFormat(fs).format(d);
    }

    public static String toDateString(Date d) {
        return Time.format(STANDARD_TIME_FORMAT, d);
    }

    public static String toShortString(Date d) {
        return Time.format(INPUT_TIME_FORMAT, d);
    }

    public static String toDateString(double j2k) {
        return Time.format(STANDARD_TIME_FORMAT, j2k);
    }

    public static String toDateString(long t) {
        return Time.format(STANDARD_TIME_FORMAT, t);
    }

    protected static SimpleDateFormat getFormat(String fs) {
        SimpleDateFormat format = formats.get(fs);
        if (format == null) {
            format = new SimpleDateFormat(fs);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            formats.put(fs, format);
        }
        return format;
    }

    public static synchronized double parse(String fs, String ds) {
        try {
            return Util.dateToJ2K(Time.getFormat(fs).parse(ds));
        }
        catch (Exception e) {
            System.out.println("Failed to parse time: " + ds + ", format: " + fs);
            e.printStackTrace();
            return 0.0;
        }
    }

    public static synchronized double parseEx(String fs, String ds) throws ParseException {
        return Util.dateToJ2K(Time.getFormat(fs).parse(ds));
    }

    public static double getRelativeTime(String t) {
        if (t == null || t.charAt(0) != '-') {
            return Double.NaN;
        }
        int number = Integer.MIN_VALUE;
        try {
            number = Integer.parseInt(t.substring(1, t.length() - 1));
        }
        catch (Exception e) {
            return Double.NaN;
        }
        char unit = t.charAt(t.length() - 1);
        double unitSize = 0.0;
        switch (unit) {
            case 's': {
                unitSize = 1.0;
                break;
            }
            case 'i': {
                unitSize = 60.0;
                break;
            }
            case 'h': {
                unitSize = 3600.0;
                break;
            }
            case 'd': {
                unitSize = 86400.0;
                break;
            }
            case 'w': {
                unitSize = 604800.0;
                break;
            }
            case 'm': {
                unitSize = 2592000.0;
                break;
            }
            case 'y': {
                unitSize = 3.1536E7;
                break;
            }
            default: {
                return Double.NaN;
            }
        }
        return (double)number * unitSize;
    }

    public static synchronized double[] parseTimeRange(String timeRange) throws ParseException {
        if (timeRange == null || timeRange.equals("")) {
            throw new ParseException("Time range is null.", -1);
        }
        double[] result = new double[2];
        String[] ss = timeRange.split(",");
        result[1] = CurrentTime.getInstance().nowJ2K();
        result[0] = 0.0;
        if (ss.length == 2) {
            if (ss[1].charAt(0) == '-') {
                double rt = Time.getRelativeTime(ss[1]);
                if (Double.isNaN(rt)) {
                    throw new ParseException("Unparsable relative end time.", -1);
                }
                result[1] = result[1] - rt;
            } else {
                result[1] = Util.dateToJ2K(Time.getFormat(INPUT_TIME_FORMAT).parse(ss[1]));
            }
        }
        if (ss[0].charAt(0) == '-') {
            result[0] = Time.getRelativeTime(ss[0]);
            if (Double.isNaN(result[0])) {
                throw new ParseException("Unparsable relative start time.", -1);
            }
            result[0] = result[1] - result[0];
        } else {
            result[0] = Util.dateToJ2K(Time.getFormat(INPUT_TIME_FORMAT).parse(ss[0]));
        }
        return result;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Args:");
            System.out.println("-d\t\tdisplay default and available ids");
            System.exit(1);
        }
        String cmd = "";
        if (args.length == 1) {
            cmd = args[0].toLowerCase();
        }
        if (cmd.equals("getzones")) {
            System.out.println("Default time zone is " + TimeZone.getDefault().getID());
            System.out.println("Available time zones:");
            Object[] zones = TimeZone.getAvailableIDs();
            Arrays.sort(zones);
            for (Object s : zones) {
                System.out.println("\t" + (String)s);
            }
        }
    }
}

