/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.pensive;

import gov.usgs.swarm.data.DataSourceType;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.util.ConfigFile;
import gov.usgs.volcanoes.pensive.PlotJob;
import gov.usgs.volcanoes.pensive.plot.SubnetPlotter;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveSource
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger("gov.usgs");
    public static final String DEFAULT_TYPE = "wws";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 16022;
    public static final int DEFAULT_TIMEOUT_S = 15;
    private final SeismicDataSource dataSource;
    private BlockingQueue<PlotJob> plotJobs;
    public final String name;

    public WaveSource(String name, BlockingQueue<PlotJob> plotJobs, ConfigFile config) {
        this.plotJobs = plotJobs;
        this.name = name;
        String type = config.getString("type", DEFAULT_TYPE);
        String host = config.getString("host", DEFAULT_HOST);
        int port = config.getInt("port", 16022);
        int timeout = config.getInt("timeout", 15);
        int compress = 1;
        String dsString = null;
        if (type.equals(DEFAULT_TYPE)) {
            dsString = name + ";" + type + ":" + host + ":" + port + ":" + timeout * 1000 + ":" + compress;
        } else if (type.equals("wsv")) {
            dsString = name + ";ws:" + host + ":" + port + ":" + timeout * 1000 + ":1800:1000:UTC";
        }
        this.dataSource = DataSourceType.parseConfig(dsString);
        this.dataSource.establish();
        this.dataSource.setUseCache(false);
    }

    @Override
    public void run() {
        while (true) {
            PlotJob pj = null;
            try {
                pj = this.plotJobs.take();
                SubnetPlotter subnet = pj.subnet;
                LOGGER.debug("Plotting subnet {} from {}", (Object)subnet.subnetName, (Object)this.name);
                subnet.plot(pj.plotEndMs, this.dataSource);
            }
            catch (InterruptedException noAction) {
            }
        }
    }
}

