/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class Instrument {
    public static Instrument NULL = new Instrument();
    private int iid;
    private String name;
    private String description;
    private double longitude = -999.0;
    private double latitude = -999.0;
    private double height = -999.0;
    private String timeZone;
    private Map<String, String> metadata;

    public Instrument() {
    }

    public Instrument(ResultSet rs) throws SQLException {
        this.iid = rs.getInt("instruments.iid");
        this.name = rs.getString("name");
        this.description = rs.getString("description");
        this.longitude = rs.getDouble("lon");
        boolean nll = rs.wasNull();
        this.latitude = rs.getDouble("lat");
        boolean bl = nll = nll || rs.wasNull();
        if (nll) {
            this.longitude = -999.0;
            this.latitude = -999.0;
        }
        this.height = rs.getDouble("height");
        this.timeZone = rs.getString("timezone");
    }

    public int getID() {
        return this.iid;
    }

    public void setMetadata(Map<String, String> map) {
        this.metadata = map;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setLongitude(double d) {
        this.longitude = d;
    }

    public void setLatitude(double d) {
        this.latitude = d;
    }

    public double getLongitude() {
        if (this.longitude == -999.0) {
            return Double.NaN;
        }
        return this.longitude;
    }

    public double getLatitude() {
        if (this.latitude == -999.0) {
            return Double.NaN;
        }
        return this.latitude;
    }

    public double getHeight() {
        if (this.height == -999.0) {
            return Double.NaN;
        }
        return this.height;
    }

    public void setTimeZone(String s) {
        this.timeZone = s;
    }

    public String getTimeZone() {
        return this.timeZone == null ? "" : this.timeZone;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return String.format("%d:%s:%s:%f:%f:%f", this.iid, this.name, this.description, this.longitude, this.latitude, this.height);
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(int iid) {
        this.iid = iid;
    }
}

