/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server;

import gov.usgs.net.CommandHandler;
import gov.usgs.net.NetTools;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.cmd.BaseCommand;
import gov.usgs.winston.server.cmd.GetChannelsCommand;
import gov.usgs.winston.server.cmd.GetMetadataCommand;
import gov.usgs.winston.server.cmd.GetSCNCommand;
import gov.usgs.winston.server.cmd.GetSCNLCommand;
import gov.usgs.winston.server.cmd.GetSCNLHeliRawCommand;
import gov.usgs.winston.server.cmd.GetSCNLRSAMRawCommand;
import gov.usgs.winston.server.cmd.GetSCNLRawCommand;
import gov.usgs.winston.server.cmd.GetSCNRawCommand;
import gov.usgs.winston.server.cmd.GetWaveRawCommand;
import gov.usgs.winston.server.cmd.HttpCommand;
import gov.usgs.winston.server.cmd.MenuCommand;
import gov.usgs.winston.server.cmd.StatusCommand;
import java.nio.channels.SocketChannel;

public class ServerHandler
extends CommandHandler {
    private static final int PROTOCOL_VERSION = 3;
    private WinstonDatabase winston;
    private static int instances = 0;
    private WWS wws;
    private NetTools netTools;

    public ServerHandler(WWS s) {
        super(s, "WWSHandler-" + instances++);
        this.wws = s;
        this.netTools = new NetTools();
        this.netTools.setServer(this.wws);
        this.winston = new WinstonDatabase(this.wws.getWinstonDriver(), this.wws.getWinstonURL(), this.wws.getWinstonPrefix(), this.wws.getWinstonStatementCacheCap());
        this.slowCommandTime = this.wws.slowCommandTime;
        this.setupCommandHandlers();
    }

    @Override
    protected void setupCommandHandlers() {
        this.addCommand("VERSION", new BaseCommand(this.netTools, this.winston, this.wws){

            @Override
            public void doCommand(Object info, SocketChannel channel) {
                this.netTools.writeString("PROTOCOL_VERSION: 3\n", channel);
            }
        });
        this.addCommand("MENU", new MenuCommand(this.netTools, this.winston, this.wws));
        this.addCommand("STATUS", new StatusCommand(this.netTools, this.winston, this.wws));
        this.addCommand("GETSCNRAW", new GetSCNRawCommand(this.netTools, this.winston, this.wws));
        this.addCommand("GETSCNLRAW", new GetSCNLRawCommand(this.netTools, this.winston, this.wws));
        this.addCommand("GETSCN", new GetSCNCommand(this.netTools, this.winston, this.wws));
        this.addCommand("GETSCNL", new GetSCNLCommand(this.netTools, this.winston, this.wws));
        this.addCommand("GETSCNLHELIRAW", new GetSCNLHeliRawCommand(this.netTools, this.winston, this.wws));
        this.addCommand("GETSCNLRSAMRAW", new GetSCNLRSAMRawCommand(this.netTools, this.winston, this.wws));
        this.addCommand("GETCHANNELS", new GetChannelsCommand(this.netTools, this.winston, this.wws));
        this.addCommand("GETWAVERAW", new GetWaveRawCommand(this.netTools, this.winston, this.wws));
        this.addCommand("GETMETADATA", new GetMetadataCommand(this.netTools, this.winston, this.wws));
        if (this.wws.isHttpAllowed()) {
            this.addCommand("GET", new HttpCommand(this.netTools, this.winston, this.wws, this));
            this.addCommand("POST", new HttpCommand(this.netTools, this.winston, this.wws, this));
        }
    }
}

