/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd.http.fdsn.command;

import gov.usgs.net.HttpRequest;
import gov.usgs.net.HttpResponse;
import gov.usgs.net.HttpStatusCode;
import gov.usgs.net.NetTools;
import gov.usgs.util.Time;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.cmd.http.AbstractHttpCommand;
import java.nio.channels.SocketChannel;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class FdsnCommand
extends AbstractHttpCommand {
    protected String version;
    protected static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSS");

    public FdsnCommand(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
    }

    @Override
    public void respond(String cmd, SocketChannel c, HttpRequest request) {
        this.socketChannel = c;
        this.request = request;
        this.cmd = cmd;
        this.arguments = request.getArguments();
        this.sendResponse();
    }

    protected void sendError(int code, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error " + code + ": " + HttpStatusCode.getReason(code) + "\n\n");
        sb.append(msg + "\n\n");
        sb.append("Usage details are available from http://" + this.request.getHeader("Host") + this.request.getFile() + "\n\n");
        sb.append("Request:\n");
        sb.append("http://" + this.request.getHeader("Host") + this.request.getFile() + "?" + this.request.getArgumentString() + "\n\n");
        sb.append("Request Submitted:\n");
        sb.append(Time.format("yyyy-MM-dd'T'HH:mm:ss.SSSS", new Date(System.currentTimeMillis())) + "\n\n");
        sb.append("Service version:\n");
        sb.append(this.version);
        String txt = sb.toString();
        HttpResponse response = new HttpResponse("text/plain");
        response.setCode("" + code);
        response.setLength(txt.length());
        this.netTools.writeString(response.getHeaderString(), this.socketChannel);
        this.netTools.writeString(txt, this.socketChannel);
    }
}

