/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd.http.fdsn.constraint;

import gov.usgs.util.Util;
import gov.usgs.winston.Channel;
import gov.usgs.winston.Instrument;
import gov.usgs.winston.server.cmd.http.fdsn.FdsnException;
import gov.usgs.winston.server.cmd.http.fdsn.constraint.FdsnConstraint;

public class FdsnGeographicSquareConstraint
implements FdsnConstraint {
    private static final double DEFAULT_MINLATITUDE = -90.0;
    private static final double DEFAULT_MAXLATITUDE = 90.0;
    private static final double DEFAULT_MINLONGITUDE = -180.0;
    private static final double DEFAULT_MAXLONGITUDE = 180.0;
    public final double minlatitude;
    public final double maxlatitude;
    public final double minlongitude;
    public final double maxlongitude;

    public FdsnGeographicSquareConstraint(String minlatitude, String maxlatitude, String minlongitude, String maxlongitude) throws FdsnException {
        this.minlatitude = Util.stringToDouble(minlatitude, -90.0);
        this.maxlatitude = Util.stringToDouble(maxlatitude, 90.0);
        this.minlongitude = Util.stringToDouble(minlongitude, -180.0);
        this.maxlongitude = Util.stringToDouble(maxlongitude, 180.0);
    }

    @Override
    public boolean matches(Channel chan) {
        Instrument i = chan.getInstrument();
        if (i.getLatitude() < this.minlatitude) {
            return false;
        }
        if (i.getLatitude() > this.maxlatitude) {
            return false;
        }
        if (i.getLongitude() < this.minlongitude) {
            return false;
        }
        return !(i.getLongitude() > this.maxlongitude);
    }

    public String toString() {
        return "FdsnGeographcSquareConstraint" + this.minlatitude + ", " + this.minlongitude + " -> " + this.maxlatitude + ", " + this.maxlongitude;
    }
}

