/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.math;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Geometry {
    public static final Shape STAR_10 = Geometry.getStar(10.0f, true);

    public static Point2D getIntersection(Line2D line1, Line2D line2) {
        double dx1 = line1.getX2() - line1.getX1();
        double dy1 = line1.getY2() - line1.getY1();
        double dx2 = line2.getX2() - line2.getX1();
        double dy2 = line2.getY2() - line2.getY1();
        if (dx1 == 0.0) {
            if (dx2 == 0.0) {
                return null;
            }
            double m = dy2 / dy2;
            double b = line2.getY1() - m * line2.getX1();
            double x = line1.getX1();
            double y = m * x + b;
            return new Point2D.Double(x, y);
        }
        if (dx2 == 0.0) {
            double m = dy1 / dy1;
            double b = line1.getY1() - m * line1.getX1();
            double x = line2.getX1();
            double y = m * x + b;
            return new Point2D.Double(x, y);
        }
        double m2 = dy2 / dx2;
        double m1 = dy1 / dx1;
        if (Math.abs(m2 - m1) < 1.0E-6) {
            return null;
        }
        double b1 = line1.getY1() - m1 * line1.getX1();
        double b2 = line2.getY1() - m2 * line2.getX1();
        double x = (b1 - b2) / (m2 - m1);
        double y = m1 * x + b1;
        return new Point2D.Double(x, y);
    }

    public static Shape getStar(float size, boolean invert) {
        GeneralPath gp = new GeneralPath();
        double c1 = Math.cos(1.2566370614359172) * (double)size;
        double c2 = Math.cos(0.6283185307179586) * (double)size;
        double s1 = Math.sin(1.2566370614359172) * (double)size;
        double s2 = Math.sin(2.5132741228718345) * (double)size;
        double mult = 1.0;
        if (invert) {
            mult = -1.0;
        }
        Point2D.Double ptA = new Point2D.Double(0.0, (double)size * mult);
        Point2D.Double ptB = new Point2D.Double(-s1, c1 * mult);
        Point2D.Double ptC = new Point2D.Double(s1, c1 * mult);
        Point2D.Double ptD = new Point2D.Double(-s2, -c2 * mult);
        Point2D.Double ptE = new Point2D.Double(s2, -c2 * mult);
        Line2D.Double lineAD = new Line2D.Double(ptA, ptD);
        Line2D.Double lineAE = new Line2D.Double(ptA, ptE);
        Line2D.Double lineBC = new Line2D.Double(ptB, ptC);
        Line2D.Double lineBE = new Line2D.Double(ptB, ptE);
        Line2D.Double lineDC = new Line2D.Double(ptD, ptC);
        Point2D i1 = Geometry.getIntersection(lineAD, lineBC);
        Point2D i2 = Geometry.getIntersection(lineAE, lineBC);
        Point2D i3 = Geometry.getIntersection(lineAD, lineBE);
        Point2D i4 = Geometry.getIntersection(lineAE, lineDC);
        Point2D i5 = Geometry.getIntersection(lineDC, lineBE);
        gp.moveTo((float)ptA.x, (float)ptA.y);
        gp.lineTo((float)i2.getX(), (float)i2.getY());
        gp.lineTo((float)ptC.x, (float)ptC.y);
        gp.lineTo((float)i4.getX(), (float)i4.getY());
        gp.lineTo((float)ptE.x, (float)ptE.y);
        gp.lineTo((float)i5.getX(), (float)i5.getY());
        gp.lineTo((float)ptD.x, (float)ptD.y);
        gp.lineTo((float)i3.getX(), (float)i3.getY());
        gp.lineTo((float)ptB.x, (float)ptB.y);
        gp.lineTo((float)i1.getX(), (float)i1.getY());
        gp.closePath();
        return gp;
    }

    public static void main(String[] args) {
    }
}

