/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.data;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import gov.usgs.math.Util;

public class Spectrogram {
    public static final int DEFAULT_SAMPLING_RATE = 100;
    public static final int DEFAULT_NFFT = 512;
    public static final int DEFAULT_BIN_SIZE = 256;
    public static final int DEFAULT_OVERLAP = 220;
    public static final double DEFAULT_BETA = 5.0;
    public static final double DEFAULT_MULTIPLIER = 20.0;
    public static final double REFERENCE_AMPLITUDE = 1.0;
    private final int samplingRate;
    private final int nfft;
    private final int binSize;
    private final int overlap;
    private final int nRows;
    private final int nColumns;
    private final double beta;
    private final double[] signal;
    private final double[] frequency;
    private final double[] time;
    private final double[] window;
    private final double[][] spectraAmplitude;

    public Spectrogram(double[] s) {
        this(s, 100, 512, 256, 220, 5.0);
    }

    public Spectrogram(double[] s, int sr, int nf, int bs, int ol, double b) {
        this.signal = s;
        this.samplingRate = sr;
        this.nfft = nf;
        this.binSize = Math.min(bs, s.length);
        this.overlap = Math.min(ol, s.length - 1);
        this.beta = b;
        this.nRows = this.nfft / 2 + 1;
        this.nColumns = (int)Math.floor(((double)this.getNSamples() - (double)this.overlap) / ((double)this.binSize - (double)this.overlap));
        this.frequency = this.computeFrequency();
        this.time = this.computeTime();
        this.window = Util.kaiser(this.binSize, this.beta);
        this.spectraAmplitude = this.computeSpectraAmplitude();
    }

    public int getNFrequencyBins() {
        return this.nRows;
    }

    public int getNTimeBins() {
        return this.nColumns;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public int getNSamples() {
        return this.signal.length;
    }

    public int getNfft() {
        return this.nfft;
    }

    public int getBinSize() {
        return this.binSize;
    }

    public double getBeta() {
        return this.beta;
    }

    public int getOverlap() {
        return this.overlap;
    }

    public double[] getFrequency() {
        return this.frequency;
    }

    public double[] getTime() {
        return this.time;
    }

    public double[] getWindow() {
        return this.window;
    }

    public double getMinSpectraAmplitude() {
        double MIN = Double.MAX_VALUE;
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = 0; j < this.nColumns; ++j) {
                if (!(this.spectraAmplitude[i][j] < MIN)) continue;
                MIN = this.spectraAmplitude[i][j];
            }
        }
        return MIN;
    }

    public double getMaxSpectraAmplitude() {
        double MAX = Double.MIN_VALUE;
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = 0; j < this.nColumns; ++j) {
                if (!(this.spectraAmplitude[i][j] > MAX)) continue;
                MAX = this.spectraAmplitude[i][j];
            }
        }
        return MAX;
    }

    public double[][] getSpectraAmplitude() {
        return this.spectraAmplitude;
    }

    public double[][] getLogSpectraAmplitude() {
        return this.getLogSpectraAmplitude(20.0, 1.0);
    }

    public double[][] getLogSpectraAmplitude(double multiplier, double reference_amplitude) {
        double[][] logAmp = new double[this.nRows][this.nColumns];
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = 0; j < this.nColumns; ++j) {
                logAmp[i][j] = multiplier * Math.log10(this.spectraAmplitude[i][j] / reference_amplitude);
            }
        }
        return logAmp;
    }

    private double[] computeFrequency() {
        double[] omega = new double[this.nRows];
        double delta = (double)this.samplingRate / (double)this.nfft;
        for (int i = 0; i < omega.length; ++i) {
            omega[i] = (double)i * delta;
        }
        return omega;
    }

    private double[] computeTime() {
        double[] T = new double[this.nColumns];
        double delta = ((double)this.binSize - (double)this.overlap) / (double)this.samplingRate;
        double alpha = (double)this.binSize / (double)this.samplingRate / 2.0;
        for (int i = 0; i < T.length; ++i) {
            T[i] = (double)i * delta + alpha;
        }
        return T;
    }

    private double[][] computeSpectraAmplitude() {
        double[][] specAmp = new double[this.nRows][this.nColumns];
        double[] bin = new double[this.nfft];
        int c = 0;
        for (int i = 0; i < this.nColumns; ++i) {
            for (int j = 0; j < this.binSize; ++j) {
                bin[j] = this.signal[c] * this.window[j];
                ++c;
            }
            c -= this.overlap;
            DoubleFFT_1D transform = new DoubleFFT_1D(this.nfft);
            transform.realForward(bin);
            specAmp[0][i] = Math.abs(bin[0]);
            specAmp[this.nfft / 2][i] = Math.abs(bin[1]);
            for (int j = 2; j < this.nfft; j += 2) {
                specAmp[j / 2][i] = Math.sqrt(bin[j] * bin[j] + bin[j + 1] * bin[j + 1]);
                bin[j] = 0.0;
                bin[j + 1] = 0.0;
            }
        }
        return specAmp;
    }
}

