/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.data.file;

import edu.iris.dmc.seedcodec.CodecException;
import edu.iris.dmc.seedcodec.DecompressedData;
import edu.iris.dmc.seedcodec.Steim2;
import edu.iris.dmc.seedcodec.SteimException;
import edu.iris.dmc.seedcodec.SteimFrameBlock;
import edu.iris.dmc.seedcodec.UnsupportedCompressionType;
import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import gov.usgs.plot.data.Wave;
import gov.usgs.plot.data.file.SeismicDataFile;
import gov.usgs.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class SeedDataFile
extends SeismicDataFile {
    protected SeedDataFile(String fileName) {
        super(fileName, "SEED^");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws IOException {
        HashMap samples = new HashMap();
        HashMap<String, Float> sampleRates = new HashMap<String, Float>();
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(this.fileName)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        try {
            boolean isDone = false;
            while (!isDone) {
                SeedRecord sr = null;
                try {
                    sr = SeedRecord.read((DataInput)dis, (int)4096);
                }
                catch (EOFException e) {
                    isDone = true;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                }
                if (!(sr instanceof DataRecord)) continue;
                DataRecord dr = (DataRecord)sr;
                DataHeader dh = dr.getHeader();
                if (this.network == null) {
                    this.network = dh.getNetworkCode().trim();
                }
                if (this.station == null) {
                    this.station = dh.getStationIdentifier().trim();
                }
                if (this.channel == null) {
                    this.channel = dh.getChannelIdentifier().trim();
                }
                if (this.location == null) {
                    this.location = dh.getLocationIdentifier();
                }
                String code = this.station + "$" + this.channel + "$" + this.network;
                if (this.location != null && !"  ".equals(this.location)) {
                    code = code + "$" + this.location;
                }
                if (dr.getDataSize() == 0) continue;
                HashMap<Long, int[]> parts = (HashMap<Long, int[]>)samples.get(code);
                if (parts == null) {
                    parts = new HashMap<Long, int[]>();
                    samples.put(code, parts);
                }
                sampleRates.put(code, Float.valueOf(dh.getSampleRate()));
                long start = this.btimeToDate(dh.getStartBtime()).getTime();
                parts.put(start, this.extract(dr));
            }
            for (String code : samples.keySet()) {
                long samplePeriod = (long)(1000.0f / ((Float)sampleRates.get(code)).floatValue());
                Wave wave = this.join(code, samplePeriod, (Map)samples.get(code));
                this.waves.put(code, wave);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Wave join(String code, long samplePeriodMs, Map<Long, int[]> samples) {
        Wave wave = null;
        Set<Long> times = samples.keySet();
        long firstTime = Long.MAX_VALUE;
        long lastTime = Long.MIN_VALUE;
        for (long time : times) {
            firstTime = Math.min(firstTime, time);
            long end = time + (long)samples.get(time).length * samplePeriodMs;
            lastTime = Math.max(lastTime, end);
        }
        int sampleCount = (int)((lastTime - firstTime + 1L) / samplePeriodMs);
        int[] allSamples = new int[sampleCount];
        Arrays.fill(allSamples, Wave.NO_DATA);
        for (long time : times) {
            int[] buf = samples.get(time);
            int idx = (int)((time - firstTime) / samplePeriodMs);
            System.arraycopy(buf, 0, allSamples, idx, buf.length);
        }
        wave = new Wave(allSamples, Util.dateToJ2K(new Date(firstTime)), 1000L / samplePeriodMs);
        return wave;
    }

    private int[] extract(DataRecord dr) throws UnsupportedCompressionType, CodecException, SeedFormatException {
        int numPts = dr.getHeader().getNumSamples();
        int[] data = new int[numPts];
        int numSoFar = 0;
        DecompressedData decompData = dr.decompress();
        int[] temp = decompData.getAsInt();
        System.arraycopy(temp, 0, data, numSoFar, temp.length);
        numSoFar += temp.length;
        return data;
    }

    private Date btimeToDate(Btime btime) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1, btime.getYear());
        cal.set(6, btime.getDayOfYear());
        cal.set(11, btime.getHour());
        cal.set(12, btime.getMin());
        cal.set(13, btime.getSec());
        cal.set(14, btime.getTenthMilli() / 10);
        return cal.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write() throws IOException {
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.fileName)));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        int seq = 1;
        for (String channel : this.waves.keySet()) {
            List<Wave> wavesSegments = ((Wave)this.waves.get(channel)).split(512);
            for (Wave wave : wavesSegments) {
                DataHeader header = new DataHeader(seq++, 'D', false);
                String[] channelCmp = channel.split("$");
                if (channelCmp.length < 3) {
                    channelCmp = channel.split("_");
                }
                if (channelCmp.length < 3) {
                    channelCmp = channel.split(" ");
                }
                String s = channelCmp.length > 0 ? channelCmp[0] : "";
                String c = channelCmp.length > 1 ? channelCmp[1] : "";
                String n = channelCmp.length > 2 ? channelCmp[2] : "";
                String l = channelCmp.length > 3 ? channelCmp[3] : "";
                header.setStationIdentifier(s);
                header.setChannelIdentifier(c);
                header.setNetworkCode(n);
                header.setLocationIdentifier(l);
                header.setNumSamples((short)wave.numSamples());
                header.setSampleRate(wave.getSamplingRate());
                Btime btime = new Btime(Util.j2KToDate(wave.getStartTime()));
                header.setStartBtime(btime);
                DataRecord record = new DataRecord(header);
                try {
                    Blockette1000 blockette1000 = new Blockette1000();
                    blockette1000.setEncodingFormat((byte)11);
                    blockette1000.setWordOrder((byte)1);
                    blockette1000.setDataRecordLength((byte)12);
                    record.addBlockette((Blockette)blockette1000);
                    SteimFrameBlock data = null;
                    try {
                        data = Steim2.encode((int[])wave.buffer, (int)63);
                        record.setData(data.getEncodedData());
                        record.write(dos);
                    }
                    catch (SteimException e) {
                        e.printStackTrace();
                    }
                }
                catch (SeedFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        dos.close();
    }
}

