/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.decorate;

import gov.usgs.util.Util;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SmartTick {
    private static final TimeTicker[] tickers = new TimeTicker[]{new YearTicker(10), new YearTicker(5), new YearTicker(4), new YearTicker(3), new YearTicker(2), new YearTicker(1), new MonthTicker(6), new MonthTicker(4), new MonthTicker(3), new MonthTicker(2), new MonthTicker(1), new DayTicker(20), new DayTicker(10), new DayTicker(7), new DayTicker(3), new DayTicker(2), new DayTicker(1), new HourTicker(12), new HourTicker(6), new HourTicker(4), new HourTicker(3), new HourTicker(2), new HourTicker(1), new MinuteTicker(30), new MinuteTicker(15), new MinuteTicker(10), new MinuteTicker(6), new MinuteTicker(5), new MinuteTicker(4), new MinuteTicker(3), new MinuteTicker(2), new MinuteTicker(1), new SecondTicker(30), new SecondTicker(15), new SecondTicker(10), new SecondTicker(6), new SecondTicker(5), new SecondTicker(4), new SecondTicker(3), new SecondTicker(2), new SecondTicker(1), new MillisecondTicker(500L), new MillisecondTicker(200L), new MillisecondTicker(100L), new MillisecondTicker(50L), new MillisecondTicker(20L), new MillisecondTicker(10L), new MillisecondTicker(5L), new MillisecondTicker(2L), new MillisecondTicker(1L)};

    public static double[] autoTick(double min, double max, int ticks, boolean expand) {
        return SmartTick.autoTick(min, max, ticks, expand, false);
    }

    public static double[] autoTick(double min, double max, int tickCountRequested, boolean expand, boolean clip) {
        double spanExp = gov.usgs.math.Util.getExp(max - min);
        double[] stepMult = new double[]{0.1, 0.2, 0.5, 1.0, 2.0, 5.0};
        int[] numTicks = new int[stepMult.length];
        double[] minTickValues = new double[stepMult.length];
        double[] maxTickValues = new double[stepMult.length];
        double[] steps = new double[stepMult.length];
        for (int i = 0; i < stepMult.length; ++i) {
            double maxTickValue;
            double minTickValue;
            steps[i] = stepMult[i] * Math.pow(10.0, spanExp);
            double step = steps[i];
            if (expand) {
                minTickValue = Math.floor(min / step) * step;
                maxTickValue = Math.ceil(max / step) * step;
            } else {
                minTickValue = Math.ceil(min / step) * step;
                maxTickValue = Math.floor(max / step) * step;
            }
            minTickValues[i] = minTickValue;
            maxTickValues[i] = maxTickValue;
            numTicks[i] = (int)Math.round((maxTickValue - minTickValue) / step) + 1;
        }
        int minDeltaTicks = Integer.MAX_VALUE;
        int minDeltaTicksIndex = -1;
        for (int i = 0; i < numTicks.length; ++i) {
            int deltaTicks = Math.abs(tickCountRequested - numTicks[i]);
            if (deltaTicks >= minDeltaTicks) continue;
            minDeltaTicksIndex = i;
            minDeltaTicks = deltaTicks;
        }
        if (minDeltaTicksIndex == -1) {
            return null;
        }
        int tickIndex = minDeltaTicksIndex;
        double[] result = new double[numTicks[minDeltaTicksIndex]];
        for (int i = 0; i < numTicks[tickIndex]; ++i) {
            result[i] = minTickValues[tickIndex] + (double)i * steps[tickIndex];
            if (clip && result[i] < min) {
                result[i] = min;
            }
            if (!clip || !(result[i] > max)) continue;
            result[i] = max;
        }
        return result;
    }

    public static double[] intervalTick(double min, double max, int ticks) {
        double interval = (max - min) / (double)ticks;
        double[] result = new double[ticks];
        for (int i = 0; i < ticks; ++i) {
            result[i] = min + interval * (double)(i + 1);
        }
        return result;
    }

    public static Object[] autoTimeTick(Date ts, Date te, int ticks) {
        return SmartTick.autoTimeTick(Util.dateToJ2K(ts), Util.dateToJ2K(te), ticks);
    }

    public static Object[] autoTimeTick(double ts, double te, int ticks) {
        int ti = -1;
        long mindt = Integer.MAX_VALUE;
        for (int i = 0; i < tickers.length; ++i) {
            if (Math.abs(tickers[i].numTicks(ts, te) - (long)ticks) >= mindt) continue;
            ti = i;
            mindt = Math.abs(tickers[i].numTicks(ts, te) - (long)ticks);
        }
        return tickers[ti].getTicks(ts, te);
    }

    private static void setLabelFormatString(Class<?> c, String s) {
        for (TimeTicker t : tickers) {
            if (!t.getClass().equals(c)) continue;
            t.setLabelFormatString(s);
        }
    }

    public static void setMonthTickerLabelFormatString(String s) {
        SmartTick.setLabelFormatString(MonthTicker.class, s);
    }

    private static class MillisecondTicker
    extends TimeTicker {
        public MillisecondTicker(long m) {
            super((double)m / 1000.0);
            this.setLabelFormatString("HH:mm:ss.SSS");
        }
    }

    private static class SecondTicker
    extends TimeTicker {
        public SecondTicker(int s) {
            super(s);
            this.setLabelFormatString("HH:mm:ss");
        }
    }

    private static class MinuteTicker
    extends TimeTicker {
        public MinuteTicker(int m) {
            super(m * 60);
            this.setLabelFormatString("HH:mm");
        }
    }

    private static class HourTicker
    extends TimeTicker {
        public HourTicker(int h) {
            super(h * 60 * 60);
            this.setLabelFormatString("HH:mm");
        }
    }

    private static class DayTicker
    extends TimeTicker {
        private int days;
        private Calendar cal;

        public DayTicker(int d) {
            super(d * 60 * 60 * 24);
            this.days = d;
            this.setLabelFormatString("MM/dd");
        }

        @Override
        public synchronized double getMinTick(double ts) {
            Date d = Util.j2KToDate(ts);
            this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            this.cal.setTime(d);
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.cal.set(14, 0);
            this.cal.add(5, 1);
            return Util.dateToJ2K(this.cal.getTime());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long numTicks(double ts, double te) {
            double minTick = this.getMinTick(ts);
            int numTicks = 0;
            DayTicker dayTicker = this;
            synchronized (dayTicker) {
                this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                this.cal.setTime(Util.j2KToDate(minTick));
                while (Util.dateToJ2K(this.cal.getTime()) < te) {
                    this.cal.add(6, this.days);
                    ++numTicks;
                }
            }
            return numTicks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] getTicks(double ts, double te) {
            int nt = (int)this.numTicks(ts, te);
            double[] ticks = new double[nt];
            String[] labels = new String[nt];
            double minTick = this.getMinTick(ts);
            DayTicker dayTicker = this;
            synchronized (dayTicker) {
                this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                this.cal.setTime(Util.j2KToDate(minTick));
                for (int i = 0; i < nt; ++i) {
                    ticks[i] = Util.dateToJ2K(this.cal.getTime());
                    labels[i] = this.dateFormat.format(this.cal.getTime());
                    this.cal.add(6, this.days);
                }
            }
            return new Object[]{ticks, labels};
        }
    }

    private static class MonthTicker
    extends TimeTicker {
        private int months;
        private Calendar cal;

        public MonthTicker(int m) {
            super(m * 30 * 24 * 60 * 60);
            this.months = m;
            this.setLabelFormatString("MMM-yyyy");
        }

        @Override
        public synchronized double getMinTick(double ts) {
            Date d = Util.j2KToDate(ts);
            this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            this.cal.setTime(d);
            this.cal.set(5, 1);
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.cal.set(14, 0);
            this.cal.add(2, 1);
            return Util.dateToJ2K(this.cal.getTime());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long numTicks(double ts, double te) {
            double minTick = this.getMinTick(ts);
            int numTicks = 0;
            MonthTicker monthTicker = this;
            synchronized (monthTicker) {
                this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                this.cal.setTime(Util.j2KToDate(minTick));
                while (Util.dateToJ2K(this.cal.getTime()) < te) {
                    this.cal.add(2, this.months);
                    ++numTicks;
                }
            }
            return numTicks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] getTicks(double ts, double te) {
            int nt = (int)this.numTicks(ts, te);
            double[] ticks = new double[nt];
            String[] labels = new String[nt];
            double minTick = this.getMinTick(ts);
            MonthTicker monthTicker = this;
            synchronized (monthTicker) {
                this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                this.cal.setTime(Util.j2KToDate(minTick));
                for (int i = 0; i < nt; ++i) {
                    ticks[i] = Util.dateToJ2K(this.cal.getTime());
                    labels[i] = this.dateFormat.format(this.cal.getTime());
                    this.cal.add(2, this.months);
                }
            }
            return new Object[]{ticks, labels};
        }
    }

    private static class YearTicker
    extends TimeTicker {
        private int years;
        private Calendar cal;

        public YearTicker(int y) {
            super((double)y * 365.24 * 24.0 * 60.0 * 60.0);
            this.years = y;
            this.setLabelFormatString("yyyy");
        }

        @Override
        public synchronized double getMinTick(double ts) {
            Date d = Util.j2KToDate(ts);
            this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            this.cal.setTime(d);
            this.cal.set(2, 0);
            this.cal.set(5, 1);
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.cal.set(14, 0);
            this.cal.add(1, 1);
            return Util.dateToJ2K(this.cal.getTime());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long numTicks(double ts, double te) {
            double minTick = this.getMinTick(ts);
            int numTicks = 0;
            YearTicker yearTicker = this;
            synchronized (yearTicker) {
                this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                this.cal.setTime(Util.j2KToDate(minTick));
                while (Util.dateToJ2K(this.cal.getTime()) < te) {
                    this.cal.add(1, this.years);
                    ++numTicks;
                }
            }
            return numTicks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] getTicks(double ts, double te) {
            int nt = (int)this.numTicks(ts, te);
            double[] ticks = new double[nt];
            String[] labels = new String[nt];
            double minTick = this.getMinTick(ts);
            YearTicker yearTicker = this;
            synchronized (yearTicker) {
                this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                this.cal.setTime(Util.j2KToDate(minTick));
                for (int i = 0; i < nt; ++i) {
                    ticks[i] = Util.dateToJ2K(this.cal.getTime());
                    labels[i] = this.dateFormat.format(this.cal.getTime());
                    this.cal.add(1, this.years);
                }
            }
            return new Object[]{ticks, labels};
        }
    }

    private static abstract class TimeTicker {
        protected double interval;
        protected SimpleDateFormat dateFormat;
        protected String labelFormatString;

        public TimeTicker(double i) {
            this.interval = i;
        }

        public void setLabelFormatString(String s) {
            this.labelFormatString = s;
            this.dateFormat = new SimpleDateFormat(this.labelFormatString);
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        public long numTicks(double ts, double te) {
            return Math.round((this.getMaxTick(te) - this.getMinTick(ts)) / this.interval) + 1L;
        }

        public double getMinTick(double ts) {
            return Math.ceil(ts / this.interval) * this.interval;
        }

        public double getMaxTick(double te) {
            return Math.floor(te / this.interval) * this.interval;
        }

        public Object[] getTicks(double ts, double te) {
            double minTick = this.getMinTick(ts);
            int nt = (int)this.numTicks(ts, te);
            double[] ticks = new double[nt];
            String[] labels = new String[nt];
            for (int i = 0; i < nt; ++i) {
                ticks[i] = minTick + (double)i * this.interval;
                labels[i] = this.dateFormat.format(Util.j2KToDate(ticks[i]));
            }
            return new Object[]{ticks, labels};
        }

        public String toString() {
            return this.getClass().getName() + ", interval: " + this.interval;
        }
    }
}

