/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.core.args.decorator;

import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Switch;
import gov.usgs.volcanoes.core.args.ArgsDecorator;
import gov.usgs.volcanoes.core.args.ArgumentException;
import gov.usgs.volcanoes.core.args.Arguments;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;

public class CreateConfigArg
extends ArgsDecorator {
    private final String exampleConfigFile;

    public CreateConfigArg(String exampleConfigFile, Arguments nextArg) throws ArgumentException {
        super(nextArg);
        this.exampleConfigFile = exampleConfigFile;
        nextArg.registerParameter(new Switch("create-config", 'c', "create-config", "Create an example config file in the curent working directory."));
        if (nextArg.getById("config-filename") == null) {
            throw new ArgumentException("CreateConfigArg relies on ConfigFileArg. Please wrap it first.");
        }
    }

    @Override
    public JSAPResult parse(String[] args) throws ArgumentException {
        JSAPResult jsap = super.parse(args);
        String configFileName = jsap.getString("config-filename");
        if (jsap.getBoolean("create-config")) {
            InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream(this.exampleConfigFile);
            Path defaultPath = new File(configFileName).toPath();
            try {
                Files.copy(is, defaultPath, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new ArgumentException(e);
            }
        }
        return jsap;
    }
}

