/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.core.args.decorator;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.ParseException;
import gov.usgs.volcanoes.core.args.ArgsDecorator;
import gov.usgs.volcanoes.core.args.ArgumentException;
import gov.usgs.volcanoes.core.args.Arguments;
import gov.usgs.volcanoes.core.args.parser.DateStringParser;
import java.util.Date;

public class DateRangeArg
extends ArgsDecorator {
    public DateRangeArg(String dateFormat, Arguments nextArg) throws ArgumentException {
        super(nextArg);
        DateStringParser dateParser = new DateStringParser(dateFormat);
        nextArg.registerParameter(new FlaggedOption("startTime", dateParser, JSAP.NO_DEFAULT, false, 's', "startTime", String.format("start time as %s\n", dateFormat)));
        nextArg.registerParameter(new FlaggedOption("endTime", dateParser, JSAP.NO_DEFAULT, false, 'e', "endTime", String.format("end time as %s\n", dateFormat)));
    }

    @Override
    public JSAPResult parse(String[] args) throws ArgumentException {
        JSAPResult jsap = super.parse(args);
        try {
            this.validateDates(jsap.getDate("startTime"), jsap.getDate("endTime"));
        }
        catch (ParseException e) {
            throw new ArgumentException(e);
        }
        return jsap;
    }

    private void validateDates(Date startTime, Date endTime) throws ParseException {
        if (startTime != null && endTime == null) {
            throw new ParseException("endTime must be specified if startTime is specified");
        }
        if (endTime != null && startTime == null) {
            throw new ParseException("startTime must be specified if endTime is specified");
        }
        if (endTime != null && !endTime.after(startTime)) {
            throw new ParseException("endTime must be greater than startTime." + endTime + ":" + startTime);
        }
    }
}

