/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.core.time;

import gov.usgs.volcanoes.core.time.CurrentTime;
import gov.usgs.volcanoes.core.time.Time;
import java.text.ParseException;
import java.util.Date;

public class Ew {
    public static Date asDate(double ew) {
        return new Date(Ew.asEpoch(ew));
    }

    public static double fromDate(Date date) {
        return Ew.fromEpoch(date.getTime());
    }

    public static long asEpoch(double ew) {
        return (long)ew * 1000L;
    }

    public static double fromEpoch(Long date) {
        return (double)date.longValue() / 1000.0;
    }

    public static synchronized String format(String format, double ew) {
        return Time.format(format, Ew.asDate(ew));
    }

    public static String toDateString(double ew) {
        return Ew.format("yyyy-MM-dd HH:mm:ss", ew);
    }

    public static synchronized double parse(String format, String date) throws ParseException {
        return Ew.fromDate(Time.getFormat(format).parse(date));
    }

    public static double now() {
        return Ew.fromEpoch(CurrentTime.getInstance().now());
    }

    private Ew() {
    }
}

