/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.pensive;

import gov.usgs.plot.data.SliceWave;
import gov.usgs.plot.data.Wave;
import gov.usgs.plot.render.Renderer;
import gov.usgs.volcanoes.core.configfile.ConfigFile;
import gov.usgs.volcanoes.core.time.J2kSec;
import gov.usgs.volcanoes.core.time.Time;
import gov.usgs.volcanoes.pensive.plot.ChannelPlotter;
import gov.usgs.volcanoes.pensive.plot.FullPlotter;
import gov.usgs.volcanoes.pensive.plot.ThumbnailPlotter;
import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import java.awt.Dimension;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channel {
    private static final Logger LOGGER = LoggerFactory.getLogger(Channel.class);
    public static final boolean DEFAULT_WRITE_DATA = false;
    public static final String DEFAULT_DATA_FILE_SUFFIX_FORMAT = "_yyyyMMdd";
    public static final String DEFAULT_DATA_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public final String name;
    private final ChannelPlotter plot;
    private final ChannelPlotter thumb;
    private final boolean writeData;
    private final String dataFilePathFormat;
    private final String dataFileSuffixFormat;
    private final String dataPathRoot;
    private final String networkName;
    private final String subnetName;
    private final String dataTimestampFormat;

    public Channel(String channel, int index, Dimension plotDimension, Dimension thumbDimension, boolean decorateX, ConfigFile config, String networkName, String subnetName) {
        this.name = channel;
        this.plot = new FullPlotter(channel, index, plotDimension, decorateX, config);
        this.thumb = new ThumbnailPlotter(channel, index, thumbDimension, config);
        this.writeData = config.getBoolean("writeData", false);
        this.dataFilePathFormat = config.getString("dataFilePathFormat", config.getString("filePathFormat"));
        this.dataFileSuffixFormat = config.getString("dataFileSuffixFormat", DEFAULT_DATA_FILE_SUFFIX_FORMAT);
        this.dataPathRoot = config.getString("dataPathRoot", config.getString("pathRoot"));
        this.dataTimestampFormat = config.getString("dataTimestampFormat", DEFAULT_DATA_TIMESTAMP_FORMAT);
        this.networkName = networkName;
        this.subnetName = subnetName;
    }

    public void updateWave(long plotEndMs, SeismicDataSource dataSource) {
        double t2 = J2kSec.fromEpoch(plotEndMs);
        double t1 = t2 - 600.0;
        Wave w = dataSource.getWave(this.name.replace('_', ' '), t1, t2);
        if (w != null && w.numSamples() > 0) {
            w.detrend();
            w.removeMean();
            SliceWave wave = new SliceWave(w);
            wave.setSlice(t1, t2);
            this.plot.setWave(wave);
            wave = new SliceWave(w);
            wave.setSlice(t1, t2);
            this.thumb.setWave(wave);
        } else {
            this.plot.setWave(null);
            this.thumb.setWave(null);
        }
    }

    public Renderer plot() {
        if (this.writeData) {
            this.writeData();
        }
        return this.plot.plot();
    }

    private void writeData() {
        String csv = this.plot.getCsv(this.dataTimestampFormat);
        if (csv == null) {
            return;
        }
        String fileBase = this.generateFileBase(this.plot.getPlotEndMs());
        File file = new File(fileBase);
        file.getParentFile().mkdirs();
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file, true);
            fw.append(csv);
            fw.close();
        }
        catch (IOException e) {
            LOGGER.error("Error writing file. {}", e);
        }
    }

    private String generateFileBase(long timeMs) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.dataPathRoot + '/');
        if (this.networkName != null) {
            sb.append(this.networkName + '/');
        }
        sb.append(this.subnetName + '/');
        sb.append(Time.format(this.dataFilePathFormat, timeMs));
        sb.append('/' + this.name);
        sb.append(Time.format(this.dataFileSuffixFormat, timeMs));
        sb.append(".dat");
        String name = sb.toString();
        name = name.replaceAll("/+", Matcher.quoteReplacement(File.separator));
        name = name.replaceAll("\\s+", "_");
        return name;
    }

    public Renderer plotThumb() {
        return this.thumb.plot();
    }

    public void flushWave() {
        this.plot.setWave(null);
        this.thumb.setWave(null);
    }
}

