/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.pensive;

import gov.usgs.volcanoes.pensive.plot.SubnetPlotter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotJob
implements Comparable<PlotJob> {
    public final long plotEndMs;
    public final long plotTimeMs;
    public final SubnetPlotter subnet;

    public PlotJob(SubnetPlotter subnet) {
        this.subnet = subnet;
        this.plotEndMs = this.findPlotEnd();
        this.plotTimeMs = this.plotEndMs + (long)subnet.embargoMs;
    }

    public PlotJob(SubnetPlotter subnet, long plotEndMs) {
        this.subnet = subnet;
        this.plotEndMs = plotEndMs;
        this.plotTimeMs = plotEndMs + (long)subnet.embargoMs;
    }

    private long findPlotEnd() {
        long startTime = System.currentTimeMillis();
        startTime -= startTime % 600000L;
        return startTime;
    }

    @Override
    public int compareTo(PlotJob other) {
        return (int)(this.plotTimeMs - other.plotTimeMs);
    }
}

