/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.pensive.schedule;

import gov.usgs.volcanoes.core.configfile.ConfigFile;
import gov.usgs.volcanoes.pensive.PlotJob;
import gov.usgs.volcanoes.pensive.WaveSource;
import gov.usgs.volcanoes.pensive.plot.SubnetPlotter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlotScheduler
implements Runnable {
    protected static final Logger LOGGER = LoggerFactory.getLogger("gov.usgs");
    public static final int DEFAULT_NUMTHREADS = 5;
    private List<WaveSource> waveSources;
    private final List<Thread> threads;
    protected final BlockingQueue<PlotJob> plotJobs;
    protected final List<SubnetPlotter> subnets;
    private final int numThreads;
    public final String name;
    private final ConfigFile config;

    protected abstract void schedulePlots();

    public AbstractPlotScheduler(String name, ConfigFile config) {
        this.name = name;
        this.numThreads = config.getInt("threads", 5);
        this.subnets = new LinkedList<SubnetPlotter>();
        this.plotJobs = new PriorityBlockingQueue<PlotJob>();
        this.threads = new LinkedList<Thread>();
        this.config = config;
    }

    public void startWaveSources() {
        this.waveSources = new ArrayList<WaveSource>();
        for (int i = 0; i < this.numThreads; ++i) {
            String n = this.name + "-" + i;
            WaveSource ws = new WaveSource(n, this.plotJobs, this.config);
            this.waveSources.add(ws);
            Thread t = new Thread(ws);
            t.setName(n);
            t.start();
            this.threads.add(t);
        }
    }

    public void add(SubnetPlotter subnet) {
        this.subnets.add(subnet);
    }

    public int subnetCount() {
        return this.subnets.size();
    }

    public void stop() {
        for (WaveSource ws : this.waveSources) {
            ws.stop();
        }
    }

    public void run() {
        try {
            LOGGER.info("Scheduling plots for " + this.name);
            this.schedulePlots();
        }
        catch (Exception e) {
            LOGGER.error("Caught exception heading for scheduler. " + e.getLocalizedMessage());
        }
    }
}

