/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm;

import gov.usgs.volcanoes.swarm.GroupsType;
import gov.usgs.volcanoes.swarm.IChannelInfo;
import gov.usgs.volcanoes.swarm.Metadata;
import gov.usgs.volcanoes.swarm.SwarmConfig;
import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelUtil {
    public static final String EMPTY = "";
    private static final Map<IChannelInfo, List<String>> groupsMap = new HashMap<IChannelInfo, List<String>>();

    public static String addChannel(List<String> channels, IChannelInfo ch, SeismicDataSource source) {
        String formattedScnl = ch.getFormattedSCNL();
        if (!channels.contains(formattedScnl)) {
            Metadata md = SwarmConfig.getInstance().getMetadata(formattedScnl, true);
            md.updateLongitude(ch.getLongitude());
            md.updateLatitude(ch.getLatitude());
            for (String g : ch.getGroups()) {
                md.addGroup(g);
            }
            if (ch.getStation() != ch.getSiteName() && ch.getSiteName() != null) {
                md.updateAlias(ch.getSiteName());
            }
            md.source = source;
            channels.add(formattedScnl);
        }
        return formattedScnl;
    }

    public static void assignChannels(List<String> channels, SeismicDataSource source) {
        Collections.sort(channels);
        SwarmConfig.getInstance().assignMetadataSource(channels, source);
    }

    public static final String getFormattedSCNL(String station, String channel, String network, String location) {
        return station + " " + channel + " " + network + (location.length() > 0 ? " " + location : EMPTY);
    }

    public static final String getGroup(IChannelInfo ch, GroupsType groupsType) {
        switch (groupsType) {
            case SITE: {
                return ChannelUtil.getSiteName(ch);
            }
            case NETWORK: {
                return "Networks^" + ch.getNetwork();
            }
            case NETWORK_AND_SITE: {
                return "Networks^" + ch.getNetwork() + "^" + ChannelUtil.getSiteName(ch);
            }
        }
        return null;
    }

    public static final List<String> getGroups(IChannelInfo ch, GroupsType groupsType) {
        List<String> groups = groupsMap.get(ch);
        if (groups == null) {
            groups = new ArrayList<String>(1);
            String group = ChannelUtil.getGroup(ch, groupsType);
            if (group != null) {
                groups.add(group);
            }
            groupsMap.put(ch, groups);
        }
        return groups;
    }

    public static final String getSiteName(IChannelInfo ch) {
        String s = ch.getSiteName();
        if (s == null) {
            s = ch.getStation();
        }
        return s;
    }
}

