/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import gov.usgs.volcanoes.swarm.Swarm;
import gov.usgs.volcanoes.swarm.SwarmConfig;
import gov.usgs.volcanoes.swarm.SwingWorker;
import gov.usgs.volcanoes.swarm.chooser.DataChooser;
import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import gov.usgs.volcanoes.swarm.heli.HelicorderViewerFrame;
import gov.usgs.volcanoes.swarm.internalFrame.SwarmInternalFrames;
import gov.usgs.volcanoes.swarm.map.MapFrame;
import gov.usgs.volcanoes.swarm.wave.MultiMonitor;
import gov.usgs.volcanoes.swarm.wave.SwarmMultiMonitors;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwarmLayout
implements Comparable<SwarmLayout> {
    private static final JFrame applicationFrame = Swarm.getApplicationFrame();
    private ConfigFile config;

    public SwarmLayout(ConfigFile c) {
        this.config = c;
    }

    public static SwarmLayout createSwarmLayout(String fn) {
        ConfigFile cf = new ConfigFile(fn);
        if (cf == null || !cf.wasSuccessfullyRead()) {
            return null;
        }
        String name = cf.getString("name");
        if (name == null) {
            return null;
        }
        return new SwarmLayout(cf);
    }

    public void save() {
        String fn = this.getName().replace(' ', '_');
        String n = fn.replaceAll("[^a-zA-Z0-9_]", "");
        String pre = "layouts" + File.separatorChar;
        String post = ".config";
        fn = pre + n + post;
        boolean exists = new File(fn).exists();
        int i = 0;
        while (exists) {
            fn = pre + n + "_" + ++i + post;
            exists = new File(fn).exists();
        }
        this.config.writeToFile(fn);
    }

    public void delete() {
        try {
            String fn = this.config.getName() + ".config";
            Log.getLogger("gov.usgs.swarm").fine("deleting file: " + fn);
            new File(fn).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setName(String s) {
        this.config.put("name", s, false);
    }

    public String getName() {
        return this.config.getString("name");
    }

    public void process() {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                SwarmInternalFrames.removeAllFrames();
                SwarmLayout.this.processChooser();
                SwarmLayout.this.processMap();
                SwarmLayout.this.processWaves();
                SwarmLayout.this.processHelicorders();
                SwarmLayout.this.processMonitors();
                return null;
            }

            public void finished() {
                SwarmLayout.this.processKiosk();
            }
        };
        worker.start();
    }

    private void processChooser() {
        ConfigFile cf = this.config.getSubConfig("chooser");
        ChooserListener cl = new ChooserListener();
        List<String> sources = cf.getList("source");
        if (sources != null) {
            for (String src : sources) {
                cl.addSource(src);
            }
            DataChooser.getInstance().processLayout(cf, cl);
            while (!cl.finished()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void processWaves() {
    }

    private void processMap() {
        ConfigFile cf = this.config.getSubConfig("map");
        MapFrame mapFrame = MapFrame.getInstance();
        if (cf.getString("x") != null) {
            mapFrame.setVisible(true);
            mapFrame.processLayout(cf);
        } else {
            mapFrame.setVisible(false);
        }
    }

    private void processMonitors() {
        List<String> monitors = this.config.getList("monitor");
        if (monitors == null) {
            return;
        }
        for (String monitor : monitors) {
            ConfigFile cf = this.config.getSubConfig(monitor);
            SeismicDataSource sds = SwarmConfig.getInstance().getSource(cf.getString("source"));
            if (sds == null || !DataChooser.getInstance().isSourceOpened(sds.getName())) continue;
            MultiMonitor mm = SwarmMultiMonitors.getMonitor(sds);
            mm.processLayout(cf);
            mm.setVisible(true);
        }
    }

    private void processHelicorders() {
        List<String> helis = this.config.getList("helicorder");
        if (helis == null) {
            return;
        }
        for (String heli : helis) {
            ConfigFile cf = this.config.getSubConfig(heli);
            SeismicDataSource sds = SwarmConfig.getInstance().getSource(cf.getString("source"));
            if (sds == null) continue;
            HelicorderViewerFrame hvf = new HelicorderViewerFrame(cf);
            hvf.addLinkListeners();
            SwarmInternalFrames.add(hvf, false);
        }
    }

    private void processKiosk() {
        String k = this.config.getString("kiosk");
        if (k == null) {
            k = "false";
        }
        int x = Util.stringToInt(this.config.getString("kioskX"), -1);
        int y = Util.stringToInt(this.config.getString("kioskY"), -1);
        boolean kiosk = Boolean.parseBoolean(k);
        if (kiosk && x != -1 && y != -1) {
            applicationFrame.setLocation(x, y);
        }
        Swarm.getApplication().setFullScreenMode(kiosk);
    }

    @Override
    public int compareTo(SwarmLayout o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    private class ChooserListener
    implements ActionListener {
        private List<String> sources = new ArrayList<String>();

        private ChooserListener() {
        }

        public void addSource(String s) {
            this.sources.add(s);
        }

        public synchronized void actionPerformed(ActionEvent e) {
            String src = e.getActionCommand();
            this.sources.remove(src);
            if (e.getID() == -1) {
                JOptionPane.showMessageDialog(applicationFrame, "The data source '" + src + "' does not exist.", "Error", 0);
            } else if (e.getID() == -2) {
                JOptionPane.showMessageDialog(applicationFrame, "The data source '" + src + "' could not be opened.", "Error", 0);
            }
        }

        public synchronized boolean finished() {
            return this.sources.size() == 0;
        }
    }
}

