/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.chooser;

import gov.usgs.volcanoes.swarm.Swarm;
import gov.usgs.volcanoes.swarm.SwarmConfig;
import gov.usgs.volcanoes.swarm.SwarmDialog;
import gov.usgs.volcanoes.swarm.chooser.DataSourcePanel;
import gov.usgs.volcanoes.swarm.chooser.SeedLinkPanel;
import gov.usgs.volcanoes.swarm.chooser.WWSPanel;
import gov.usgs.volcanoes.swarm.chooser.WaveServerPanel;
import gov.usgs.volcanoes.swarm.chooser.WebServicesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class EditDataSourceDialog
extends SwarmDialog {
    private static final long serialVersionUID = 1L;
    private static final JFrame applicationFrame = Swarm.getApplicationFrame();
    private String source;
    private boolean edit;
    private JTextField name;
    private JTabbedPane tabPane;
    private List<DataSourcePanel> panels;
    private String result;

    public EditDataSourceDialog(String s) {
        super(applicationFrame, "", true);
        this.createPanels();
        this.source = s;
        if (this.source == null) {
            this.setTitle("New Data Source");
            this.edit = false;
        } else {
            this.setTitle("Edit Data Source");
            this.edit = true;
        }
        this.createDataSourceUI();
        this.setSizeAndLocation();
    }

    private void createPanels() {
        this.panels = new ArrayList<DataSourcePanel>();
        this.panels.add(new WWSPanel());
        this.panels.add(new WaveServerPanel());
        this.panels.add(new WebServicesPanel());
        this.panels.add(new SeedLinkPanel());
    }

    protected void createDataSourceUI() {
        JPanel dsPanel = new JPanel(new BorderLayout());
        String src = null;
        if (this.source != null) {
            src = this.source.substring(this.source.indexOf(59) + 1, this.source.indexOf(58));
        }
        this.tabPane = new JTabbedPane();
        for (DataSourcePanel dsp : this.panels) {
            dsp.setSource(this.source);
            JPanel p = dsp.getPanel();
            this.tabPane.add(dsp.getName(), p);
            if (src == null || !src.equals(dsp.getCode())) continue;
            this.tabPane.setSelectedComponent(p);
        }
        dsPanel.add((Component)this.tabPane, "Center");
        Box namePanel = new Box(0);
        namePanel.add(new JLabel("Data Source Name:"));
        namePanel.add(Box.createHorizontalStrut(10));
        String n = "";
        if (this.source != null) {
            n = this.source.substring(0, this.source.indexOf(59));
        }
        this.name = new JTextField(30);
        namePanel.add(this.name);
        this.name.setText(n);
        dsPanel.add((Component)namePanel, "North");
        dsPanel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.mainPanel.add((Component)dsPanel, "Center");
    }

    public void resetSource(String src) {
        if (src != null) {
            this.source = src;
            String s = this.source.substring(this.source.indexOf(59) + 1, this.source.indexOf(58));
            for (DataSourcePanel dsp : this.panels) {
                dsp.resetSource(this.source);
                JPanel p = dsp.getPanel();
                if (!s.equals(dsp.getCode())) continue;
                this.tabPane.setSelectedComponent(p);
            }
            this.name.setText(this.source.substring(0, this.source.indexOf(59)));
        }
    }

    protected boolean allowOK() {
        String n = this.name.getText();
        String message = null;
        if (n == null || n.length() <= 0) {
            message = "You must specify a name for this data source.";
        } else if (!this.edit && SwarmConfig.getInstance().sourceExists(n)) {
            message = "A data source by that name already exists.";
        }
        if (message != null) {
            JOptionPane.showMessageDialog(applicationFrame, message, "Error", 0);
            return false;
        }
        DataSourcePanel p = this.panels.get(this.tabPane.getSelectedIndex());
        return p.allowOK(this.edit);
    }

    public void setVisible(boolean b) {
        if (b) {
            if (this.source == null) {
                this.name.setText("");
            }
            this.result = null;
        }
        super.setVisible(b);
    }

    protected void wasOK() {
        DataSourcePanel p = this.panels.get(this.tabPane.getSelectedIndex());
        this.result = this.name.getText() + ";" + p.wasOK();
    }

    public String getResult() {
        return this.result;
    }
}

