/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.chooser;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.volcanoes.swarm.chooser.DataSourcePanel;
import gov.usgs.volcanoes.swarm.data.DataSourceType;
import gov.usgs.volcanoes.swarm.data.seedLink.SeedLinkSource;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class SeedLinkPanel
extends DataSourcePanel {
    private static final String codeText = ";" + DataSourceType.getShortName(SeedLinkSource.class) + ":";
    private static final String defaultHost = "";
    private static final String defaultPort = "18000";
    private JComboBox slsHost;
    private JTextField slsPort;

    public SeedLinkPanel() {
        super(DataSourceType.getShortName(SeedLinkSource.class), "SeedLink Server");
    }

    public boolean allowOK(boolean edit) {
        String host = this.getHost();
        String message = null;
        if (host == null || host.length() == 0 || host.indexOf(59) != -1 || host.indexOf(58) != -1) {
            message = "There is an error with the " + this.getName() + " IP address or host name.";
        }
        int ip = -1;
        try {
            ip = Integer.parseInt(this.slsPort.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ip < 0 || ip > 65535) {
            message = "There is an error with the " + this.getName() + " port.";
        }
        if (message != null) {
            JOptionPane.showMessageDialog(applicationFrame, message, "Error", 0);
            return false;
        }
        return true;
    }

    protected void createFields() {
        int index;
        String[] hosts = new String[]{"geofon.gfz-potsdam.de", "rtserve.iris.washington.edu"};
        this.slsHost = new JComboBox<String>(hosts);
        this.slsHost.setEditable(true);
        this.slsPort = new JTextField();
        String h = defaultHost;
        String p = defaultPort;
        if (this.source != null && (index = this.source.indexOf(codeText)) != -1) {
            String[] ss = this.source.substring(index + codeText.length()).split(":");
            int ssIndex = 0;
            h = ss[ssIndex++];
            p = ss[ssIndex++];
        }
        this.setHost(h);
        this.slsPort.setText(p);
    }

    protected void createPanel() {
        this.createFields();
        FormLayout layout = new FormLayout("right:max(20dlu;pref), 3dlu, 40dlu, 0dlu, 126dlu", defaultHost);
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)new JLabel("Use this data source to connect to a SeedLink Server."), 5);
        builder.nextLine();
        builder.appendSeparator();
        builder.append("IP Address or Host Name:");
        builder.append((Component)this.slsHost, 3);
        builder.nextLine();
        builder.append("Port:");
        builder.append((Component)this.slsPort);
        builder.append(" SeedLink default: 18000");
        builder.nextLine();
        this.panel = builder.getPanel();
    }

    protected String getHost() {
        return (String)this.slsHost.getSelectedItem();
    }

    protected void setHost(String h) {
        this.slsHost.setSelectedItem(h);
    }

    public String wasOK() {
        String result = String.format(this.getCode() + ":%s:%s", this.getHost(), this.slsPort.getText());
        return result;
    }
}

