/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.chooser;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.volcanoes.swarm.Swarm;
import gov.usgs.volcanoes.swarm.SwarmConfig;
import gov.usgs.volcanoes.swarm.chooser.DataSourcePanel;
import gov.usgs.volcanoes.swarm.data.fdsnWs.WebServiceStationXmlClient;
import gov.usgs.volcanoes.swarm.data.fdsnWs.WebServicesSource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class WebServicesPanel
extends DataSourcePanel {
    private static final String WS_NETWORK_FILE = "IRIS_networks.txt";
    private static final String codeText = ";" + WebServicesSource.typeString + ":";
    private JComboBox<String> network;
    private JTextField station;
    private JTextField location;
    private JTextField channel;
    private JTextField gulperSize;
    private JTextField gulperDelay;
    private JTextField wsDataselectUrlField;
    private JTextField wsStationUrlField;
    private JButton updateNetworkList;
    private String currentStationURL = "";

    public WebServicesPanel() {
        super(WebServicesSource.typeString, "FDSN WS");
    }

    public boolean allowOK(boolean edit) {
        String message = null;
        double gs = -1.0;
        try {
            gs = Double.parseDouble(this.gulperSize.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (gs <= 0.0) {
            message = "The gulper size must be greater than 0 minutes.";
        }
        double gd = -1.0;
        try {
            gd = Double.parseDouble(this.gulperDelay.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (gd < 0.0) {
            message = "The gulper delay must be greater than or equal to 0 seconds.";
        }
        if (message != null) {
            JOptionPane.showMessageDialog(applicationFrame, message, "Error", 0);
            return false;
        }
        return true;
    }

    protected void createFields() {
        int index;
        this.network = new JComboBox();
        this.network.setEditable(true);
        this.network.addItem("---Need Update---");
        this.station = new JTextField();
        this.location = new JTextField();
        this.channel = new JTextField();
        this.gulperSize = new JTextField();
        this.gulperDelay = new JTextField();
        this.wsDataselectUrlField = new JTextField();
        this.wsStationUrlField = new JTextField();
        this.wsStationUrlField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                String s = WebServicesPanel.this.getText(WebServicesPanel.this.wsStationUrlField);
                if (WebServicesPanel.this.currentStationURL.compareTo(s) != 0) {
                    WebServicesPanel.this.showNeedUpdate();
                }
            }

            public void removeUpdate(DocumentEvent e) {
                String s = WebServicesPanel.this.getText(WebServicesPanel.this.wsStationUrlField);
                if (WebServicesPanel.this.currentStationURL.compareTo(s) != 0) {
                    WebServicesPanel.this.showNeedUpdate();
                }
            }

            public void insertUpdate(DocumentEvent e) {
                String s = WebServicesPanel.this.getText(WebServicesPanel.this.wsStationUrlField);
                if (WebServicesPanel.this.currentStationURL.compareTo(s) != 0) {
                    WebServicesPanel.this.showNeedUpdate();
                }
            }
        });
        String net = "";
        String sta = "";
        String loc = "";
        String chan = "";
        String gs = "60";
        String gd = "1.0";
        String wsDataSelectUrl = this.getDefaultText(this.wsDataselectUrlField);
        String wsStationUrl = this.getDefaultText(this.wsStationUrlField);
        if (this.source != null && (index = this.source.indexOf(codeText)) != -1) {
            String[] ss = this.source.substring(index + codeText.length()).split("\\|");
            int ssIndex = 0;
            net = ss[ssIndex++];
            sta = ss[ssIndex++];
            loc = ss[ssIndex++];
            chan = ss[ssIndex++];
            gs = String.format("%.0f", (double)Integer.parseInt(ss[ssIndex++]) / 60.0);
            gd = String.format("%.1f", (double)Integer.parseInt(ss[ssIndex++]) / 1000.0);
            wsDataSelectUrl = ss[ssIndex++];
            wsStationUrl = ss[ssIndex++];
        }
        this.selectNetwork(net);
        this.station.setText(sta);
        this.location.setText(loc);
        this.channel.setText(chan);
        this.gulperSize.setText(gs);
        this.gulperDelay.setText(gd);
        this.wsDataselectUrlField.setText(wsDataSelectUrl);
        this.wsStationUrlField.setText(wsStationUrl);
        this.updateNetworkList = new JButton("Update");
        this.updateNetworkList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebServicesPanel.this.getWebServicesNetworks();
            }
        });
    }

    public void resetSource(String src) {
        if (src != null && (this.source == null || src.compareTo(this.source) != 0)) {
            int index;
            this.source = src;
            String net = "IU";
            String sta = "";
            String loc = "";
            String chan = "";
            String gs = "60";
            String gd = "1.0";
            String wsDataSelectUrl = this.getDefaultText(this.wsDataselectUrlField);
            String wsStationUrl = this.getDefaultText(this.wsStationUrlField);
            if (this.source != null && (index = this.source.indexOf(codeText)) != -1) {
                String[] ss = this.source.substring(index + codeText.length()).split("\\|");
                int ssIndex = 0;
                net = ss[ssIndex++];
                sta = ss[ssIndex++];
                loc = ss[ssIndex++];
                chan = ss[ssIndex++];
                gs = String.format("%.0f", (double)Integer.parseInt(ss[ssIndex++]) / 60.0);
                gd = String.format("%.1f", (double)Integer.parseInt(ss[ssIndex++]) / 1000.0);
                wsDataSelectUrl = ss[ssIndex++];
                wsStationUrl = ss[ssIndex++];
            }
            this.selectNetwork(net);
            this.station.setText(sta);
            this.location.setText(loc);
            this.channel.setText(chan);
            this.gulperSize.setText(gs);
            this.gulperDelay.setText(gd);
            this.wsDataselectUrlField.setText(wsDataSelectUrl);
            this.wsStationUrlField.setText(wsStationUrl);
        }
    }

    protected void createPanel() {
        this.createFields();
        FormLayout layout = new FormLayout("right:max(10dlu;pref), 3dlu, right:max(20dlu;pref), 3dlu, 40dlu, 0dlu, 45dlu, 3dlu, right:max(20dlu;pref), 3dlu, 40dlu, 0dlu, 40dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)new JLabel("Use this data source to connect to an FDSN Web Services server."), 11);
        builder.nextLine();
        builder.append("Dataselect URL");
        builder.append((Component)this.wsDataselectUrlField, 9);
        builder.nextLine();
        builder.append("Station URL");
        builder.append((Component)this.wsStationUrlField, 9);
        builder.nextLine();
        builder.appendSeparator();
        JLabel scnlLabel = new JLabel("<HTML>Enter Station, Channel, Network and Location. An empty field is the same as '*'. Use -- for an empty location code. Wildcards (\"?\" for any single character and \"*\" for zero or more characters) and comma-separated lists are accepted. All Networks channels will not be displayed on the map.</HTML>");
        builder.append((Component)scnlLabel, 11);
        builder.nextLine();
        builder.append((Component)this.updateNetworkList);
        builder.append("Network");
        builder.append(this.network, 9);
        builder.nextLine();
        builder.append("");
        builder.append("Station");
        builder.append((Component)this.station, 1);
        builder.append("");
        builder.append("Gulp size");
        builder.append((Component)this.gulperSize);
        builder.append(" minutes");
        builder.nextLine();
        builder.append("");
        builder.append("Channel");
        builder.append((Component)this.channel, 1);
        builder.append("");
        builder.append("Gulp delay");
        builder.append((Component)this.gulperDelay);
        builder.append(" seconds");
        builder.nextLine();
        builder.append("");
        builder.append("Location");
        builder.append((Component)this.location, 1);
        builder.nextLine();
        builder.append(" ");
        builder.nextLine();
        builder.append(" ");
        this.panel = builder.getPanel();
    }

    private String getDefaultText(Component component) {
        String s = component == this.wsDataselectUrlField ? SwarmConfig.getInstance().fdsnDataselectURL : (component == this.wsStationUrlField ? SwarmConfig.getInstance().fdsnStationURL : "");
        return s;
    }

    protected String getNetworkText(String s) {
        return s.replaceFirst("\\s*,.*", "").trim();
    }

    private String getText(Component component) {
        Object value = component instanceof JComboBox ? ((JComboBox)component).getSelectedItem() : (component instanceof JTextComponent ? ((JTextComponent)component).getText() : component.toString());
        String s = value == null ? this.getDefaultText(component) : this.getText(value);
        if (component == this.network) {
            s = this.getNetworkText(s);
        }
        return s;
    }

    private String getText(Object value) {
        if (value != null) {
            return value.toString().trim();
        }
        return null;
    }

    protected void getWebServicesNetworks() {
        this.network.removeAllItems();
        this.network.addItem("---Updating List---");
        this.currentStationURL = this.getText(this.wsStationUrlField);
        WSNetworkClient wsc = new WSNetworkClient(this.currentStationURL);
        List<String> nets = wsc.getNetworkList();
        if (nets != null) {
            this.network.removeAllItems();
            Iterator<String> iterator = nets.iterator();
            while (iterator.hasNext()) {
                this.network.addItem(iterator.next());
            }
        }
    }

    protected void showNeedUpdate() {
        String value;
        if (this.network.getItemCount() > 0 && this.network.getSelectedItem() != null && (value = this.network.getSelectedItem().toString()).compareTo("---Need Update---") == 0) {
            return;
        }
        this.network.removeAllItems();
        this.network.addItem("---Need Update---");
    }

    protected void selectNetwork(String net) {
        if (net != null && net.length() != 0) {
            boolean found = false;
            for (int i = 0; i < this.network.getItemCount(); ++i) {
                String item = this.network.getItemAt(i);
                if (!item.startsWith(net)) continue;
                this.network.setSelectedIndex(i);
                found = true;
                break;
            }
            if (!found) {
                this.network.insertItemAt(net, 0);
                this.network.setSelectedIndex(0);
            }
        } else {
            this.network.setSelectedItem(null);
        }
    }

    public String wasOK() {
        int gs = (int)(Double.parseDouble(this.gulperSize.getText()) * 60.0);
        int gd = (int)(Double.parseDouble(this.gulperDelay.getText()) * 1000.0);
        String result = String.format(this.getCode() + ":" + "%s|%s|%s|%s|%d|%d|%s|%s", this.getText(this.network), this.getText(this.station), this.getText(this.location), this.getText(this.channel), gs, gd, this.getText(this.wsDataselectUrlField), this.getText(this.wsStationUrlField));
        SwarmConfig.getInstance().fdsnDataselectURL = this.getText(this.wsDataselectUrlField);
        SwarmConfig.getInstance().fdsnStationURL = this.getText(this.wsStationUrlField);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WSNetworkClient
    extends WebServiceStationXmlClient {
        public WSNetworkClient(String baseUrlText) {
            super(baseUrlText);
        }

        @Override
        protected String getUrlTextWithTime() {
            return this.getBaseUrlText() + "net=*&level=network&format=xml&includeavailability=false";
        }

        @Override
        protected void fetch(URL url) throws Exception {
            this.fetchNetworks(url);
        }

        @Override
        public List<String> getNetworkList() {
            try {
                this.fetch();
            }
            catch (Exception e) {
                StringBuilder msg = new StringBuilder();
                if (this.error != null && !this.error.toString().isEmpty()) {
                    msg.append(this.error.toString());
                }
                if (e != null && !e.toString().isEmpty()) {
                    if (msg.length() > 0) {
                        msg.append("\n");
                    }
                    msg.append(e.toString());
                }
                if (msg.length() == 0) {
                    msg.append("Error getting network list.");
                }
                JOptionPane.showMessageDialog(Swarm.getApplication(), msg.toString(), "Error", 0);
                return null;
            }
            return super.getNetworkList();
        }
    }
}

