/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.data;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.plot.data.HelicorderData;
import gov.usgs.plot.data.RSAMData;
import gov.usgs.plot.data.Wave;
import gov.usgs.util.Log;
import gov.usgs.volcanoes.swarm.Swarm;
import gov.usgs.volcanoes.swarm.data.GulperListener;
import gov.usgs.volcanoes.swarm.data.RsamSource;
import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCachingDataSource
extends SeismicDataSource
implements RsamSource {
    private static final int MAX_WAVE_SIZE = 1000000;
    protected static final long TO_USEC = 1000000L;
    protected static final double FROM_USEC = 1.0E-6;
    protected long maxSize;
    protected Map<String, List<CachedHelicorder>> helicorderCache = new HashMap<String, List<CachedHelicorder>>();
    protected Map<String, List<CachedWave>> waveCache = new HashMap<String, List<CachedWave>>();
    protected Map<String, List<CachedRsam>> rsamCache = new HashMap<String, List<CachedRsam>>();
    protected CachePurgeAction[] purgeActions;
    protected static Logger logger;
    protected static final JFrame applicationFrame;

    public AbstractCachingDataSource() {
        this.maxSize = Runtime.getRuntime().maxMemory() / 6L;
        logger = Log.getLogger("gov.usgs.swarm");
        this.createPurgeActions();
    }

    @Override
    public void parse(String params) {
    }

    public void flush() {
        this.flushWaves();
        this.flushHelicorders();
        System.gc();
    }

    @Override
    public boolean isActiveSource() {
        return false;
    }

    public synchronized long getSize() {
        long size = this.getSize(this.waveCache);
        size += this.getSize(this.helicorderCache);
        return size += this.getSize(this.rsamCache);
    }

    private synchronized <T extends CacheEntry> long getSize(Map<String, List<T>> cache) {
        long size = 0L;
        for (String key : cache.keySet()) {
            List<T> cwl = cache.get(key);
            for (CacheEntry ce : cwl) {
                size += (long)ce.getMemorySize();
            }
        }
        return size;
    }

    public void output() {
        long size = this.outputCache("Wave", this.waveCache);
        size += this.outputCache("Helicorder", this.helicorderCache);
        System.out.println("Wave Last Access Order:");
        List<CacheEntry> wl = this.getEntriesByLastAccess(this.waveCache);
        for (CacheEntry ce : wl) {
            System.out.println(ce.getInfoString());
        }
        System.out.println("Helicorder Last Access Order:");
        List<CacheEntry> hl = this.getEntriesByLastAccess(this.helicorderCache);
        for (CacheEntry ce : hl) {
            System.out.println(ce.getInfoString());
        }
        System.out.println("Total size: " + size + " bytes");
    }

    private synchronized <T extends CacheEntry> List<CacheEntry> getEntriesByLastAccess(Map<String, List<T>> cache) {
        ArrayList<CacheEntry> cl = new ArrayList<CacheEntry>();
        for (String key : cache.keySet()) {
            List<T> cwl = cache.get(key);
            for (CacheEntry ce : cwl) {
                cl.add(ce);
            }
        }
        return cl;
    }

    public void createPurgeActions() {
        this.purgeActions = new CachePurgeAction[]{new TimeLimitWavePurgeAction(this.waveCache, 300000L), new TimeLimitHelicorderPurgeAction(this.helicorderCache, 300000L), new TimeLimitRsamPurgeAction(this.rsamCache, 300000L), new HalveLargeWavesPurgeAction(this.waveCache, 10800), new HalveLargeWavesPurgeAction(this.waveCache, 3600), new CompleteWavePurgeAction(this.waveCache), new CompleteHelicorderPurgeAction(this.helicorderCache)};
    }

    private synchronized void enforceSize() {
        long chunk;
        if (this.purgeActions == null) {
            return;
        }
        long target = this.getSize() - this.maxSize;
        for (int i = 0; target > 0L && i < this.purgeActions.length; target -= chunk, ++i) {
            chunk = this.purgeActions[i].purge();
            Log.getLogger("gov.usgs.swarm").finer("purged " + chunk + " bytes from cache");
        }
    }

    private synchronized void putWaveInCache(String channel, Wave wave, List<CachedWave> waves) {
        if (wave.getMemorySize() > 1000000) {
            Wave[] splitWaves = wave.split();
            this.putWaveInCache(channel, splitWaves[0], waves);
            this.putWaveInCache(channel, splitWaves[1], waves);
            return;
        }
        CachedWave cw = new CachedWave();
        cw.station = channel;
        cw.t1 = wave.getStartTime();
        cw.t2 = wave.getEndTime();
        cw.wave = wave;
        cw.lastAccess = System.currentTimeMillis();
        waves.add(cw);
        this.enforceSize();
    }

    public void putRsam(String station, RSAMData rsamData) {
        List<CachedRsam> rsams = this.rsamCache.get(station);
        if (rsams == null) {
            rsams = new ArrayList<CachedRsam>();
            CachedRsam cr = new CachedRsam();
            cr.station = station;
            cr.t1 = rsamData.getStartTime();
            cr.t2 = rsamData.getEndTime();
            cr.rsamData = rsamData;
            cr.lastAccess = System.currentTimeMillis();
            rsams.add(cr);
            this.rsamCache.put(station, rsams);
            this.enforceSize();
        } else {
            boolean add = true;
            for (int i = 0; i < rsams.size(); ++i) {
                CachedRsam ch = rsams.get(i);
                if (!ch.rsamData.overlaps(rsamData) || rsamData == ch.rsamData) continue;
                rsams.remove(ch);
                RSAMData newRsam = ch.rsamData.combine(rsamData);
                this.putRsam(station, newRsam);
                rsamData = newRsam;
                i = 0;
                add = false;
            }
            if (add) {
                CachedRsam ch = new CachedRsam();
                ch.station = station;
                ch.t1 = rsamData.getStartTime();
                ch.t2 = rsamData.getEndTime();
                ch.rsamData = rsamData;
                ch.lastAccess = System.currentTimeMillis();
                rsams.add(ch);
                this.enforceSize();
            }
        }
    }

    public synchronized void putHelicorder(String station, HelicorderData helicorder) {
        List<CachedHelicorder> helis = this.helicorderCache.get(station);
        if (helis == null) {
            helis = new ArrayList<CachedHelicorder>();
            CachedHelicorder ch = new CachedHelicorder();
            ch.station = station;
            ch.t1 = helicorder.getStartTime();
            ch.t2 = helicorder.getEndTime();
            ch.helicorder = helicorder;
            ch.lastAccess = System.currentTimeMillis();
            helis.add(ch);
            this.helicorderCache.put(station, helis);
            this.enforceSize();
        } else {
            boolean add = true;
            for (int i = 0; i < helis.size(); ++i) {
                CachedHelicorder ch = helis.get(i);
                if (!ch.helicorder.overlaps(helicorder)) continue;
                HelicorderData newHeli = ch.helicorder.combine(helicorder);
                ch.t1 = newHeli.getStartTime();
                ch.t2 = newHeli.getEndTime();
                ch.helicorder = newHeli;
                ch.lastAccess = System.currentTimeMillis();
                helicorder = newHeli;
                i = 0;
                add = false;
                break;
            }
            if (add) {
                CachedHelicorder ch = new CachedHelicorder();
                ch.station = station;
                ch.t1 = helicorder.getStartTime();
                ch.t2 = helicorder.getEndTime();
                ch.helicorder = helicorder;
                ch.lastAccess = System.currentTimeMillis();
                helis.add(ch);
                this.enforceSize();
            }
        }
    }

    public synchronized void cacheWaveAsHelicorder(String station, Wave wave) {
        if (this.inHelicorderCache(station, wave.getStartTime(), wave.getEndTime())) {
            return;
        }
        int seconds = (int)Math.ceil((double)wave.numSamples() * wave.getSamplingPeriod());
        DoubleMatrix2D data = DoubleFactory2D.dense.make(seconds, 3);
        for (int i = 0; i < seconds; ++i) {
            data.setQuick(i, 1, 2.147483647E9);
            data.setQuick(i, 2, -2.147483648E9);
        }
        int sPeriod = (int)(wave.getSamplingPeriod() * 1000000.0);
        long startTime = (long)(wave.getStartTime() * 1000000.0);
        for (int sampleIndex = 0; sampleIndex < wave.numSamples(); ++sampleIndex) {
            long sampleTime = startTime + (long)(sampleIndex * sPeriod);
            int sample = wave.buffer[sampleIndex];
            if (sample == Wave.NO_DATA) continue;
            int secondIndex = (int)((sampleTime - startTime) / 1000000L);
            data.setQuick(secondIndex, 0, (double)(sampleTime / 1000000L));
            data.setQuick(secondIndex, 1, Math.min(data.getQuick(secondIndex, 1), (double)sample));
            data.setQuick(secondIndex, 2, Math.max(data.getQuick(secondIndex, 2), (double)sample));
        }
        for (int i = 0; i < seconds; ++i) {
            double max;
            double min = data.getQuick(i, 1);
            if (min == 2.147483647E9) {
                data.setQuick(i, 1, wave.mean());
            }
            if ((max = data.getQuick(i, 2)) != -2.147483648E9) continue;
            data.setQuick(i, 2, wave.mean());
        }
        HelicorderData hd = new HelicorderData();
        hd.setData(data);
        this.putHelicorder(station, hd);
    }

    public boolean isEmpty() {
        return this.helicorderCache.size() + this.waveCache.size() == 0;
    }

    public synchronized boolean inHelicorderCache(String station, double t1, double t2) {
        List<CachedHelicorder> helis = this.helicorderCache.get(station);
        if (helis == null) {
            return false;
        }
        for (CachedHelicorder ch : helis) {
            if (!(t1 >= ch.t1) || !(t2 <= ch.t2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RSAMData getRsam(String channel, double t1, double t2, int period) {
        List<CachedRsam> rsam = this.rsamCache.get(channel);
        if (rsam == null) {
            return null;
        }
        for (CachedRsam cr : rsam) {
            if (cr.rsamData.getPeriod() != period || !(t1 >= cr.t1) || !(t2 <= cr.t2)) continue;
            return cr.slice(t1, t2);
        }
        return null;
    }

    @Override
    public synchronized Wave getWave(String station, double t1, double t2) {
        List<CachedWave> waves = this.waveCache.get(station);
        if (waves == null) {
            return null;
        }
        for (CachedWave cw : waves) {
            if (!(t1 >= cw.t1) || !(t2 <= cw.t2)) continue;
            try {
                int[] newbuf = new int[(int)((t2 - t1) * cw.wave.getSamplingRate())];
                int i = (int)((t1 - cw.wave.getStartTime()) * cw.wave.getSamplingRate());
                System.arraycopy(cw.wave.buffer, i, newbuf, 0, newbuf.length);
                Wave sw = new Wave(newbuf, t1, cw.wave.getSamplingRate());
                cw.lastAccess = System.currentTimeMillis();
                return sw;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public List<String> getChannels() {
        ArrayList<String> st = new ArrayList<String>();
        for (String key : this.helicorderCache.keySet()) {
            st.add(key.replace('$', ' '));
        }
        Collections.sort(st);
        if (st.size() == 0) {
            return null;
        }
        return st;
    }

    public synchronized Wave getBestWave(String station, double t1, double t2) {
        List<CachedWave> waves = this.waveCache.get(station);
        if (waves == null) {
            return null;
        }
        ArrayList<Wave> parts = new ArrayList<Wave>();
        double minT = 1.0E300;
        double maxT = -1.0E300;
        for (CachedWave cw : waves) {
            if (!cw.wave.overlaps(t1, t2)) continue;
            parts.add(cw.wave);
            minT = Math.min(minT, cw.t1);
            maxT = Math.max(maxT, cw.t2);
        }
        if (parts.size() == 1) {
            return (Wave)parts.get(0);
        }
        Wave wave = Wave.join(parts, minT, maxT);
        if (wave != null) {
            wave = wave.subset(t1, t2);
        }
        return wave;
    }

    public synchronized void putWave(String station, Wave wave) {
        List<CachedWave> waves = this.waveCache.get(station);
        if (waves == null) {
            waves = new ArrayList<CachedWave>();
            this.waveCache.put(station, waves);
            this.putWaveInCache(station, wave, waves);
        } else {
            for (CachedWave cw : waves) {
                boolean join = false;
                if (cw.wave.adjacent(wave) && cw.wave.getMemorySize() + wave.getMemorySize() < 1000000) {
                    join = true;
                }
                if (cw.wave.overlaps(wave)) {
                    join = true;
                }
                if (!join) continue;
                Wave newWave = cw.wave.combine(wave);
                if (newWave != null) {
                    waves.remove(cw);
                    this.putWave(station, newWave);
                }
                return;
            }
            this.putWaveInCache(station, wave, waves);
        }
    }

    @Override
    public synchronized HelicorderData getHelicorder(String station, double startTime, double endTime, GulperListener gl) {
        List<CachedHelicorder> helis = this.helicorderCache.get(station = station.replace(' ', '$'));
        if (helis == null) {
            return null;
        }
        HelicorderData hd = new HelicorderData();
        HelicorderData hd2 = null;
        for (CachedHelicorder ch : helis) {
            if (startTime >= ch.t1 && endTime <= ch.t2) {
                hd2 = ch.helicorder.subset(startTime, endTime);
                ch.lastAccess = System.currentTimeMillis();
                return hd2;
            }
            if (startTime <= ch.t1 && endTime >= ch.t2) {
                hd2 = ch.helicorder;
            } else if (endTime >= ch.t1 && endTime <= ch.t2) {
                hd2 = ch.helicorder.subset(ch.t1, endTime);
            } else if (startTime >= ch.t1 && startTime <= ch.t2) {
                hd2 = ch.helicorder.subset(startTime, ch.t2);
            }
            if (hd2 == null) continue;
            hd.concatenate(hd2);
            ch.lastAccess = System.currentTimeMillis();
            hd2 = null;
        }
        hd.sort();
        if (hd.getData() == null) {
            hd = null;
        }
        return hd;
    }

    public synchronized HelicorderData getHelicorder(String station, double t1, double t2, SeismicDataSource source) {
        List<CachedHelicorder> helis = this.helicorderCache.get(station);
        if (helis == null) {
            return null;
        }
        for (CachedHelicorder ch : helis) {
            if (t1 >= ch.t1 && t2 <= ch.t2) {
                HelicorderData hd = ch.helicorder.subset(t1, t2);
                ch.lastAccess = System.currentTimeMillis();
                return hd;
            }
            if (t1 < ch.t1 && t2 > ch.t2) {
                HelicorderData nhd = source.getHelicorder(station, t1, ch.t1, null);
                HelicorderData hd = nhd != null ? ch.helicorder.combine(nhd) : ch.helicorder;
                nhd = source.getHelicorder(station, ch.t2, t2, null);
                if (nhd != null) {
                    hd = hd.combine(nhd);
                }
                ch.lastAccess = System.currentTimeMillis();
                return hd;
            }
            if (t1 < ch.t1 && t2 > ch.t1 && t2 <= ch.t2) {
                HelicorderData nhd = source.getHelicorder(station, t1, ch.t1, null);
                if (nhd != null) {
                    HelicorderData hd = ch.helicorder.combine(nhd);
                    ch.lastAccess = System.currentTimeMillis();
                    return hd;
                }
                ch.lastAccess = System.currentTimeMillis();
                return ch.helicorder;
            }
            if (!(t1 > ch.t1) || !(t1 < ch.t2) || !(t2 > ch.t2)) continue;
            HelicorderData nhd = source.getHelicorder(station, ch.t2, t2, null);
            if (nhd != null) {
                HelicorderData hd = ch.helicorder.combine(nhd);
                ch.lastAccess = System.currentTimeMillis();
                return hd;
            }
            ch.lastAccess = System.currentTimeMillis();
            return ch.helicorder;
        }
        return null;
    }

    private void flushHelicorders() {
        this.helicorderCache.clear();
        System.out.println("Helicorder Cache Flushed");
    }

    private void flushWaves() {
        this.waveCache.clear();
        System.out.println("Wave Cache Flushed");
    }

    private <T extends CacheEntry> long outputCache(String type, Map<String, List<T>> cache) {
        long size = 0L;
        System.out.println(type + " cache");
        for (String key : cache.keySet()) {
            System.out.println("\t" + key);
            List<T> cwl = cache.get(key);
            for (CacheEntry ce : cwl) {
                size += (long)ce.getMemorySize();
                System.out.println("\t\t" + ce.getInfoString());
            }
        }
        System.out.println(type + " size: " + size + " bytes");
        return size;
    }

    private synchronized <T extends CacheEntry> void removeEntryFromCache(CacheEntry ce, Map<String, List<T>> cache) {
        List<T> cl = cache.get(ce.station);
        cl.remove(ce);
        System.out.println("Removed: " + ce.getInfoString());
    }

    static {
        applicationFrame = Swarm.getApplicationFrame();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompleteHelicorderPurgeAction
    extends CachePurgeAction {
        private Map<String, List<CachedHelicorder>> cache;

        public CompleteHelicorderPurgeAction(Map<String, List<CachedHelicorder>> c) {
            this.cache = c;
        }

        @Override
        public long purge() {
            long size = AbstractCachingDataSource.this.getSize(this.cache);
            this.cache.clear();
            return size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompleteWavePurgeAction
    extends CachePurgeAction {
        private Map<String, List<CachedWave>> cache;

        public CompleteWavePurgeAction(Map<String, List<CachedWave>> c) {
            this.cache = c;
        }

        @Override
        public long purge() {
            long size = AbstractCachingDataSource.this.getSize(this.cache);
            this.cache.clear();
            return size;
        }
    }

    public class CachedRsam
    extends CacheEntry {
        public RSAMData rsamData;

        public String toString() {
            return this.station + " " + this.t1 + " " + this.t2;
        }

        public RSAMData slice(double t1, double t2) {
            if (t1 >= this.t2 || t2 <= this.t1) {
                return null;
            }
            DoubleMatrix2D d = this.rsamData.getData();
            int i = 0;
            int firstRow = Integer.MAX_VALUE;
            while (firstRow == Integer.MAX_VALUE && i < d.rows()) {
                double t = d.getQuick(i, 0);
                if (t >= t1) {
                    firstRow = i;
                    continue;
                }
                ++i;
            }
            int lastRow = -2147483647;
            while (lastRow == -2147483647 && i < d.rows()) {
                double t = d.getQuick(i, 0);
                if (t >= t2) {
                    lastRow = i;
                    continue;
                }
                ++i;
            }
            RSAMData rd = new RSAMData();
            rd.setData(d.viewPart(firstRow, 0, lastRow - firstRow, 2).copy());
            return rd;
        }

        public String getInfoString() {
            long ms = System.currentTimeMillis() - this.lastAccess;
            return "[" + ms + "ms] " + (this.t2 - this.t1) + "s, " + this.rsamData.getMemorySize() + " bytes, " + this.t1 + " => " + this.t2;
        }

        public int getMemorySize() {
            return this.rsamData.getMemorySize();
        }
    }

    public class CachedHelicorder
    extends CacheEntry {
        public HelicorderData helicorder;

        public String toString() {
            return this.station + " " + this.t1 + " " + this.t2;
        }

        public String getInfoString() {
            long ms = System.currentTimeMillis() - this.lastAccess;
            return "[" + ms + "ms] " + (this.t2 - this.t1) + "s, " + this.helicorder.getMemorySize() + " bytes, " + this.t1 + " => " + this.t2;
        }

        public int getMemorySize() {
            return this.helicorder.getMemorySize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CachedWave
    extends CacheEntry
    implements Comparable<CacheEntry> {
        public Wave wave;

        @Override
        public String getInfoString() {
            long ms = System.currentTimeMillis() - this.lastAccess;
            return "[" + ms + "ms] " + (this.t2 - this.t1) + "s, " + this.wave.getMemorySize() + " bytes, " + this.t1 + " => " + this.t2;
        }

        @Override
        public int getMemorySize() {
            return this.wave.getMemorySize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class CacheEntry
    implements Comparable<CacheEntry> {
        public String station;
        public double t1;
        public double t2;
        public long lastAccess;

        private CacheEntry() {
        }

        @Override
        public int compareTo(CacheEntry oce) {
            return (int)(this.lastAccess - oce.lastAccess);
        }

        public abstract String getInfoString();

        public abstract int getMemorySize();
    }

    protected abstract class CachePurgeAction {
        public abstract long purge();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TimeLimitRsamPurgeAction
    extends CachePurgeAction {
        private long interval;
        private Map<String, List<CachedRsam>> cache;

        public TimeLimitRsamPurgeAction(Map<String, List<CachedRsam>> c, long i) {
            this.cache = c;
            this.interval = i;
        }

        @Override
        public long purge() {
            List items = AbstractCachingDataSource.this.getEntriesByLastAccess(this.cache);
            long chunk = 0L;
            long now = System.currentTimeMillis();
            for (CacheEntry ce : items) {
                if (now - ce.lastAccess <= this.interval) continue;
                AbstractCachingDataSource.this.removeEntryFromCache(ce, this.cache);
                chunk += (long)ce.getMemorySize();
            }
            return chunk;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TimeLimitHelicorderPurgeAction
    extends CachePurgeAction {
        private long interval;
        private Map<String, List<CachedHelicorder>> cache;

        public TimeLimitHelicorderPurgeAction(Map<String, List<CachedHelicorder>> c, long i) {
            this.cache = c;
            this.interval = i;
        }

        @Override
        public long purge() {
            List items = AbstractCachingDataSource.this.getEntriesByLastAccess(this.cache);
            long chunk = 0L;
            long now = System.currentTimeMillis();
            for (CacheEntry ce : items) {
                if (now - ce.lastAccess <= this.interval) continue;
                AbstractCachingDataSource.this.removeEntryFromCache(ce, this.cache);
                chunk += (long)ce.getMemorySize();
            }
            return chunk;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TimeLimitWavePurgeAction
    extends CachePurgeAction {
        private long interval;
        private Map<String, List<CachedWave>> cache;

        public TimeLimitWavePurgeAction(Map<String, List<CachedWave>> c, long i) {
            this.cache = c;
            this.interval = i;
        }

        @Override
        public long purge() {
            List items = AbstractCachingDataSource.this.getEntriesByLastAccess(this.cache);
            long chunk = 0L;
            long now = System.currentTimeMillis();
            for (CacheEntry ce : items) {
                if (now - ce.lastAccess <= this.interval) continue;
                AbstractCachingDataSource.this.removeEntryFromCache(ce, this.cache);
                chunk += (long)ce.getMemorySize();
            }
            return chunk;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HalveLargeWavesPurgeAction
    extends CachePurgeAction {
        private int maxTime;
        private Map<String, List<CachedWave>> cache;

        public HalveLargeWavesPurgeAction(Map<String, List<CachedWave>> c, int m) {
            this.cache = c;
            this.maxTime = m;
        }

        @Override
        public long purge() {
            List items = AbstractCachingDataSource.this.getEntriesByLastAccess(this.cache);
            long chunk = 0L;
            for (CacheEntry ce : items) {
                CachedWave cw = (CachedWave)ce;
                if (!(cw.wave.getEndTime() - cw.wave.getStartTime() > (double)this.maxTime)) continue;
                long before = cw.getMemorySize();
                double nst = cw.wave.getEndTime() - (cw.wave.getEndTime() - cw.wave.getStartTime()) / 2.0;
                cw.wave = cw.wave.subset(nst, cw.wave.getEndTime());
                cw.t1 = cw.wave.getStartTime();
                cw.t2 = cw.wave.getEndTime();
                chunk += (long)cw.getMemorySize() - before;
            }
            return chunk;
        }
    }
}

