/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.data;

import gov.usgs.plot.data.HelicorderData;
import gov.usgs.plot.data.Wave;
import gov.usgs.util.UtilException;
import gov.usgs.volcanoes.swarm.data.CachedDataSource;
import gov.usgs.volcanoes.swarm.data.DataSourceType;
import gov.usgs.volcanoes.swarm.data.GulperListener;
import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import gov.usgs.winston.Channel;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.Data;
import gov.usgs.winston.db.WinstonDatabase;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectWWSSource
extends SeismicDataSource {
    private String dbDriver;
    private String dbURL;
    private String dbPrefix;
    private WinstonDatabase winston;
    private Data data;
    private Channels stations;

    @Override
    public void parse(String params) {
        String[] ss = params.split("|");
        this.dbDriver = ss[0];
        this.dbURL = ss[1];
        this.dbPrefix = ss[2];
        this.winston = new WinstonDatabase(this.dbDriver, this.dbURL, this.dbPrefix);
        this.stations = new Channels(this.winston);
        this.data = new Data(this.winston);
    }

    @Override
    public void close() {
        this.winston.close();
    }

    @Override
    public synchronized Wave getWave(String station, double t1, double t2) {
        CachedDataSource cache = CachedDataSource.getInstance();
        Wave sw = cache.getWave(station, t1, t2);
        if (sw == null) {
            try {
                sw = this.data.getWave(station, t1, t2, 0);
            }
            catch (UtilException e) {
                // empty catch block
            }
            if (sw != null && !sw.isData()) {
                sw = null;
            }
            if (sw != null && sw.buffer != null && sw.buffer.length > 0) {
                cache.putWave(station, sw);
            }
        }
        return sw;
    }

    @Override
    public synchronized List<String> getChannels() {
        List<Channel> chs = this.stations.getChannels();
        ArrayList<String> result = new ArrayList<String>();
        for (Channel ch : chs) {
            result.add(ch.toString());
        }
        return result;
    }

    @Override
    public synchronized HelicorderData getHelicorder(String station, double t1, double t2, GulperListener gl) {
        CachedDataSource cache = CachedDataSource.getInstance();
        HelicorderData hd = cache.getHelicorder(station, t1, t2, this);
        if (hd == null) {
            try {
                hd = this.data.getHelicorderData(station, t1, t2, 0);
            }
            catch (UtilException e) {
                // empty catch block
            }
            if (hd != null && hd.rows() != 0) {
                cache.putHelicorder(station, hd);
            } else {
                hd = null;
            }
        }
        return hd;
    }

    @Override
    public String toConfigString() {
        String typeString = DataSourceType.getShortName(this.getClass());
        return String.format("%s;%s:%s|%s|%s", this.name, typeString, this.dbDriver, this.dbURL, this.dbPrefix);
    }
}

