/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.data;

import gov.usgs.plot.data.HelicorderData;
import gov.usgs.plot.data.Wave;
import gov.usgs.volcanoes.swarm.data.Gulper;
import gov.usgs.volcanoes.swarm.data.GulperList;
import gov.usgs.volcanoes.swarm.data.GulperListener;
import gov.usgs.volcanoes.swarm.data.SeismicDataSourceListener;
import java.util.List;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SeismicDataSource {
    protected String name = "Unnamed Data Source";
    protected boolean storeInUserConfig = true;
    protected boolean useCache = true;
    protected int minimumRefreshInterval = 1;
    protected EventListenerList listeners = new EventListenerList();

    public Gulper createGulper(GulperList gl, String k, String ch, double t1, double t2, int size, int delay) {
        return new Gulper(gl, k, this, ch, t1, t2, size, delay);
    }

    public abstract List<String> getChannels();

    public abstract void parse(String var1);

    public abstract Wave getWave(String var1, double var2, double var4);

    public abstract HelicorderData getHelicorder(String var1, double var2, double var4, GulperListener var6);

    public abstract String toConfigString();

    protected SeismicDataSource() {
    }

    public void addListener(SeismicDataSourceListener l) {
        this.listeners.add(SeismicDataSourceListener.class, l);
    }

    public void removeListener(SeismicDataSourceListener l) {
        this.listeners.remove(SeismicDataSourceListener.class, l);
    }

    public void fireChannelsUpdated() {
        Object[] ls = this.listeners.getListenerList();
        for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != SeismicDataSourceListener.class) continue;
            ((SeismicDataSourceListener)ls[i + 1]).channelsUpdated();
        }
    }

    public void fireChannelsProgress(String id, double p) {
        Object[] ls = this.listeners.getListenerList();
        for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != SeismicDataSourceListener.class) continue;
            ((SeismicDataSourceListener)ls[i + 1]).channelsProgress(id, p);
        }
    }

    public void fireHelicorderProgress(String id, double p) {
        Object[] ls = this.listeners.getListenerList();
        for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != SeismicDataSourceListener.class) continue;
            ((SeismicDataSourceListener)ls[i + 1]).helicorderProgress(id, p);
        }
    }

    public void notifyDataNotNeeded(String station, double t1, double t2, GulperListener gl) {
    }

    public void setStoreInUserConfig(boolean b) {
        this.storeInUserConfig = b;
    }

    public boolean isStoreInUserConfig() {
        return this.storeInUserConfig;
    }

    public void setUseCache(boolean b) {
        this.useCache = b;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public boolean isActiveSource() {
        return false;
    }

    public void close() {
    }

    public void remove() {
    }

    public SeismicDataSource getCopy() {
        return this;
    }

    public String toString() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    public void establish() {
    }

    public int getMinimumRefreshInterval() {
        return this.minimumRefreshInterval;
    }
}

