/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.data.fdsnWs;

import gov.usgs.volcanoes.swarm.ChannelGroupInfo;
import gov.usgs.volcanoes.swarm.ChannelInfo;
import gov.usgs.volcanoes.swarm.GroupsType;
import gov.usgs.volcanoes.swarm.StationInfo;
import gov.usgs.volcanoes.swarm.data.fdsnWs.WebServiceUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebServiceStationClient {
    public static final String DEFAULT_WS_URL = "http://service.iris.edu/fdsnws/station/1/query";
    private static final String separatorText = "&";
    private static final String equalsText = "=";
    private static final String startTimeText = "starttime";
    private BufferedReader reader;
    protected HttpURLConnection conn;
    protected final StringBuilder error = new StringBuilder();
    private final String baseUrlText;
    private final String net;
    private final String sta;
    public final String loc;
    private final String chan;
    private final Date date;
    protected final GroupsType groupsType;
    private OutputLevel level = OutputLevel.CHANNEL;
    private StationInfo currentStation;
    private List<StationInfo> stationList;
    private List<String> channelList;
    private List<String> networkList;

    public static List<String> createChannelList() {
        return AbstractWebServiceStationClient.createList();
    }

    public static <T> List<T> createList() {
        return new ArrayList();
    }

    public static List<StationInfo> createStationList() {
        return AbstractWebServiceStationClient.createList();
    }

    protected static String getArg(String[] args, int index) {
        return AbstractWebServiceStationClient.getArg(args, index, null);
    }

    protected static String getArg(String[] args, int index, String def) {
        if (args.length > index) {
            return args[index];
        }
        return def;
    }

    public AbstractWebServiceStationClient(String baseUrlText, String net, String sta, String loc, String chan, Date date) {
        this.baseUrlText = baseUrlText;
        this.net = net;
        this.sta = sta;
        this.loc = loc;
        this.chan = chan;
        this.date = date;
        this.groupsType = GroupsType.NETWORK;
    }

    public AbstractWebServiceStationClient(String baseUrlText) {
        this.baseUrlText = baseUrlText;
        this.net = null;
        this.sta = null;
        this.loc = null;
        this.chan = null;
        this.date = null;
        this.groupsType = GroupsType.NETWORK;
    }

    protected String append(String s, String name, Object value) {
        if (value instanceof Date) {
            value = WebServiceUtils.getDateText((Date)value);
        }
        if (value == null || value.toString().length() == 0) {
            return s;
        }
        if (s.length() > 0) {
            s = s + separatorText;
        }
        s = s + name + equalsText + value.toString();
        return s;
    }

    public void clearError() {
        this.error.setLength(0);
    }

    protected boolean clearLatLon() {
        return this.isAllNetworks();
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.conn != null) {
            this.conn.disconnect();
            this.conn = null;
        }
    }

    protected ChannelInfo createChannelInfo(String station, String channel, String network, String location, double latitude, double longitude, String siteName, GroupsType groupsType) {
        if (this.currentStation == null) {
            if (this.clearLatLon()) {
                latitude = Double.NaN;
                longitude = Double.NaN;
            }
            return new ChannelGroupInfo(station, channel, network, location, latitude, longitude, siteName, groupsType);
        }
        return new ChannelGroupInfo(this.currentStation, channel, location, groupsType);
    }

    protected StationInfo createStationInfo(String station, String network, double latitude, double longitude, String siteName) {
        if (this.clearLatLon()) {
            latitude = Double.NaN;
            longitude = Double.NaN;
        }
        return new StationInfo(station, network, latitude, longitude, siteName);
    }

    protected void fetch() throws Exception {
        URL url = this.getURL();
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof HttpURLConnection) {
            this.conn = (HttpURLConnection)urlConn;
            if (this.conn.getResponseCode() != 200) {
                this.error.append("Error in connection with url: " + url);
                InputStream in = this.conn.getErrorStream();
                if (in != null) {
                    String line;
                    BufferedReader errorReader = new BufferedReader(new InputStreamReader(in));
                    while ((line = this.readLine(errorReader)) != null) {
                        this.error.append("\n" + line);
                    }
                    errorReader.close();
                }
                return;
            }
            this.fetch(url);
        }
    }

    protected abstract void fetch(URL var1) throws Exception;

    public String fetchChannels() {
        this.clearError();
        try {
            this.setLevel(OutputLevel.CHANNEL);
            this.fetch();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.close();
        String error = this.getError();
        this.clearError();
        return error.length() == 0 ? null : error;
    }

    public String fetchStations() {
        this.clearError();
        try {
            this.setLevel(OutputLevel.STATION);
            this.fetch();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.close();
        String error = this.getError();
        this.clearError();
        return error.length() == 0 ? null : error;
    }

    protected String getBaseUrlText() {
        return this.baseUrlText + "?";
    }

    public List<String> getChannelList() {
        return this.channelList;
    }

    public List<String> getNetworkList() {
        return this.networkList;
    }

    public StationInfo getCurrentStation() {
        return this.currentStation;
    }

    public String getError() {
        return this.error.toString();
    }

    public OutputLevel getLevel() {
        return this.level;
    }

    public BufferedReader getReader() throws IOException {
        BufferedReader reader = this.reader;
        if (reader == null) {
            this.reader = reader = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
        }
        return reader;
    }

    public List<StationInfo> getStationList() {
        return this.stationList;
    }

    protected URL getURL() throws MalformedURLException {
        return new URL(this.getUrlTextWithTime());
    }

    protected String getUrlText() {
        String urlText = this.getBaseUrlText();
        urlText = this.append(urlText, "level", (Object)this.level);
        if (this.currentStation == null) {
            urlText = this.append(urlText, "network", this.net);
            urlText = this.append(urlText, "station", this.sta);
        } else {
            urlText = this.append(urlText, "network", this.currentStation.getNetwork());
            urlText = this.append(urlText, "station", this.currentStation.getStation());
        }
        urlText = this.append(urlText, "location", this.loc);
        urlText = this.append(urlText, "channel", this.chan);
        urlText = this.append(urlText, startTimeText, this.date);
        return urlText;
    }

    protected String getUrlTextWithTime() {
        String urlText = this.getUrlText();
        if (!urlText.contains(startTimeText)) {
            urlText = this.append(urlText, startTimeText, new Date());
        }
        return urlText;
    }

    protected boolean isAllNetworks() {
        return this.net == null || this.net.length() == 0 || this.net.equals("*");
    }

    public void processChannel(ChannelInfo ch) {
        if (this.channelList == null) {
            System.out.println(ch);
        } else {
            this.channelList.add(ch.toString());
        }
    }

    public void processStation(StationInfo si) {
        if (this.stationList == null) {
            System.out.println(si);
        } else {
            this.stationList.add(si);
        }
    }

    protected String readLine(BufferedReader reader) {
        try {
            return reader.readLine();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setChannelList(List<String> channelList) {
        this.channelList = channelList;
    }

    public void setNetworkList(List<String> networkList) {
        this.networkList = networkList;
    }

    public void setCurrentStation(StationInfo station) {
        this.currentStation = station;
    }

    public void setLevel(OutputLevel level) {
        this.level = level;
    }

    public void setStationList(List<StationInfo> stationList) {
        this.stationList = stationList;
    }

    protected boolean useOnlyChannels() {
        return this.isAllNetworks();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputLevel {
        NETWORK("network"),
        STATION("station"),
        CHANNEL("channel"),
        RESPONSE("response");

        private final String s;

        private OutputLevel(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

